/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.multi.factor.authentication.fido2.credential.service.impl;

import com.liferay.multi.factor.authentication.fido2.credential.exception.DuplicateMFAFIDO2CredentialEntryException;
import com.liferay.multi.factor.authentication.fido2.credential.exception.NoSuchMFAFIDO2CredentialEntryException;
import com.liferay.multi.factor.authentication.fido2.credential.model.MFAFIDO2CredentialEntry;
import com.liferay.multi.factor.authentication.fido2.credential.service.base.MFAFIDO2CredentialEntryLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.multi.factor.authentication.fido2.credential.model.MFAFIDO2CredentialEntry"}, service={AopService.class})
public class MFAFIDO2CredentialEntryLocalServiceImpl
extends MFAFIDO2CredentialEntryLocalServiceBaseImpl {
    public MFAFIDO2CredentialEntry addMFAFIDO2CredentialEntry(long userId, String credentialKey, int credentialType, String publicKeyCOSE) throws PortalException {
        MFAFIDO2CredentialEntry mfaFIDO2CredentialEntry = this.mfaFIDO2CredentialEntryPersistence.fetchByU_C(userId, credentialKey);
        if (mfaFIDO2CredentialEntry != null) {
            throw new DuplicateMFAFIDO2CredentialEntryException(StringBundler.concat((Object[])new Object[]{"{credentialKey=", credentialKey, ", userId=", userId, "}"}));
        }
        mfaFIDO2CredentialEntry = this.mfaFIDO2CredentialEntryPersistence.create(this.counterLocalService.increment());
        User user = this.userLocalService.getUserById(userId);
        mfaFIDO2CredentialEntry.setCompanyId(user.getCompanyId());
        mfaFIDO2CredentialEntry.setUserId(userId);
        mfaFIDO2CredentialEntry.setUserName(user.getFullName());
        mfaFIDO2CredentialEntry.setCreateDate(new Date());
        mfaFIDO2CredentialEntry.setCredentialKey(credentialKey);
        mfaFIDO2CredentialEntry.setCredentialType(credentialType);
        mfaFIDO2CredentialEntry.setPublicKeyCOSE(publicKeyCOSE);
        mfaFIDO2CredentialEntry.setSignatureCount(0L);
        return (MFAFIDO2CredentialEntry)this.mfaFIDO2CredentialEntryPersistence.update((BaseModel)mfaFIDO2CredentialEntry);
    }

    public MFAFIDO2CredentialEntry fetchMFAFIDO2CredentialEntryByUserIdAndCredentialKey(long userId, String credentialKey) {
        return this.mfaFIDO2CredentialEntryPersistence.fetchByU_C(userId, credentialKey);
    }

    public List<MFAFIDO2CredentialEntry> getMFAFIDO2CredentialEntriesByCredentialKey(String credentialKey) {
        return this.mfaFIDO2CredentialEntryPersistence.findByCredentialKey(credentialKey);
    }

    public List<MFAFIDO2CredentialEntry> getMFAFIDO2CredentialEntriesByUserId(long userId) {
        return this.mfaFIDO2CredentialEntryPersistence.findByUserId(userId);
    }

    public MFAFIDO2CredentialEntry updateAttempts(long userId, String credentialKey, long signatureCount) throws PortalException {
        MFAFIDO2CredentialEntry mfaFIDO2CredentialEntry = this.mfaFIDO2CredentialEntryPersistence.fetchByU_C(userId, credentialKey);
        if (mfaFIDO2CredentialEntry == null) {
            throw new NoSuchMFAFIDO2CredentialEntryException(StringBundler.concat((Object[])new Object[]{"{credentialKey=", credentialKey, ", userId=", userId, "}"}));
        }
        if (signatureCount < 1L) {
            mfaFIDO2CredentialEntry.setFailedAttempts(mfaFIDO2CredentialEntry.getFailedAttempts() + 1);
            mfaFIDO2CredentialEntry.setSignatureCount(0L);
        } else {
            mfaFIDO2CredentialEntry.setFailedAttempts(0);
            mfaFIDO2CredentialEntry.setSignatureCount(signatureCount);
        }
        return (MFAFIDO2CredentialEntry)this.mfaFIDO2CredentialEntryPersistence.update((BaseModel)mfaFIDO2CredentialEntry);
    }
}

