/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.persistence.impl;

import com.liferay.mobile.device.rules.exception.NoSuchRuleException;
import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleTable;
import com.liferay.mobile.device.rules.model.impl.MDRRuleImpl;
import com.liferay.mobile.device.rules.model.impl.MDRRuleModelImpl;
import com.liferay.mobile.device.rules.service.persistence.MDRRulePersistence;
import com.liferay.mobile.device.rules.service.persistence.MDRRuleUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={MDRRulePersistence.class})
public class MDRRulePersistenceImpl
extends BasePersistenceImpl<MDRRule>
implements MDRRulePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = MDRRuleImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "mdrRule.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(mdrRule.uuid IS NULL OR mdrRule.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "mdrRule.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(mdrRule.uuid IS NULL OR mdrRule.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "mdrRule.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "mdrRule.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(mdrRule.uuid IS NULL OR mdrRule.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "mdrRule.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByRuleGroupId;
    private FinderPath _finderPathWithoutPaginationFindByRuleGroupId;
    private FinderPath _finderPathCountByRuleGroupId;
    private static final String _FINDER_COLUMN_RULEGROUPID_RULEGROUPID_2 = "mdrRule.ruleGroupId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_MDRRULE = "SELECT mdrRule FROM MDRRule mdrRule";
    private static final String _SQL_SELECT_MDRRULE_WHERE = "SELECT mdrRule FROM MDRRule mdrRule WHERE ";
    private static final String _SQL_COUNT_MDRRULE = "SELECT COUNT(mdrRule) FROM MDRRule mdrRule";
    private static final String _SQL_COUNT_MDRRULE_WHERE = "SELECT COUNT(mdrRule) FROM MDRRule mdrRule WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "mdrRule.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No MDRRule exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No MDRRule exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(MDRRulePersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid", "type"});
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<MDRRule> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<MDRRule> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<MDRRule> findByUuid(String uuid, int start, int end, OrderByComparator<MDRRule> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<MDRRule> findByUuid(String uuid, int start, int end, OrderByComparator<MDRRule> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (MDRRule mdrRule : list) {
                if (uuid.equals(mdrRule.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_MDRRULE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY mdrRule.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public MDRRule findByUuid_First(String uuid, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        MDRRule mdrRule = this.fetchByUuid_First(uuid, orderByComparator);
        if (mdrRule != null) {
            return mdrRule;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchRuleException(sb.toString());
    }

    public MDRRule fetchByUuid_First(String uuid, OrderByComparator<MDRRule> orderByComparator) {
        List<MDRRule> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MDRRule findByUuid_Last(String uuid, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        MDRRule mdrRule = this.fetchByUuid_Last(uuid, orderByComparator);
        if (mdrRule != null) {
            return mdrRule;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchRuleException(sb.toString());
    }

    public MDRRule fetchByUuid_Last(String uuid, OrderByComparator<MDRRule> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<MDRRule> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MDRRule[] findByUuid_PrevAndNext(long ruleId, String uuid, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        uuid = Objects.toString(uuid, "");
        MDRRule mdrRule = this.findByPrimaryKey(ruleId);
        Session session = null;
        try {
            session = this.openSession();
            MDRRule[] array = new MDRRuleImpl[]{this.getByUuid_PrevAndNext(session, mdrRule, uuid, orderByComparator, true), mdrRule, this.getByUuid_PrevAndNext(session, mdrRule, uuid, orderByComparator, false)};
            MDRRule[] mDRRuleArray = array;
            return mDRRuleArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected MDRRule getByUuid_PrevAndNext(Session session, MDRRule mdrRule, String uuid, OrderByComparator<MDRRule> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_MDRRULE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY mdrRule.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)mdrRule)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (MDRRule)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (MDRRule mdrRule : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)mdrRule);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_MDRRULE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MDRRule findByUUID_G(String uuid, long groupId) throws NoSuchRuleException {
        MDRRule mdrRule = this.fetchByUUID_G(uuid, groupId);
        if (mdrRule == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchRuleException(sb.toString());
        }
        return mdrRule;
    }

    public MDRRule fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public MDRRule fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        MDRRule mdrRule;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof MDRRule && (!Objects.equals(uuid, (mdrRule = (MDRRule)result).getUuid()) || groupId != mdrRule.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_MDRRULE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mdrRule.uuid IS NULL OR mdrRule.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mdrRule.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    MDRRule mdrRule2 = (MDRRule)list.get(0);
                    result = mdrRule2;
                    this.cacheResult(mdrRule2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (MDRRule)result;
    }

    public MDRRule removeByUUID_G(String uuid, long groupId) throws NoSuchRuleException {
        MDRRule mdrRule = this.findByUUID_G(uuid, groupId);
        return (MDRRule)this.remove((BaseModel)mdrRule);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_MDRRULE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mdrRule.uuid IS NULL OR mdrRule.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mdrRule.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<MDRRule> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<MDRRule> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<MDRRule> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<MDRRule> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<MDRRule> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<MDRRule> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (MDRRule mdrRule : list) {
                if (uuid.equals(mdrRule.getUuid()) && companyId == mdrRule.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_MDRRULE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mdrRule.uuid IS NULL OR mdrRule.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mdrRule.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY mdrRule.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public MDRRule findByUuid_C_First(String uuid, long companyId, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        MDRRule mdrRule = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (mdrRule != null) {
            return mdrRule;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchRuleException(sb.toString());
    }

    public MDRRule fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<MDRRule> orderByComparator) {
        List<MDRRule> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MDRRule findByUuid_C_Last(String uuid, long companyId, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        MDRRule mdrRule = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (mdrRule != null) {
            return mdrRule;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchRuleException(sb.toString());
    }

    public MDRRule fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<MDRRule> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<MDRRule> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MDRRule[] findByUuid_C_PrevAndNext(long ruleId, String uuid, long companyId, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        uuid = Objects.toString(uuid, "");
        MDRRule mdrRule = this.findByPrimaryKey(ruleId);
        Session session = null;
        try {
            session = this.openSession();
            MDRRule[] array = new MDRRuleImpl[]{this.getByUuid_C_PrevAndNext(session, mdrRule, uuid, companyId, orderByComparator, true), mdrRule, this.getByUuid_C_PrevAndNext(session, mdrRule, uuid, companyId, orderByComparator, false)};
            MDRRule[] mDRRuleArray = array;
            return mDRRuleArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected MDRRule getByUuid_C_PrevAndNext(Session session, MDRRule mdrRule, String uuid, long companyId, OrderByComparator<MDRRule> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_MDRRULE_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(mdrRule.uuid IS NULL OR mdrRule.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("mdrRule.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY mdrRule.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)mdrRule)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (MDRRule)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (MDRRule mdrRule : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)mdrRule);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_MDRRULE_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(mdrRule.uuid IS NULL OR mdrRule.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("mdrRule.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<MDRRule> findByRuleGroupId(long ruleGroupId) {
        return this.findByRuleGroupId(ruleGroupId, -1, -1, null);
    }

    public List<MDRRule> findByRuleGroupId(long ruleGroupId, int start, int end) {
        return this.findByRuleGroupId(ruleGroupId, start, end, null);
    }

    public List<MDRRule> findByRuleGroupId(long ruleGroupId, int start, int end, OrderByComparator<MDRRule> orderByComparator) {
        return this.findByRuleGroupId(ruleGroupId, start, end, orderByComparator, true);
    }

    public List<MDRRule> findByRuleGroupId(long ruleGroupId, int start, int end, OrderByComparator<MDRRule> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByRuleGroupId;
                finderArgs = new Object[]{ruleGroupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByRuleGroupId;
            finderArgs = new Object[]{ruleGroupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (MDRRule mdrRule : list) {
                if (ruleGroupId == mdrRule.getRuleGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_MDRRULE_WHERE);
            sb.append(_FINDER_COLUMN_RULEGROUPID_RULEGROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY mdrRule.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ruleGroupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public MDRRule findByRuleGroupId_First(long ruleGroupId, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        MDRRule mdrRule = this.fetchByRuleGroupId_First(ruleGroupId, orderByComparator);
        if (mdrRule != null) {
            return mdrRule;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ruleGroupId=");
        sb.append(ruleGroupId);
        sb.append("}");
        throw new NoSuchRuleException(sb.toString());
    }

    public MDRRule fetchByRuleGroupId_First(long ruleGroupId, OrderByComparator<MDRRule> orderByComparator) {
        List<MDRRule> list = this.findByRuleGroupId(ruleGroupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MDRRule findByRuleGroupId_Last(long ruleGroupId, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        MDRRule mdrRule = this.fetchByRuleGroupId_Last(ruleGroupId, orderByComparator);
        if (mdrRule != null) {
            return mdrRule;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ruleGroupId=");
        sb.append(ruleGroupId);
        sb.append("}");
        throw new NoSuchRuleException(sb.toString());
    }

    public MDRRule fetchByRuleGroupId_Last(long ruleGroupId, OrderByComparator<MDRRule> orderByComparator) {
        int count = this.countByRuleGroupId(ruleGroupId);
        if (count == 0) {
            return null;
        }
        List<MDRRule> list = this.findByRuleGroupId(ruleGroupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public MDRRule[] findByRuleGroupId_PrevAndNext(long ruleId, long ruleGroupId, OrderByComparator<MDRRule> orderByComparator) throws NoSuchRuleException {
        MDRRule mdrRule = this.findByPrimaryKey(ruleId);
        Session session = null;
        try {
            session = this.openSession();
            MDRRule[] array = new MDRRuleImpl[]{this.getByRuleGroupId_PrevAndNext(session, mdrRule, ruleGroupId, orderByComparator, true), mdrRule, this.getByRuleGroupId_PrevAndNext(session, mdrRule, ruleGroupId, orderByComparator, false)};
            MDRRule[] mDRRuleArray = array;
            return mDRRuleArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected MDRRule getByRuleGroupId_PrevAndNext(Session session, MDRRule mdrRule, long ruleGroupId, OrderByComparator<MDRRule> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_MDRRULE_WHERE);
        sb.append(_FINDER_COLUMN_RULEGROUPID_RULEGROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY mdrRule.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(ruleGroupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)mdrRule)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (MDRRule)list.get(1);
        }
        return null;
    }

    public void removeByRuleGroupId(long ruleGroupId) {
        for (MDRRule mdrRule : this.findByRuleGroupId(ruleGroupId, -1, -1, null)) {
            this.remove((BaseModel)mdrRule);
        }
    }

    public int countByRuleGroupId(long ruleGroupId) {
        FinderPath finderPath = this._finderPathCountByRuleGroupId;
        Object[] finderArgs = new Object[]{ruleGroupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_MDRRULE_WHERE);
            sb.append(_FINDER_COLUMN_RULEGROUPID_RULEGROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ruleGroupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public MDRRulePersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(MDRRule.class);
        this.setModelImplClass(MDRRuleImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)MDRRuleTable.INSTANCE);
    }

    public void cacheResult(MDRRule mdrRule) {
        this.entityCache.putResult(MDRRuleImpl.class, (Serializable)Long.valueOf(mdrRule.getPrimaryKey()), (Serializable)mdrRule);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{mdrRule.getUuid(), mdrRule.getGroupId()}, (Object)mdrRule);
    }

    public void cacheResult(List<MDRRule> mdrRules) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && mdrRules.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (MDRRule mdrRule : mdrRules) {
            if (this.entityCache.getResult(MDRRuleImpl.class, (Serializable)Long.valueOf(mdrRule.getPrimaryKey())) != null) continue;
            this.cacheResult(mdrRule);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(MDRRuleImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(MDRRule mdrRule) {
        this.entityCache.removeResult(MDRRuleImpl.class, (BaseModel)mdrRule);
    }

    public void clearCache(List<MDRRule> mdrRules) {
        for (MDRRule mdrRule : mdrRules) {
            this.entityCache.removeResult(MDRRuleImpl.class, (BaseModel)mdrRule);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(MDRRuleImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(MDRRuleModelImpl mdrRuleModelImpl) {
        Object[] args = new Object[]{mdrRuleModelImpl.getUuid(), mdrRuleModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)mdrRuleModelImpl, false);
    }

    public MDRRule create(long ruleId) {
        MDRRuleImpl mdrRule = new MDRRuleImpl();
        mdrRule.setNew(true);
        mdrRule.setPrimaryKey(ruleId);
        String uuid = PortalUUIDUtil.generate();
        mdrRule.setUuid(uuid);
        mdrRule.setCompanyId(CompanyThreadLocal.getCompanyId());
        return mdrRule;
    }

    public MDRRule remove(long ruleId) throws NoSuchRuleException {
        return this.remove(Long.valueOf(ruleId));
    }

    public MDRRule remove(Serializable primaryKey) throws NoSuchRuleException {
        Session session = null;
        try {
            session = this.openSession();
            MDRRule mdrRule = (MDRRule)session.get(MDRRuleImpl.class, primaryKey);
            if (mdrRule == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRuleException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            MDRRule mDRRule = (MDRRule)this.remove((BaseModel)mdrRule);
            return mDRRule;
        }
        catch (NoSuchRuleException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected MDRRule removeImpl(MDRRule mdrRule) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)mdrRule)) {
                mdrRule = (MDRRule)session.get(MDRRuleImpl.class, mdrRule.getPrimaryKeyObj());
            }
            if (mdrRule != null) {
                session.delete((Object)mdrRule);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (mdrRule != null) {
            this.clearCache(mdrRule);
        }
        return mdrRule;
    }

    public MDRRule updateImpl(MDRRule mdrRule) {
        boolean isNew = mdrRule.isNew();
        if (!(mdrRule instanceof MDRRuleModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(mdrRule.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)mdrRule);
                throw new IllegalArgumentException("Implement ModelWrapper in mdrRule proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom MDRRule implementation " + mdrRule.getClass());
        }
        MDRRuleModelImpl mdrRuleModelImpl = (MDRRuleModelImpl)mdrRule;
        if (Validator.isNull((String)mdrRule.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            mdrRule.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && mdrRule.getCreateDate() == null) {
            if (serviceContext == null) {
                mdrRule.setCreateDate(date);
            } else {
                mdrRule.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!mdrRuleModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                mdrRule.setModifiedDate(date);
            } else {
                mdrRule.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)mdrRule);
            } else {
                mdrRule = (MDRRule)session.merge((Object)mdrRule);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(MDRRuleImpl.class, (BaseModel)mdrRuleModelImpl, false, true);
        this.cacheUniqueFindersCache(mdrRuleModelImpl);
        if (isNew) {
            mdrRule.setNew(false);
        }
        mdrRule.resetOriginalValues();
        return mdrRule;
    }

    public MDRRule findByPrimaryKey(Serializable primaryKey) throws NoSuchRuleException {
        MDRRule mdrRule = (MDRRule)this.fetchByPrimaryKey(primaryKey);
        if (mdrRule == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRuleException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return mdrRule;
    }

    public MDRRule findByPrimaryKey(long ruleId) throws NoSuchRuleException {
        return this.findByPrimaryKey(Long.valueOf(ruleId));
    }

    public MDRRule fetchByPrimaryKey(long ruleId) {
        return (MDRRule)this.fetchByPrimaryKey(Long.valueOf(ruleId));
    }

    public List<MDRRule> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<MDRRule> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<MDRRule> findAll(int start, int end, OrderByComparator<MDRRule> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<MDRRule> findAll(int start, int end, OrderByComparator<MDRRule> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_MDRRULE);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_MDRRULE;
                sql = sql.concat(" ORDER BY mdrRule.createDate ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (MDRRule mdrRule : this.findAll()) {
            this.remove((BaseModel)mdrRule);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_MDRRULE);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "ruleId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_MDRRULE;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return MDRRuleModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new MDRRuleModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)MDRRule.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByRuleGroupId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByRuleGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"ruleGroupId"}, true);
        this._finderPathWithoutPaginationFindByRuleGroupId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByRuleGroupId", new String[]{Long.class.getName()}, new String[]{"ruleGroupId"}, true);
        this._finderPathCountByRuleGroupId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRuleGroupId", new String[]{Long.class.getName()}, new String[]{"ruleGroupId"}, false);
        MDRRuleUtil.setPersistence((MDRRulePersistence)this);
    }

    @Deactivate
    public void deactivate() {
        MDRRuleUtil.setPersistence(null);
        this.entityCache.removeCache(MDRRuleImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.mobile.device.rules.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mobile.device.rules.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mobile.device.rules.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class MDRRuleModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private MDRRuleModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            MDRRuleModelImpl mdrRuleModelImpl = (MDRRuleModelImpl)baseModel;
            long columnBitmask = mdrRuleModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return MDRRuleModelArgumentsResolver._getValue(mdrRuleModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | MDRRuleModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return MDRRuleModelArgumentsResolver._getValue(mdrRuleModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(MDRRuleModelImpl mdrRuleModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? mdrRuleModelImpl.getColumnOriginalValue(columnName) : mdrRuleModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= MDRRuleModelImpl.getColumnBitmask("createDate");
        }
    }
}

