/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.base.MDRRuleGroupInstanceServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=mdr", "json.web.service.context.path=MDRRuleGroupInstance"}, service={AopService.class})
public class MDRRuleGroupInstanceServiceImpl
extends MDRRuleGroupInstanceServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.mobile.device.rules.model.MDRRuleGroupInstance)")
    private ModelResourcePermission<MDRRuleGroupInstance> _mdrRuleGroupInstanceModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.mobile.device.rules)")
    private PortletResourcePermission _portletResourcePermission;

    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, int priority, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_RULE_GROUP_INSTANCE");
        return this.mdrRuleGroupInstanceLocalService.addRuleGroupInstance(groupId, className, classPK, ruleGroupId, priority, serviceContext);
    }

    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), groupId, "ADD_RULE_GROUP_INSTANCE");
        return this.mdrRuleGroupInstanceLocalService.addRuleGroupInstance(groupId, className, classPK, ruleGroupId, serviceContext);
    }

    public void deleteRuleGroupInstance(long ruleGroupInstanceId) throws PortalException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)ruleGroupInstance, "DELETE");
        this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(String className, long classPK, int start, int end, OrderByComparator<MDRRuleGroupInstance> orderByComparator) {
        return this.mdrRuleGroupInstancePersistence.filterFindByG_C_C(this.getGroupId(className, classPK), this.classNameLocalService.getClassNameId(className), classPK, start, end, orderByComparator);
    }

    public int getRuleGroupInstancesCount(String className, long classPK) {
        return this.mdrRuleGroupInstancePersistence.filterCountByG_C_C(this.getGroupId(className, classPK), this.classNameLocalService.getClassNameId(className), classPK);
    }

    public MDRRuleGroupInstance updateRuleGroupInstance(long ruleGroupInstanceId, int priority) throws PortalException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        this._mdrRuleGroupInstanceModelResourcePermission.check(this.getPermissionChecker(), ruleGroupInstance.getRuleGroupInstanceId(), "UPDATE");
        return this.mdrRuleGroupInstanceLocalService.updateRuleGroupInstance(ruleGroupInstanceId, priority);
    }

    protected long getGroupId(String className, long classPK) {
        LayoutSet layoutSet;
        long groupId = 0L;
        if (className.equals(Layout.class.getName())) {
            Layout layout = this.layoutLocalService.fetchLayout(classPK);
            if (layout != null) {
                groupId = layout.getGroupId();
            }
        } else if (className.equals(LayoutSet.class.getName()) && (layoutSet = this.layoutSetLocalService.fetchLayoutSet(classPK)) != null) {
            groupId = layoutSet.getGroupId();
        }
        return groupId;
    }
}

