/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.mobile.device.rules.service.MDRActionLocalService;
import com.liferay.mobile.device.rules.service.MDRActionLocalServiceUtil;
import com.liferay.mobile.device.rules.service.persistence.MDRActionPersistence;
import com.liferay.mobile.device.rules.service.persistence.MDRRuleGroupInstancePersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class MDRActionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
MDRActionLocalService {
    protected MDRActionLocalService mdrActionLocalService;
    @Reference
    protected MDRActionPersistence mdrActionPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected MDRRuleGroupInstancePersistence mdrRuleGroupInstancePersistence;
    private static final Log _log = LogFactoryUtil.getLog(MDRActionLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public MDRAction addMDRAction(MDRAction mdrAction) {
        mdrAction.setNew(true);
        return (MDRAction)this.mdrActionPersistence.update((BaseModel)mdrAction);
    }

    @Transactional(enabled=false)
    public MDRAction createMDRAction(long actionId) {
        return this.mdrActionPersistence.create(actionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MDRAction deleteMDRAction(long actionId) throws PortalException {
        return this.mdrActionPersistence.remove(actionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MDRAction deleteMDRAction(MDRAction mdrAction) {
        return (MDRAction)this.mdrActionPersistence.remove((BaseModel)mdrAction);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.mdrActionPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(MDRAction.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.mdrActionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.mdrActionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.mdrActionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.mdrActionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.mdrActionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public MDRAction fetchMDRAction(long actionId) {
        return this.mdrActionPersistence.fetchByPrimaryKey(actionId);
    }

    public MDRAction fetchMDRActionByUuidAndGroupId(String uuid, long groupId) {
        return this.mdrActionPersistence.fetchByUUID_G(uuid, groupId);
    }

    public MDRAction getMDRAction(long actionId) throws PortalException {
        return this.mdrActionPersistence.findByPrimaryKey(actionId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrActionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MDRAction.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("actionId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrActionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(MDRAction.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("actionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mdrActionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MDRAction.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("actionId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MDRAction>(){

            public void performAction(MDRAction mdrAction) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)mdrAction);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)MDRAction.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.mdrActionPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.mdrActionLocalService.deleteMDRAction((MDRAction)persistedModel);
    }

    public BasePersistence<MDRAction> getBasePersistence() {
        return this.mdrActionPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.mdrActionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<MDRAction> getMDRActionsByUuidAndCompanyId(String uuid, long companyId) {
        return this.mdrActionPersistence.findByUuid_C(uuid, companyId);
    }

    public List<MDRAction> getMDRActionsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<MDRAction> orderByComparator) {
        return this.mdrActionPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public MDRAction getMDRActionByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.mdrActionPersistence.findByUUID_G(uuid, groupId);
    }

    public List<MDRAction> getMDRActions(int start, int end) {
        return this.mdrActionPersistence.findAll(start, end);
    }

    public int getMDRActionsCount() {
        return this.mdrActionPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public MDRAction updateMDRAction(MDRAction mdrAction) {
        return (MDRAction)this.mdrActionPersistence.update((BaseModel)mdrAction);
    }

    @Deactivate
    protected void deactivate() {
        MDRActionLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{MDRActionLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.mdrActionLocalService = (MDRActionLocalService)aopProxy;
        MDRActionLocalServiceUtil.setService((MDRActionLocalService)this.mdrActionLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return MDRActionLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return MDRAction.class;
    }

    protected String getModelClassName() {
        return MDRAction.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.mdrActionPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

