/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.mobile.device.rules.model.impl;

import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.service.MDRRuleLocalServiceUtil;

/**
 * The extended model base implementation for the MDRRule service. Represents a row in the &quot;MDRRule&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MDRRuleImpl}.
 * </p>
 *
 * @author Edward C. Han
 * @see MDRRuleImpl
 * @see MDRRule
 * @generated
 */
public abstract class MDRRuleBaseImpl
	extends MDRRuleModelImpl implements MDRRule {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a mdr rule model instance should use the <code>MDRRule</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MDRRuleLocalServiceUtil.addMDRRule(this);
		}
		else {
			MDRRuleLocalServiceUtil.updateMDRRule(this);
		}
	}

}