/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.model.MDRRule;
import com.liferay.mobile.device.rules.model.MDRRuleGroup;
import com.liferay.mobile.device.rules.service.MDRRuleGroupInstanceLocalService;
import com.liferay.mobile.device.rules.service.MDRRuleLocalService;
import com.liferay.mobile.device.rules.service.base.MDRRuleGroupLocalServiceBaseImpl;
import com.liferay.mobile.device.rules.util.comparator.RuleGroupCreateDateComparator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PropsValues;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.mobile.device.rules.model.MDRRuleGroup"}, service={AopService.class})
public class MDRRuleGroupLocalServiceImpl
extends MDRRuleGroupLocalServiceBaseImpl {
    @Reference
    private MDRRuleGroupInstanceLocalService _mdrRuleGroupInstanceLocalService;
    @Reference
    private MDRRuleLocalService _mdrRuleLocalService;

    public MDRRuleGroup addRuleGroup(long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long ruleGroupId = this.counterLocalService.increment();
        MDRRuleGroup ruleGroup = this.createMDRRuleGroup(ruleGroupId);
        ruleGroup.setUuid(serviceContext.getUuid());
        ruleGroup.setGroupId(groupId);
        ruleGroup.setCompanyId(serviceContext.getCompanyId());
        ruleGroup.setUserId(user.getUserId());
        ruleGroup.setUserName(user.getFullName());
        ruleGroup.setNameMap(nameMap);
        ruleGroup.setDescriptionMap(descriptionMap);
        this.resourceLocalService.addModelResources((AuditedModel)ruleGroup, serviceContext);
        return this.updateMDRRuleGroup(ruleGroup);
    }

    public MDRRuleGroup copyRuleGroup(long ruleGroupId, long groupId, ServiceContext serviceContext) throws PortalException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        return this.copyRuleGroup(ruleGroup, groupId, serviceContext);
    }

    public MDRRuleGroup copyRuleGroup(MDRRuleGroup ruleGroup, long groupId, ServiceContext serviceContext) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        Map nameMap = ruleGroup.getNameMap();
        for (Map.Entry entry : nameMap.entrySet()) {
            String name = (String)entry.getValue();
            if (Validator.isNull((String)name)) continue;
            Locale locale = (Locale)entry.getKey();
            String postfix = LanguageUtil.get((Locale)locale, (String)PropsValues.MOBILE_DEVICE_RULES_RULE_GROUP_COPY_POSTFIX);
            nameMap.put(locale, name.concat(" ").concat(postfix));
        }
        MDRRuleGroup newRuleGroup = this.addRuleGroup(group.getGroupId(), nameMap, ruleGroup.getDescriptionMap(), serviceContext);
        List rules = this.mdrRulePersistence.findByRuleGroupId(ruleGroup.getRuleGroupId());
        for (MDRRule rule : rules) {
            serviceContext.setUuid(PortalUUIDUtil.generate());
            this._mdrRuleLocalService.copyRule(rule, newRuleGroup.getRuleGroupId(), serviceContext);
        }
        return newRuleGroup;
    }

    public void deleteRuleGroup(long ruleGroupId) {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.fetchByPrimaryKey(ruleGroupId);
        if (ruleGroup != null) {
            this.mdrRuleGroupLocalService.deleteRuleGroup(ruleGroup);
        }
    }

    @SystemEvent(action=1, type=1)
    public void deleteRuleGroup(MDRRuleGroup ruleGroup) {
        this.mdrRuleGroupPersistence.remove((BaseModel)ruleGroup);
        this._mdrRuleLocalService.deleteRules(ruleGroup.getRuleGroupId());
        this._mdrRuleGroupInstanceLocalService.deleteRuleGroupInstances(ruleGroup.getRuleGroupId());
    }

    public void deleteRuleGroups(long groupId) {
        List ruleGroups = this.mdrRuleGroupPersistence.findByGroupId(groupId);
        for (MDRRuleGroup ruleGroup : ruleGroups) {
            this.mdrRuleGroupLocalService.deleteRuleGroup(ruleGroup);
        }
    }

    public MDRRuleGroup fetchRuleGroup(long ruleGroupId) {
        return this.mdrRuleGroupPersistence.fetchByPrimaryKey(ruleGroupId);
    }

    public MDRRuleGroup getRuleGroup(long ruleGroupId) throws PortalException {
        return this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
    }

    public List<MDRRuleGroup> getRuleGroups(long groupId) {
        return this.mdrRuleGroupPersistence.findByGroupId(groupId);
    }

    public List<MDRRuleGroup> getRuleGroups(long groupId, int start, int end) {
        return this.mdrRuleGroupPersistence.findByGroupId(groupId, start, end);
    }

    public List<MDRRuleGroup> getRuleGroups(long[] groupIds, int start, int end) {
        return this.mdrRuleGroupPersistence.findByGroupId(groupIds, start, end);
    }

    public int getRuleGroupsCount(long groupId) {
        return this.mdrRuleGroupPersistence.countByGroupId(groupId);
    }

    public int getRuleGroupsCount(long[] groupIds) {
        return this.mdrRuleGroupPersistence.countByGroupId(groupIds);
    }

    public List<MDRRuleGroup> search(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.mdrRuleGroupFinder.findByG_N(groupId, name, params, andOperator, start, end);
    }

    public List<MDRRuleGroup> searchByKeywords(long groupId, String keywords, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) {
        return this.searchByKeywords(groupId, keywords, params, andOperator, start, end, (OrderByComparator<MDRRuleGroup>)new RuleGroupCreateDateComparator());
    }

    public List<MDRRuleGroup> searchByKeywords(long groupId, String keywords, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<MDRRuleGroup> obc) {
        return this.mdrRuleGroupFinder.findByKeywords(groupId, keywords, params, start, end, obc);
    }

    public int searchByKeywordsCount(long groupId, String keywords, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.mdrRuleGroupFinder.countByKeywords(groupId, keywords, params);
    }

    public int searchCount(long groupId, String name, LinkedHashMap<String, Object> params, boolean andOperator) {
        return this.mdrRuleGroupFinder.countByG_N(groupId, name, params, andOperator);
    }

    public MDRRuleGroup updateRuleGroup(long ruleGroupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        MDRRuleGroup ruleGroup = this.mdrRuleGroupPersistence.findByPrimaryKey(ruleGroupId);
        ruleGroup.setNameMap(nameMap);
        ruleGroup.setDescriptionMap(descriptionMap);
        return (MDRRuleGroup)this.mdrRuleGroupPersistence.update((BaseModel)ruleGroup);
    }
}

