/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.device.rules.service.impl;

import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.mobile.device.rules.model.MDRRuleGroupInstance;
import com.liferay.mobile.device.rules.service.base.MDRActionLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MDRActionLocalServiceImpl
extends MDRActionLocalServiceBaseImpl {
    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        long actionId = this.counterLocalService.increment();
        MDRAction action = this.mdrActionLocalService.createMDRAction(actionId);
        action.setUuid(serviceContext.getUuid());
        action.setGroupId(ruleGroupInstance.getGroupId());
        action.setCompanyId(serviceContext.getCompanyId());
        action.setUserId(serviceContext.getUserId());
        action.setUserName(user.getFullName());
        action.setClassNameId(ruleGroupInstance.getClassNameId());
        action.setClassPK(ruleGroupInstance.getClassPK());
        action.setRuleGroupInstanceId(ruleGroupInstanceId);
        action.setNameMap(nameMap);
        action.setDescriptionMap(descriptionMap);
        action.setType(type);
        action.setTypeSettings(typeSettings);
        action = this.updateMDRAction(action);
        ruleGroupInstance.setModifiedDate(new Date());
        this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
        return action;
    }

    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        return this.addAction(ruleGroupInstanceId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }

    public void deleteAction(long actionId) {
        MDRAction action = this.mdrActionPersistence.fetchByPrimaryKey(actionId);
        if (action != null) {
            this.mdrActionLocalService.deleteAction(action);
        }
    }

    @SystemEvent(type=1)
    public void deleteAction(MDRAction action) {
        this.mdrActionPersistence.remove((BaseModel)action);
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.fetchByPrimaryKey(action.getRuleGroupInstanceId());
        if (ruleGroupInstance != null) {
            ruleGroupInstance.setModifiedDate(new Date());
            this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
        }
    }

    public void deleteActions(long ruleGroupInstanceId) {
        List actions = this.mdrActionPersistence.findByRuleGroupInstanceId(ruleGroupInstanceId);
        for (MDRAction action : actions) {
            this.mdrActionLocalService.deleteAction(action);
        }
    }

    public MDRAction fetchAction(long actionId) {
        return this.mdrActionPersistence.fetchByPrimaryKey(actionId);
    }

    public MDRAction getAction(long actionId) throws PortalException {
        return this.mdrActionPersistence.findByPrimaryKey(actionId);
    }

    public List<MDRAction> getActions(long ruleGroupInstanceId) {
        return this.mdrActionPersistence.findByRuleGroupInstanceId(ruleGroupInstanceId);
    }

    public List<MDRAction> getActions(long ruleGroupInstanceId, int start, int end) {
        return this.mdrActionPersistence.findByRuleGroupInstanceId(ruleGroupInstanceId, start, end);
    }

    public List<MDRAction> getActions(long ruleGroupInstanceId, int start, int end, OrderByComparator<MDRAction> obc) {
        return this.mdrActionPersistence.findByRuleGroupInstanceId(ruleGroupInstanceId, start, end, obc);
    }

    public int getActionsCount(long ruleGroupInstanceId) {
        return this.mdrActionPersistence.countByRuleGroupInstanceId(ruleGroupInstanceId);
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        action.setNameMap(nameMap);
        action.setDescriptionMap(descriptionMap);
        action.setType(type);
        action.setTypeSettings(typeSettings);
        action = (MDRAction)this.mdrActionPersistence.update((BaseModel)action);
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(action.getRuleGroupInstanceId());
        ruleGroupInstance.setModifiedDate(serviceContext.getModifiedDate(null));
        this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
        return action;
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        return this.updateAction(actionId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }
}

