/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.microblogs.internal.upgrade.v1_0_1;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UserNotificationEventUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._upgradeNotifications();
    }

    private void _updateNotification(long userNotificationEventId, JSONObject jsonObject) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update UserNotificationEvent set payload = ? where userNotificationEventId = ?");){
            preparedStatement.setString(1, jsonObject.toString());
            preparedStatement.setLong(2, userNotificationEventId);
            preparedStatement.executeUpdate();
        }
    }

    private void _upgradeNotifications() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select userNotificationEventId, payload from UserNotificationEvent where type_ = ?");){
            preparedStatement.setString(1, "com_liferay_microblogs_web_portlet_MicroblogsPortlet");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String payload = resultSet.getString("payload");
                    JSONObject payloadJSONObject = JSONFactoryUtil.createJSONObject((String)payload);
                    int notificationType = payloadJSONObject.getInt("notificationType");
                    if (notificationType != 0) {
                        return;
                    }
                    long userNotificationEventId = resultSet.getLong("userNotificationEventId");
                    payloadJSONObject.put("notificationType", 0);
                    this._updateNotification(userNotificationEventId, payloadJSONObject);
                }
            }
        }
    }
}

