/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.trash;

import com.liferay.asset.util.AssetHelper;
import com.liferay.message.boards.internal.trash.MBThreadTrashRenderer;
import com.liferay.message.boards.internal.util.MBTrashUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.BaseTrashHandler;
import com.liferay.trash.TrashHelper;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import jakarta.servlet.ServletContext;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBThread"}, service={TrashHandler.class})
public class MBThreadTrashHandler
extends BaseTrashHandler {
    @Reference
    private AssetHelper _assetHelper;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _categoryModelResourcePermission;
    @Reference
    private MBCategoryLocalService _mbCategoryLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.message.boards.web)")
    private ServletContext _servletContext;
    @Reference
    private TrashHelper _trashHelper;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._mbThreadLocalService.deleteThread(classPK);
    }

    public String getClassName() {
        return MBThread.class.getName();
    }

    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        return this._mbCategoryLocalService.getCategory(containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return MBCategory.class.getName();
    }

    public String getContainerModelName() {
        return "category";
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException {
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        return TransformUtil.transform((Collection)this._mbCategoryLocalService.getCategories(thread.getGroupId(), parentContainerModelId, 0, start, end), category -> category);
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException {
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        return this._mbCategoryLocalService.getCategoriesCount(thread.getGroupId(), parentContainerModelId, 0);
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        return PortletURLBuilder.create((PortletURL)this.getRestoreURL(portletRequest, classPK, false)).setParameter("mbCategoryId", (Object)thread.getCategoryId()).setParameter("messageId", (Object)thread.getRootMessageId()).buildString();
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        return PortletURLBuilder.create((PortletURL)this.getRestoreURL(portletRequest, classPK, true)).setParameter("mbCategoryId", (Object)thread.getCategoryId()).buildString();
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        return MBTrashUtil.getAbsolutePath(portletRequest, thread.getCategoryId());
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._mbThreadLocalService.fetchMBThread(classPK);
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        MBThreadTrashRenderer mbThreadTrashRenderer = new MBThreadTrashRenderer(this._mbThreadLocalService.getThread(classPK), this._assetHelper);
        mbThreadTrashRenderer.setServletContext(this._servletContext);
        return mbThreadTrashRenderer;
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionUtil.contains(this._categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_MESSAGE");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isMovable(long classPK) throws PortalException {
        MBCategory parentCategory;
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        return thread.getCategoryId() > 0L && ((parentCategory = this._mbCategoryLocalService.fetchMBCategory(thread.getCategoryId())) == null || parentCategory.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        if (thread.getCategoryId() > 0L && this._mbCategoryLocalService.fetchMBCategory(thread.getCategoryId()) == null || !this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), thread.getGroupId(), classPK, "RESTORE")) {
            return false;
        }
        return !this._trashHelper.isInTrashContainer((TrashedModel)thread);
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._mbThreadLocalService.moveThread(userId, containerModelId, classPK);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._mbThreadLocalService.moveThreadFromTrash(userId, containerModelId, classPK);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this._mbThreadLocalService.restoreThreadFromTrash(userId, classPK);
    }

    protected PortletURL getRestoreURL(PortletRequest portletRequest, long classPK, boolean containerModel) throws PortalException {
        LiferayPortletURL portletURL = null;
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        String portletId = PortletProviderUtil.getPortletId((String)MBThread.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        long plid = this._portal.getPlidFromPortletId(thread.getGroupId(), portletId);
        if (plid == 0L) {
            portletId = PortletProviderUtil.getPortletId((String)MBThread.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
            portletURL = this._portal.getControlPanelPortletURL(portletRequest, portletId, "RENDER_PHASE");
        } else {
            portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletId, (long)plid, (String)"RENDER_PHASE");
        }
        if (containerModel) {
            String mvcRenderCommandName = "/message_boards/view";
            if (thread.getCategoryId() != 0L) {
                mvcRenderCommandName = "/message_boards/view_category";
            }
            portletURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        }
        return portletURL;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        MBThread thread = this._mbThreadLocalService.getThread(classPK);
        return this._messageModelResourcePermission.contains(permissionChecker, thread.getRootMessageId(), actionId);
    }
}

