/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v3_1_0;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;

public class UrlSubjectUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (SafeCloseable safeCloseable = this.addTemporaryIndex("MBMessage", false, new String[]{"subject"});){
            this._populateUrlSubject();
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"MBMessage", (String[])new String[]{"urlSubject VARCHAR(255) null"})};
    }

    private String _getURLSubject(long id, String subject) {
        if (subject == null) {
            return String.valueOf(id);
        }
        subject = Validator.isNull((String)(subject = StringUtil.toLowerCase((String)subject.trim()))) || Validator.isNumber((String)subject) || subject.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)subject);
        return subject.substring(0, Math.min(subject.length(), 254));
    }

    private void _populateUrlSubject() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select messageId, subject from MBMessage order by subject, messageId asc");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update MBMessage set urlSubject = ? where messageId = ?");){
            HashMap<Object, IntegerWrapper> counts = new HashMap<Object, IntegerWrapper>();
            while (resultSet.next()) {
                long messageId = resultSet.getLong(1);
                String subject = resultSet.getString(2);
                Object suffix = "";
                String urlSubject = this._getURLSubject(messageId, subject);
                IntegerWrapper count = counts.computeIfAbsent(urlSubject, key -> new IntegerWrapper(0));
                if (count.getValue() > 0) {
                    suffix = "-" + count.getValue();
                    counts.put(urlSubject + (String)suffix, new IntegerWrapper(1));
                }
                count.increment();
                preparedStatement2.setString(1, urlSubject + (String)suffix);
                preparedStatement2.setLong(2, messageId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

