/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.view.count.model.listener;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.index.UpdateDocumentIndexWriter;
import com.liferay.portal.search.indexer.BaseModelDocumentFactory;
import com.liferay.view.count.model.ViewCountEntry;
import com.liferay.view.count.model.listener.ViewCountEntryModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ViewCountEntryModelListener.class})
public class MBThreadViewCountEntryModelListener
implements ViewCountEntryModelListener {
    @Reference
    private BaseModelDocumentFactory _baseModelDocumentFactory;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private UpdateDocumentIndexWriter _updateDocumentIndexWriter;

    public String getModelClassName() {
        return MBThread.class.getName();
    }

    public void onAfterIncrement(ViewCountEntry viewCountEntry) {
        MBThread mbThread = this._mbThreadLocalService.fetchMBThread(viewCountEntry.getClassPK());
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(mbThread.getRootMessageId());
        Document document = this._baseModelDocumentFactory.createDocument((BaseModel)mbMessage);
        document.addNumber("viewCount", viewCountEntry.getViewCount());
        this._updateDocumentIndexWriter.updateDocumentPartially(mbMessage.getCompanyId(), document, false);
    }
}

