/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.service.base.MBDiscussionLocalServiceBaseImpl;
import com.liferay.message.boards.util.MBUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBDiscussion"}, service={AopService.class})
public class MBDiscussionLocalServiceImpl
extends MBDiscussionLocalServiceBaseImpl {
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public MBDiscussion addDiscussion(long userId, long groupId, long classNameId, long classPK, long threadId, ServiceContext serviceContext) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        User user = this.userLocalService.fetchUser(this._portal.getValidUserId(group.getCompanyId(), userId));
        long discussionId = this.counterLocalService.increment();
        MBDiscussion discussion = this.mbDiscussionPersistence.create(discussionId);
        discussion.setUuid(serviceContext.getUuid());
        discussion.setGroupId(groupId);
        discussion.setCompanyId(serviceContext.getCompanyId());
        discussion.setUserId(userId);
        discussion.setUserName(user.getFullName());
        discussion.setClassNameId(classNameId);
        discussion.setClassPK(classPK);
        discussion.setThreadId(threadId);
        return (MBDiscussion)this.mbDiscussionPersistence.update((BaseModel)discussion);
    }

    public MBDiscussion fetchDiscussion(long discussionId) {
        return this.mbDiscussionPersistence.fetchByPrimaryKey(discussionId);
    }

    public MBDiscussion fetchDiscussion(long classNameId, long classPK) {
        return this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
    }

    public MBDiscussion fetchDiscussion(String className, long classPK) {
        return this.mbDiscussionPersistence.fetchByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public MBDiscussion fetchThreadDiscussion(long threadId) {
        return this.mbDiscussionPersistence.fetchByThreadId(threadId);
    }

    public MBDiscussion getDiscussion(long discussionId) throws PortalException {
        return this.mbDiscussionPersistence.findByPrimaryKey(discussionId);
    }

    public MBDiscussion getDiscussion(String className, long classPK) throws PortalException {
        return this.mbDiscussionPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK);
    }

    public List<MBDiscussion> getDiscussions(String className) {
        return this.mbDiscussionPersistence.findByClassNameId(this.classNameLocalService.getClassNameId(className));
    }

    public MBDiscussion getThreadDiscussion(long threadId) throws PortalException {
        return this.mbDiscussionPersistence.findByThreadId(threadId);
    }

    public void subscribeDiscussion(long userId, long groupId, String className, long classPK) throws PortalException {
        this._subscriptionLocalService.addSubscription(userId, groupId, MBUtil.getSubscriptionClassName((String)className), classPK);
    }

    public void unsubscribeDiscussion(long userId, String className, long classPK) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, MBUtil.getSubscriptionClassName((String)className), classPK);
    }
}

