/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBCategoryLocalServiceUtil;
import com.liferay.message.boards.service.persistence.MBCategoryFinder;
import com.liferay.message.boards.service.persistence.MBCategoryPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.trash.kernel.service.TrashEntryLocalService;
import com.liferay.trash.kernel.service.TrashVersionLocalService;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class MBCategoryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
MBCategoryLocalService {
    protected MBCategoryLocalService mbCategoryLocalService;
    @Reference
    protected MBCategoryPersistence mbCategoryPersistence;
    @Reference
    protected MBCategoryFinder mbCategoryFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ResourceLocalService resourceLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected ExpandoRowLocalService expandoRowLocalService;
    @Reference
    protected RatingsStatsLocalService ratingsStatsLocalService;
    @Reference
    protected TrashEntryLocalService trashEntryLocalService;
    @Reference
    protected TrashVersionLocalService trashVersionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBCategoryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public MBCategory addMBCategory(MBCategory mbCategory) {
        mbCategory.setNew(true);
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)mbCategory);
    }

    @Transactional(enabled=false)
    public MBCategory createMBCategory(long categoryId) {
        return this.mbCategoryPersistence.create(categoryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBCategory deleteMBCategory(long categoryId) throws PortalException {
        return this.mbCategoryPersistence.remove(categoryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBCategory deleteMBCategory(MBCategory mbCategory) {
        return (MBCategory)this.mbCategoryPersistence.remove((BaseModel)mbCategory);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(MBCategory.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.mbCategoryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.mbCategoryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.mbCategoryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.mbCategoryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.mbCategoryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public MBCategory fetchMBCategory(long categoryId) {
        return this.mbCategoryPersistence.fetchByPrimaryKey(categoryId);
    }

    public MBCategory fetchMBCategoryByUuidAndGroupId(String uuid, long groupId) {
        return this.mbCategoryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public MBCategory getMBCategory(long categoryId) throws PortalException {
        return this.mbCategoryPersistence.findByPrimaryKey(categoryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mbCategoryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MBCategory.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("categoryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mbCategoryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(MBCategory.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("categoryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mbCategoryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MBCategory.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("categoryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add((Criterion)disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)MBCategory.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBCategory>(){

            public void performAction(MBCategory mbCategory) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)mbCategory);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)MBCategory.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.mbCategoryLocalService.deleteMBCategory((MBCategory)persistedModel);
    }

    public BasePersistence<MBCategory> getBasePersistence() {
        return this.mbCategoryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.mbCategoryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<MBCategory> getMBCategoriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.mbCategoryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<MBCategory> getMBCategoriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<MBCategory> orderByComparator) {
        return this.mbCategoryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public MBCategory getMBCategoryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.mbCategoryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<MBCategory> getMBCategories(int start, int end) {
        return this.mbCategoryPersistence.findAll(start, end);
    }

    public int getMBCategoriesCount() {
        return this.mbCategoryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public MBCategory updateMBCategory(MBCategory mbCategory) {
        return (MBCategory)this.mbCategoryPersistence.update((BaseModel)mbCategory);
    }

    @Deactivate
    protected void deactivate() {
        MBCategoryLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{MBCategoryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.mbCategoryLocalService = (MBCategoryLocalService)aopProxy;
        MBCategoryLocalServiceUtil.setService((MBCategoryLocalService)this.mbCategoryLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return MBCategoryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return MBCategory.class;
    }

    protected String getModelClassName() {
        return MBCategory.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.mbCategoryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

