/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search.spi.model.index.contributor;

import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.message.boards.model.MBMessage"}, service={ModelDocumentContributor.class})
public class MBMessageModelDocumentContributor
implements ModelDocumentContributor<MBMessage> {
    @Reference
    protected CommentManager commentManager;
    @Reference
    protected MBDiscussionLocalService mbDiscussionLocalService;
    @Reference
    protected MBThreadLocalService mbThreadLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBMessageModelDocumentContributor.class);

    public void contribute(Document document, MBMessage mbMessage) {
        List relatedEntryIndexers;
        document.addKeyword("categoryId", mbMessage.getCategoryId());
        for (Locale locale : LanguageUtil.getAvailableLocales((long)mbMessage.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(LocalizationUtil.getLocalizedName((String)"content", (String)languageId), this.processContent(mbMessage));
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), mbMessage.getSubject());
        }
        document.addKeyword("rootEntryClassPK", mbMessage.getRootMessageId());
        if (mbMessage.isAnonymous()) {
            document.remove("userName");
        }
        document.addKeywordSortable("answer", Boolean.valueOf(mbMessage.isAnswer()));
        MBDiscussion discussion = this.mbDiscussionLocalService.fetchThreadDiscussion(mbMessage.getThreadId());
        if (discussion == null) {
            document.addKeyword("discussion", false);
        } else {
            document.addKeyword("discussion", true);
        }
        document.addKeyword("parentMessageId", mbMessage.getParentMessageId());
        if (mbMessage.getMessageId() == mbMessage.getRootMessageId()) {
            MBThread mbThread = this.mbThreadLocalService.fetchMBThread(mbMessage.getThreadId());
            document.addKeyword("question", mbThread.isQuestion());
        }
        document.addKeyword("threadId", mbMessage.getThreadId());
        if (mbMessage.isDiscussion() && (relatedEntryIndexers = RelatedEntryIndexerRegistryUtil.getRelatedEntryIndexers((String)mbMessage.getClassName())) != null) {
            for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                Comment comment = this.commentManager.fetchComment(mbMessage.getMessageId());
                if (comment == null) continue;
                try {
                    relatedEntryIndexer.addRelatedEntryFields(document, (Object)comment);
                }
                catch (Exception exception) {
                    throw new SystemException((Throwable)exception);
                }
                document.addKeyword("relatedEntry", true);
            }
        }
    }

    protected String processContent(MBMessage message) {
        String content = message.getBody();
        try {
            if (message.isFormatBBCode()) {
                content = BBCodeTranslatorUtil.getHTML((String)content);
            }
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse message ", message.getMessageId(), ": ", exception.getMessage()}), (Throwable)exception);
        }
        return HtmlUtil.extractText((String)content);
    }
}

