/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"related.entry.indexer.class.name=com.liferay.message.boards.model.MBMessage"}, service={RelatedEntryIndexer.class})
public class MBMessageRelatedEntryIndexer
extends BaseRelatedEntryIndexer {
    @Reference
    protected MBMessageLocalService mbMessageLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBMessageRelatedEntryIndexer.class);

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        FileEntry fileEntry = (FileEntry)obj;
        MBMessage mbMessage = this.mbMessageLocalService.fetchFileEntryMessage(fileEntry.getFileEntryId());
        if (mbMessage == null) {
            return;
        }
        document.addKeyword("categoryId", mbMessage.getCategoryId());
        document.addKeyword("discussion", false);
        document.addKeyword("threadId", mbMessage.getThreadId());
    }

    public boolean isVisibleRelatedEntry(long classPK, int status) throws Exception {
        try {
            MBMessage mbMessage = this.mbMessageLocalService.getMessage(classPK);
            if (mbMessage.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.getIndexer((String)mbMessage.getClassName());
                return indexer.isVisible(mbMessage.getClassPK(), status);
            }
        }
        catch (Exception exception) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Unable to get message boards message", (Throwable)exception);
            }
            return false;
        }
        return true;
    }

    public void updateFullQuery(SearchContext searchContext) {
        if (searchContext.isIncludeDiscussions()) {
            searchContext.addFullQueryEntryClassName(MBMessage.class.getName());
            searchContext.setAttribute("discussion", (Serializable)Boolean.TRUE);
        }
    }
}

