/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.service.base;

import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.service.MBBanService;
import com.liferay.message.boards.service.MBBanServiceUtil;
import com.liferay.message.boards.service.persistence.MBBanPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.spring.extender.service.ServiceReference;

import java.sql.Connection;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the message boards ban remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.message.boards.service.impl.MBBanServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.message.boards.service.impl.MBBanServiceImpl
 * @generated
 */
public abstract class MBBanServiceBaseImpl
	extends BaseServiceImpl implements IdentifiableOSGiService, MBBanService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>MBBanService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>MBBanServiceUtil</code>.
	 */

	/**
	 * Returns the message boards ban local service.
	 *
	 * @return the message boards ban local service
	 */
	public com.liferay.message.boards.service.MBBanLocalService
		getMBBanLocalService() {

		return mbBanLocalService;
	}

	/**
	 * Sets the message boards ban local service.
	 *
	 * @param mbBanLocalService the message boards ban local service
	 */
	public void setMBBanLocalService(
		com.liferay.message.boards.service.MBBanLocalService
			mbBanLocalService) {

		this.mbBanLocalService = mbBanLocalService;
	}

	/**
	 * Returns the message boards ban remote service.
	 *
	 * @return the message boards ban remote service
	 */
	public MBBanService getMBBanService() {
		return mbBanService;
	}

	/**
	 * Sets the message boards ban remote service.
	 *
	 * @param mbBanService the message boards ban remote service
	 */
	public void setMBBanService(MBBanService mbBanService) {
		this.mbBanService = mbBanService;
	}

	/**
	 * Returns the message boards ban persistence.
	 *
	 * @return the message boards ban persistence
	 */
	public MBBanPersistence getMBBanPersistence() {
		return mbBanPersistence;
	}

	/**
	 * Sets the message boards ban persistence.
	 *
	 * @param mbBanPersistence the message boards ban persistence
	 */
	public void setMBBanPersistence(MBBanPersistence mbBanPersistence) {
		this.mbBanPersistence = mbBanPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	public void afterPropertiesSet() {
		MBBanServiceUtil.setService(mbBanService);
	}

	public void destroy() {
		MBBanServiceUtil.setService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return MBBanService.class.getName();
	}

	protected Class<?> getModelClass() {
		return MBBan.class;
	}

	protected String getModelClassName() {
		return MBBan.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource = mbBanPersistence.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@BeanReference(
		type = com.liferay.message.boards.service.MBBanLocalService.class
	)
	protected com.liferay.message.boards.service.MBBanLocalService
		mbBanLocalService;

	@BeanReference(type = MBBanService.class)
	protected MBBanService mbBanService;

	@BeanReference(type = MBBanPersistence.class)
	protected MBBanPersistence mbBanPersistence;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	private static final Log _log = LogFactoryUtil.getLog(
		MBBanServiceBaseImpl.class);

}