/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageModel;
import com.liferay.message.boards.model.MBMessageSoap;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the MBMessage service. Represents a row in the &quot;MBMessage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>MBMessageModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBMessageImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBMessageImpl
 * @generated
 */
@JSON(strict = true)
public class MBMessageModelImpl
	extends BaseModelImpl<MBMessage> implements MBMessageModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message-boards message model instance should use the <code>MBMessage</code> interface instead.
	 */
	public static final String TABLE_NAME = "MBMessage";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"messageId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"categoryId", Types.BIGINT}, {"threadId", Types.BIGINT},
		{"rootMessageId", Types.BIGINT}, {"parentMessageId", Types.BIGINT},
		{"subject", Types.VARCHAR}, {"body", Types.CLOB},
		{"format", Types.VARCHAR}, {"anonymous", Types.BOOLEAN},
		{"priority", Types.DOUBLE}, {"allowPingbacks", Types.BOOLEAN},
		{"answer", Types.BOOLEAN}, {"lastPublishDate", Types.TIMESTAMP},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("messageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("categoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("threadId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("rootMessageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentMessageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
		TABLE_COLUMNS_MAP.put("format", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("anonymous", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("allowPingbacks", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("answer", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table MBMessage (uuid_ VARCHAR(75) null,messageId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,categoryId LONG,threadId LONG,rootMessageId LONG,parentMessageId LONG,subject VARCHAR(75) null,body TEXT null,format VARCHAR(75) null,anonymous BOOLEAN,priority DOUBLE,allowPingbacks BOOLEAN,answer BOOLEAN,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table MBMessage";

	public static final String ORDER_BY_JPQL =
		" ORDER BY mbMessage.createDate ASC, mbMessage.messageId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY MBMessage.createDate ASC, MBMessage.messageId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.message.boards.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.message.boards.model.MBMessage"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.message.boards.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.message.boards.model.MBMessage"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.message.boards.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.message.boards.model.MBMessage"),
		true);

	public static final long ANSWER_COLUMN_BITMASK = 1L;

	public static final long CATEGORYID_COLUMN_BITMASK = 2L;

	public static final long CLASSNAMEID_COLUMN_BITMASK = 4L;

	public static final long CLASSPK_COLUMN_BITMASK = 8L;

	public static final long COMPANYID_COLUMN_BITMASK = 16L;

	public static final long GROUPID_COLUMN_BITMASK = 32L;

	public static final long PARENTMESSAGEID_COLUMN_BITMASK = 64L;

	public static final long STATUS_COLUMN_BITMASK = 128L;

	public static final long THREADID_COLUMN_BITMASK = 256L;

	public static final long USERID_COLUMN_BITMASK = 512L;

	public static final long UUID_COLUMN_BITMASK = 1024L;

	public static final long CREATEDATE_COLUMN_BITMASK = 2048L;

	public static final long MESSAGEID_COLUMN_BITMASK = 4096L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static MBMessage toModel(MBMessageSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		MBMessage model = new MBMessageImpl();

		model.setUuid(soapModel.getUuid());
		model.setMessageId(soapModel.getMessageId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setCategoryId(soapModel.getCategoryId());
		model.setThreadId(soapModel.getThreadId());
		model.setRootMessageId(soapModel.getRootMessageId());
		model.setParentMessageId(soapModel.getParentMessageId());
		model.setSubject(soapModel.getSubject());
		model.setBody(soapModel.getBody());
		model.setFormat(soapModel.getFormat());
		model.setAnonymous(soapModel.isAnonymous());
		model.setPriority(soapModel.getPriority());
		model.setAllowPingbacks(soapModel.isAllowPingbacks());
		model.setAnswer(soapModel.isAnswer());
		model.setLastPublishDate(soapModel.getLastPublishDate());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<MBMessage> toModels(MBMessageSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<MBMessage> models = new ArrayList<MBMessage>(soapModels.length);

		for (MBMessageSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.message.boards.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.message.boards.model.MBMessage"));

	public MBMessageModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _messageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setMessageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _messageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return MBMessage.class;
	}

	@Override
	public String getModelClassName() {
		return MBMessage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<MBMessage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<MBMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBMessage, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((MBMessage)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<MBMessage, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<MBMessage, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(MBMessage)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<MBMessage, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<MBMessage, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, MBMessage>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			MBMessage.class.getClassLoader(), MBMessage.class,
			ModelWrapper.class);

		try {
			Constructor<MBMessage> constructor =
				(Constructor<MBMessage>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<MBMessage, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<MBMessage, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<MBMessage, Object>>();

		attributeGetterFunctions.put(
			"uuid",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getUuid();
				}

			});
		attributeGetterFunctions.put(
			"messageId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getMessageId();
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getGroupId();
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getCompanyId();
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getUserId();
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getUserName();
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getCreateDate();
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getModifiedDate();
				}

			});
		attributeGetterFunctions.put(
			"classNameId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getClassNameId();
				}

			});
		attributeGetterFunctions.put(
			"classPK",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getClassPK();
				}

			});
		attributeGetterFunctions.put(
			"categoryId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getCategoryId();
				}

			});
		attributeGetterFunctions.put(
			"threadId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getThreadId();
				}

			});
		attributeGetterFunctions.put(
			"rootMessageId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getRootMessageId();
				}

			});
		attributeGetterFunctions.put(
			"parentMessageId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getParentMessageId();
				}

			});
		attributeGetterFunctions.put(
			"subject",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getSubject();
				}

			});
		attributeGetterFunctions.put(
			"body",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getBody();
				}

			});
		attributeGetterFunctions.put(
			"format",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getFormat();
				}

			});
		attributeGetterFunctions.put(
			"anonymous",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getAnonymous();
				}

			});
		attributeGetterFunctions.put(
			"priority",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getPriority();
				}

			});
		attributeGetterFunctions.put(
			"allowPingbacks",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getAllowPingbacks();
				}

			});
		attributeGetterFunctions.put(
			"answer",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getAnswer();
				}

			});
		attributeGetterFunctions.put(
			"lastPublishDate",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getLastPublishDate();
				}

			});
		attributeGetterFunctions.put(
			"status",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getStatus();
				}

			});
		attributeGetterFunctions.put(
			"statusByUserId",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getStatusByUserId();
				}

			});
		attributeGetterFunctions.put(
			"statusByUserName",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getStatusByUserName();
				}

			});
		attributeGetterFunctions.put(
			"statusDate",
			new Function<MBMessage, Object>() {

				@Override
				public Object apply(MBMessage mbMessage) {
					return mbMessage.getStatusDate();
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<MBMessage, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<MBMessage, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<MBMessage, ?>>();

		attributeSetterBiConsumers.put(
			"uuid",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object uuidObject) {
					mbMessage.setUuid((String)uuidObject);
				}

			});
		attributeSetterBiConsumers.put(
			"messageId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object messageIdObject) {

					mbMessage.setMessageId((Long)messageIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object groupIdObject) {
					mbMessage.setGroupId((Long)groupIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object companyIdObject) {

					mbMessage.setCompanyId((Long)companyIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object userIdObject) {
					mbMessage.setUserId((Long)userIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object userNameObject) {
					mbMessage.setUserName((String)userNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object createDateObject) {

					mbMessage.setCreateDate((Date)createDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object modifiedDateObject) {

					mbMessage.setModifiedDate((Date)modifiedDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"classNameId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object classNameIdObject) {

					mbMessage.setClassNameId((Long)classNameIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"classPK",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object classPKObject) {
					mbMessage.setClassPK((Long)classPKObject);
				}

			});
		attributeSetterBiConsumers.put(
			"categoryId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object categoryIdObject) {

					mbMessage.setCategoryId((Long)categoryIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"threadId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object threadIdObject) {
					mbMessage.setThreadId((Long)threadIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"rootMessageId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object rootMessageIdObject) {

					mbMessage.setRootMessageId((Long)rootMessageIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"parentMessageId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object parentMessageIdObject) {

					mbMessage.setParentMessageId((Long)parentMessageIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"subject",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object subjectObject) {
					mbMessage.setSubject((String)subjectObject);
				}

			});
		attributeSetterBiConsumers.put(
			"body",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object bodyObject) {
					mbMessage.setBody((String)bodyObject);
				}

			});
		attributeSetterBiConsumers.put(
			"format",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object formatObject) {
					mbMessage.setFormat((String)formatObject);
				}

			});
		attributeSetterBiConsumers.put(
			"anonymous",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object anonymousObject) {

					mbMessage.setAnonymous((Boolean)anonymousObject);
				}

			});
		attributeSetterBiConsumers.put(
			"priority",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object priorityObject) {
					mbMessage.setPriority((Double)priorityObject);
				}

			});
		attributeSetterBiConsumers.put(
			"allowPingbacks",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object allowPingbacksObject) {

					mbMessage.setAllowPingbacks((Boolean)allowPingbacksObject);
				}

			});
		attributeSetterBiConsumers.put(
			"answer",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object answerObject) {
					mbMessage.setAnswer((Boolean)answerObject);
				}

			});
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object lastPublishDateObject) {

					mbMessage.setLastPublishDate((Date)lastPublishDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"status",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(MBMessage mbMessage, Object statusObject) {
					mbMessage.setStatus((Integer)statusObject);
				}

			});
		attributeSetterBiConsumers.put(
			"statusByUserId",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object statusByUserIdObject) {

					mbMessage.setStatusByUserId((Long)statusByUserIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"statusByUserName",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object statusByUserNameObject) {

					mbMessage.setStatusByUserName(
						(String)statusByUserNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"statusDate",
			new BiConsumer<MBMessage, Object>() {

				@Override
				public void accept(
					MBMessage mbMessage, Object statusDateObject) {

					mbMessage.setStatusDate((Date)statusDateObject);
				}

			});

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getMessageId() {
		return _messageId;
	}

	@Override
	public void setMessageId(long messageId) {
		_columnBitmask = -1L;

		_messageId = messageId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		_columnBitmask |= CLASSNAMEID_COLUMN_BITMASK;

		if (!_setOriginalClassNameId) {
			_setOriginalClassNameId = true;

			_originalClassNameId = _classNameId;
		}

		_classNameId = classNameId;
	}

	public long getOriginalClassNameId() {
		return _originalClassNameId;
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		_columnBitmask |= CLASSPK_COLUMN_BITMASK;

		if (!_setOriginalClassPK) {
			_setOriginalClassPK = true;

			_originalClassPK = _classPK;
		}

		_classPK = classPK;
	}

	public long getOriginalClassPK() {
		return _originalClassPK;
	}

	@JSON
	@Override
	public long getCategoryId() {
		return _categoryId;
	}

	@Override
	public void setCategoryId(long categoryId) {
		_columnBitmask |= CATEGORYID_COLUMN_BITMASK;

		if (!_setOriginalCategoryId) {
			_setOriginalCategoryId = true;

			_originalCategoryId = _categoryId;
		}

		_categoryId = categoryId;
	}

	public long getOriginalCategoryId() {
		return _originalCategoryId;
	}

	@JSON
	@Override
	public long getThreadId() {
		return _threadId;
	}

	@Override
	public void setThreadId(long threadId) {
		_columnBitmask |= THREADID_COLUMN_BITMASK;

		if (!_setOriginalThreadId) {
			_setOriginalThreadId = true;

			_originalThreadId = _threadId;
		}

		_threadId = threadId;
	}

	public long getOriginalThreadId() {
		return _originalThreadId;
	}

	@JSON
	@Override
	public long getRootMessageId() {
		return _rootMessageId;
	}

	@Override
	public void setRootMessageId(long rootMessageId) {
		_rootMessageId = rootMessageId;
	}

	@JSON
	@Override
	public long getParentMessageId() {
		return _parentMessageId;
	}

	@Override
	public void setParentMessageId(long parentMessageId) {
		_columnBitmask |= PARENTMESSAGEID_COLUMN_BITMASK;

		if (!_setOriginalParentMessageId) {
			_setOriginalParentMessageId = true;

			_originalParentMessageId = _parentMessageId;
		}

		_parentMessageId = parentMessageId;
	}

	public long getOriginalParentMessageId() {
		return _originalParentMessageId;
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public void setSubject(String subject) {
		_subject = subject;
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public void setBody(String body) {
		_body = body;
	}

	@JSON
	@Override
	public String getFormat() {
		if (_format == null) {
			return "";
		}
		else {
			return _format;
		}
	}

	@Override
	public void setFormat(String format) {
		_format = format;
	}

	@JSON
	@Override
	public boolean getAnonymous() {
		return _anonymous;
	}

	@JSON
	@Override
	public boolean isAnonymous() {
		return _anonymous;
	}

	@Override
	public void setAnonymous(boolean anonymous) {
		_anonymous = anonymous;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		_priority = priority;
	}

	@JSON
	@Override
	public boolean getAllowPingbacks() {
		return _allowPingbacks;
	}

	@JSON
	@Override
	public boolean isAllowPingbacks() {
		return _allowPingbacks;
	}

	@Override
	public void setAllowPingbacks(boolean allowPingbacks) {
		_allowPingbacks = allowPingbacks;
	}

	@JSON
	@Override
	public boolean getAnswer() {
		return _answer;
	}

	@JSON
	@Override
	public boolean isAnswer() {
		return _answer;
	}

	@Override
	public void setAnswer(boolean answer) {
		_columnBitmask |= ANSWER_COLUMN_BITMASK;

		if (!_setOriginalAnswer) {
			_setOriginalAnswer = true;

			_originalAnswer = _answer;
		}

		_answer = answer;
	}

	public boolean getOriginalAnswer() {
		return _originalAnswer;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(MBMessage.class.getName()),
			getClassNameId());
	}

	@Override
	public com.liferay.trash.kernel.model.TrashEntry getTrashEntry()
		throws PortalException {

		if (!isInTrash()) {
			return null;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return trashEntry;
		}

		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if (Validator.isNotNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			ContainerModel containerModel = null;

			try {
				containerModel = trashHandler.getParentContainerModel(this);
			}
			catch (NoSuchModelException noSuchModelException) {
				return null;
			}

			while (containerModel != null) {
				if (containerModel instanceof TrashedModel) {
					TrashedModel trashedModel = (TrashedModel)containerModel;

					return trashedModel.getTrashEntry();
				}

				trashHandler =
					com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
						getTrashHandler(
							trashHandler.getContainerModelClassName(
								containerModel.getContainerModelId()));

				if (trashHandler == null) {
					return null;
				}

				containerModel = trashHandler.getContainerModel(
					containerModel.getParentContainerModelId());
			}
		}

		return null;
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	/**
	 * @deprecated As of Judson (7.1.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public com.liferay.portal.kernel.trash.TrashHandler getTrashHandler() {
		return com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
			getTrashHandler(getModelClassName());
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInTrashContainer() {
		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if ((trashHandler == null) ||
			Validator.isNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			return false;
		}

		try {
			ContainerModel containerModel =
				trashHandler.getParentContainerModel(this);

			if (containerModel == null) {
				return false;
			}

			if (containerModel instanceof TrashedModel) {
				return ((TrashedModel)containerModel).isInTrash();
			}
		}
		catch (Exception exception) {
		}

		return false;
	}

	@Override
	public boolean isInTrashExplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isInTrashImplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return false;
		}

		return true;
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), MBMessage.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public MBMessage toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, MBMessage>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		MBMessageImpl mbMessageImpl = new MBMessageImpl();

		mbMessageImpl.setUuid(getUuid());
		mbMessageImpl.setMessageId(getMessageId());
		mbMessageImpl.setGroupId(getGroupId());
		mbMessageImpl.setCompanyId(getCompanyId());
		mbMessageImpl.setUserId(getUserId());
		mbMessageImpl.setUserName(getUserName());
		mbMessageImpl.setCreateDate(getCreateDate());
		mbMessageImpl.setModifiedDate(getModifiedDate());
		mbMessageImpl.setClassNameId(getClassNameId());
		mbMessageImpl.setClassPK(getClassPK());
		mbMessageImpl.setCategoryId(getCategoryId());
		mbMessageImpl.setThreadId(getThreadId());
		mbMessageImpl.setRootMessageId(getRootMessageId());
		mbMessageImpl.setParentMessageId(getParentMessageId());
		mbMessageImpl.setSubject(getSubject());
		mbMessageImpl.setBody(getBody());
		mbMessageImpl.setFormat(getFormat());
		mbMessageImpl.setAnonymous(isAnonymous());
		mbMessageImpl.setPriority(getPriority());
		mbMessageImpl.setAllowPingbacks(isAllowPingbacks());
		mbMessageImpl.setAnswer(isAnswer());
		mbMessageImpl.setLastPublishDate(getLastPublishDate());
		mbMessageImpl.setStatus(getStatus());
		mbMessageImpl.setStatusByUserId(getStatusByUserId());
		mbMessageImpl.setStatusByUserName(getStatusByUserName());
		mbMessageImpl.setStatusDate(getStatusDate());

		mbMessageImpl.resetOriginalValues();

		return mbMessageImpl;
	}

	@Override
	public int compareTo(MBMessage mbMessage) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(), mbMessage.getCreateDate());

		if (value != 0) {
			return value;
		}

		if (getMessageId() < mbMessage.getMessageId()) {
			value = -1;
		}
		else if (getMessageId() > mbMessage.getMessageId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MBMessage)) {
			return false;
		}

		MBMessage mbMessage = (MBMessage)object;

		long primaryKey = mbMessage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_originalUserId = _userId;

		_setOriginalUserId = false;

		_setModifiedDate = false;
		_originalClassNameId = _classNameId;

		_setOriginalClassNameId = false;

		_originalClassPK = _classPK;

		_setOriginalClassPK = false;

		_originalCategoryId = _categoryId;

		_setOriginalCategoryId = false;

		_originalThreadId = _threadId;

		_setOriginalThreadId = false;

		_originalParentMessageId = _parentMessageId;

		_setOriginalParentMessageId = false;

		_originalAnswer = _answer;

		_setOriginalAnswer = false;

		_originalStatus = _status;

		_setOriginalStatus = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<MBMessage> toCacheModel() {
		MBMessageCacheModel mbMessageCacheModel = new MBMessageCacheModel();

		mbMessageCacheModel.uuid = getUuid();

		String uuid = mbMessageCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			mbMessageCacheModel.uuid = null;
		}

		mbMessageCacheModel.messageId = getMessageId();

		mbMessageCacheModel.groupId = getGroupId();

		mbMessageCacheModel.companyId = getCompanyId();

		mbMessageCacheModel.userId = getUserId();

		mbMessageCacheModel.userName = getUserName();

		String userName = mbMessageCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			mbMessageCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			mbMessageCacheModel.createDate = createDate.getTime();
		}
		else {
			mbMessageCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			mbMessageCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			mbMessageCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		mbMessageCacheModel.classNameId = getClassNameId();

		mbMessageCacheModel.classPK = getClassPK();

		mbMessageCacheModel.categoryId = getCategoryId();

		mbMessageCacheModel.threadId = getThreadId();

		mbMessageCacheModel.rootMessageId = getRootMessageId();

		mbMessageCacheModel.parentMessageId = getParentMessageId();

		mbMessageCacheModel.subject = getSubject();

		String subject = mbMessageCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			mbMessageCacheModel.subject = null;
		}

		mbMessageCacheModel.body = getBody();

		String body = mbMessageCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			mbMessageCacheModel.body = null;
		}

		mbMessageCacheModel.format = getFormat();

		String format = mbMessageCacheModel.format;

		if ((format != null) && (format.length() == 0)) {
			mbMessageCacheModel.format = null;
		}

		mbMessageCacheModel.anonymous = isAnonymous();

		mbMessageCacheModel.priority = getPriority();

		mbMessageCacheModel.allowPingbacks = isAllowPingbacks();

		mbMessageCacheModel.answer = isAnswer();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			mbMessageCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			mbMessageCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		mbMessageCacheModel.status = getStatus();

		mbMessageCacheModel.statusByUserId = getStatusByUserId();

		mbMessageCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = mbMessageCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			mbMessageCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			mbMessageCacheModel.statusDate = statusDate.getTime();
		}
		else {
			mbMessageCacheModel.statusDate = Long.MIN_VALUE;
		}

		return mbMessageCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<MBMessage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<MBMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBMessage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((MBMessage)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<MBMessage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<MBMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBMessage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((MBMessage)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, MBMessage>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _uuid;
	private String _originalUuid;
	private long _messageId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _originalClassNameId;
	private boolean _setOriginalClassNameId;
	private long _classPK;
	private long _originalClassPK;
	private boolean _setOriginalClassPK;
	private long _categoryId;
	private long _originalCategoryId;
	private boolean _setOriginalCategoryId;
	private long _threadId;
	private long _originalThreadId;
	private boolean _setOriginalThreadId;
	private long _rootMessageId;
	private long _parentMessageId;
	private long _originalParentMessageId;
	private boolean _setOriginalParentMessageId;
	private String _subject;
	private String _body;
	private String _format;
	private boolean _anonymous;
	private double _priority;
	private boolean _allowPingbacks;
	private boolean _answer;
	private boolean _originalAnswer;
	private boolean _setOriginalAnswer;
	private Date _lastPublishDate;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private MBMessage _escapedModel;

}