/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.comment.internal;

import com.liferay.comment.configuration.CommentGroupServiceConfiguration;
import com.liferay.message.boards.comment.internal.MBCommentImpl;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBBanLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.comment.BaseDiscussionPermission;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DiscussionPermission.class})
public class MBDiscussionPermissionImpl
extends BaseDiscussionPermission {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private MBBanLocalService _mbBanLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private WorkflowPermission _workflowPermission;

    public boolean hasAddPermission(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK) {
        return this.hasPermission(permissionChecker, companyId, groupId, className, classPK, "ADD_DISCUSSION");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, Comment comment, String actionId) throws PortalException {
        if (comment instanceof MBCommentImpl) {
            MBCommentImpl mbCommentImpl = (MBCommentImpl)comment;
            MBMessage mbMessage = mbCommentImpl.getMessage();
            return this._hasPermission(permissionChecker, mbMessage, actionId);
        }
        return this.hasPermission(permissionChecker, comment.getCommentId(), actionId);
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK, String actionId) {
        if (this._mbBanLocalService.hasBan(groupId, permissionChecker.getUserId())) {
            return false;
        }
        List resourceActions = ResourceActionsUtil.getResourceActions((String)className);
        if (!resourceActions.contains(actionId)) {
            return true;
        }
        Boolean hasPermission = ModelResourcePermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)className, (long)classPK, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return permissionChecker.hasPermission(groupId, className, classPK, actionId);
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long commentId, String actionId) throws PortalException {
        return this._hasPermission(permissionChecker, this._mbMessageLocalService.getMessage(commentId), actionId);
    }

    public boolean hasSubscribePermission(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK) {
        return this.hasViewPermission(permissionChecker, companyId, groupId, className, classPK);
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker, long companyId, long groupId, String className, long classPK) {
        return this.hasPermission(permissionChecker, companyId, groupId, className, classPK, "VIEW");
    }

    private boolean _hasPermission(PermissionChecker permissionChecker, MBMessage message, String actionId) throws ConfigurationException {
        Boolean hasPermission;
        String className = message.getClassName();
        if (className.equals(WorkflowInstance.class.getName())) {
            return permissionChecker.hasPermission(message.getGroupId(), "com_liferay_portal_workflow_definition_web_portlet_WorkflowDefinitionPortlet", message.getGroupId(), "VIEW");
        }
        CommentGroupServiceConfiguration commentGroupServiceConfiguration = (CommentGroupServiceConfiguration)this._configurationProvider.getGroupConfiguration(CommentGroupServiceConfiguration.class, message.getGroupId());
        if (commentGroupServiceConfiguration.alwaysEditableByOwner() && permissionChecker.getUserId() == message.getUserId()) {
            return true;
        }
        if (message.isPending() && (hasPermission = this._workflowPermission.hasPermission(permissionChecker, message.getGroupId(), message.getWorkflowClassName(), message.getMessageId(), actionId)) != null) {
            return hasPermission;
        }
        return this.hasPermission(permissionChecker, message.getCompanyId(), message.getGroupId(), className, message.getClassPK(), actionId);
    }
}

