/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.comment.internal;

import com.liferay.comment.constants.CommentConstants;
import com.liferay.message.boards.comment.internal.MBCommentImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionCommentImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionStagingHandler;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBTreeWalker;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.util.MBUtil;
import com.liferay.message.boards.util.comparator.MessageThreadComparator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.DiscussionStagingHandler;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommentManager.class})
public class MBCommentManagerImpl
implements CommentManager {
    @Reference
    private DiscussionPermission _discussionPermission;
    @Reference
    private MBDiscussionLocalService _mbDiscussionLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public long addComment(long userId, long groupId, String className, long classPK, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread thread = messageDisplay.getThread();
        List messages = this._mbMessageLocalService.getThreadMessages(thread.getThreadId(), 0);
        for (MBMessage message : messages) {
            String messageBody = message.getBody();
            if (!messageBody.equals(body)) continue;
            throw new DuplicateCommentException(body);
        }
        ServiceContext serviceContext = serviceContextFunction.apply(MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(null, userId, "", groupId, className, classPK, thread.getThreadId(), thread.getRootMessageId(), "", body, serviceContext);
        return mbMessage.getMessageId();
    }

    public long addComment(String externalReferenceCode, long userId, long groupId, String className, long classPK, String userName, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay mbMessageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread mbThread = mbMessageDisplay.getThread();
        ServiceContext serviceContext = serviceContextFunction.apply(MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(externalReferenceCode, userId, userName, groupId, className, classPK, mbThread.getThreadId(), mbThread.getRootMessageId(), subject, body, serviceContext);
        return mbMessage.getMessageId();
    }

    public long addComment(String externalReferenceCode, long userId, String className, long classPK, String userName, long parentCommentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessage parentMessage = this._mbMessageLocalService.getMessage(parentCommentId);
        ServiceContext serviceContext = serviceContextFunction.apply(MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(externalReferenceCode, userId, userName, parentMessage.getGroupId(), className, classPK, parentMessage.getThreadId(), parentCommentId, subject, body, serviceContext);
        return mbMessage.getMessageId();
    }

    public void addDiscussion(long userId, long groupId, String className, long classPK, String userName) throws PortalException {
        this._mbMessageLocalService.addDiscussionMessage(userId, userName, groupId, className, classPK, 1);
    }

    public Discussion copyDiscussion(long userId, long groupId, String className, long classPK, long newClassPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        if (!this.hasDiscussion(className, classPK)) {
            return null;
        }
        MBMessage newRootMBMessage = this._copyRootMessage(userId, groupId, className, classPK, newClassPK, serviceContextFunction);
        List<Comment> rootComments = this.getRootComments(className, classPK, -1, 0, this.getRootCommentsCount(className, classPK, -1));
        for (Comment rootComment : rootComments) {
            this._duplicateComment(rootComment, newRootMBMessage.getMessageId(), newClassPK, serviceContextFunction);
        }
        List subscriptions = this._subscriptionLocalService.getSubscriptions(CompanyThreadLocal.getCompanyId().longValue(), MBUtil.getSubscriptionClassName((String)className), classPK);
        for (Subscription subscription : subscriptions) {
            this.subscribeDiscussion(subscription.getUserId(), subscription.getGroupId(), className, newClassPK);
        }
        return this.getDiscussion(userId, groupId, className, newClassPK, serviceContextFunction);
    }

    public void deleteComment(long commentId) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessage(commentId);
    }

    public void deleteDiscussion(String className, long classPK) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessages(className, classPK);
    }

    public void deleteGroupComments(long groupId) throws PortalException {
        this._mbThreadLocalService.deleteThreads(groupId, -1L);
    }

    public Comment fetchComment(long commentId) {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(commentId);
        if (mbMessage == null) {
            return null;
        }
        return new MBCommentImpl(mbMessage);
    }

    public Comment fetchComment(long groupId, String externalReferenceCode) {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessageByExternalReferenceCode(externalReferenceCode, groupId);
        if (mbMessage == null) {
            return null;
        }
        return new MBCommentImpl(mbMessage);
    }

    public DiscussionComment fetchDiscussionComment(long userId, long commentId) throws PortalException {
        MBMessage mbMessage = this._mbMessageLocalService.fetchMBMessage(commentId);
        if (mbMessage == null) {
            return null;
        }
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, mbMessage.getGroupId(), mbMessage.getClassName(), mbMessage.getClassPK(), -1, (Comparator)new MessageThreadComparator());
        return this._getDiscussionComment(userId, messageDisplay);
    }

    public List<Comment> getChildComments(long parentCommentId, int status, int start, int end) {
        return TransformUtil.transform((Collection)this._mbMessageLocalService.getChildMessages(parentCommentId, status, start, end), MBCommentImpl::new);
    }

    public int getChildCommentsCount(long parentCommentId, int status) {
        return this._mbMessageLocalService.getChildMessagesCount(parentCommentId, status);
    }

    public Comment getComment(long groupId, String externalReferenceCode) throws PortalException {
        return new MBCommentImpl(this._mbMessageLocalService.getMBMessageByExternalReferenceCode(externalReferenceCode, groupId));
    }

    public int getCommentsCount(String className, long classPK) {
        return this._mbMessageLocalService.getDiscussionMessagesCount(this._portal.getClassNameId(className), classPK, 0);
    }

    public Discussion getDiscussion(long userId, long groupId, String className, long classPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, -1, (Comparator)new MessageThreadComparator());
        DiscussionComment rootDiscussionComment = this._getDiscussionComment(userId, messageDisplay);
        MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
        List messages = treeWalker.getMessages();
        return new MBDiscussionImpl(rootDiscussionComment, messageDisplay.isDiscussionMaxComments(), messages.size() - 1);
    }

    public DiscussionStagingHandler getDiscussionStagingHandler() {
        return new MBDiscussionStagingHandler();
    }

    public List<Comment> getRootComments(String className, long classPK, int status, int start, int end) throws PortalException {
        return TransformUtil.transform((Collection)this._mbMessageLocalService.getRootDiscussionMessages(className, classPK, status, start, end), MBCommentImpl::new);
    }

    public int getRootCommentsCount(String className, long classPK, int status) {
        return this._mbMessageLocalService.getRootDiscussionMessagesCount(className, classPK, status);
    }

    public boolean hasDiscussion(String className, long classPK) {
        MBDiscussion discussion = this._mbDiscussionLocalService.fetchDiscussion(className, classPK);
        return discussion != null;
    }

    public void moveDiscussionToTrash(String className, long classPK) {
        List messages = this._mbMessageLocalService.getMessages(className, classPK, 0);
        for (MBMessage message : messages) {
            message.setStatus(8);
            this._mbMessageLocalService.updateMBMessage(message);
        }
    }

    public void restoreDiscussionFromTrash(String className, long classPK) {
        List messages = this._mbMessageLocalService.getMessages(className, classPK, 8);
        for (MBMessage message : messages) {
            message.setStatus(0);
            this._mbMessageLocalService.updateMBMessage(message);
        }
    }

    public void subscribeDiscussion(long userId, long groupId, String className, long classPK) throws PortalException {
        this._mbDiscussionLocalService.subscribeDiscussion(userId, groupId, className, classPK);
    }

    public void unsubscribeDiscussion(long userId, String className, long classPK) throws PortalException {
        this._mbDiscussionLocalService.unsubscribeDiscussion(userId, className, classPK);
    }

    public long updateComment(long userId, String className, long classPK, long commentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        ServiceContext serviceContext = serviceContextFunction.apply(MBMessage.class.getName());
        MBMessage message = this._mbMessageLocalService.updateDiscussionMessage(userId, commentId, className, classPK, subject, body, serviceContext);
        return message.getMessageId();
    }

    private MBMessage _copyRootMessage(long userId, long groupId, String className, long classPK, long newClassPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        Discussion discussion = this.getDiscussion(userId, groupId, className, classPK, serviceContextFunction);
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        MBMessage rootMBMessage = this._mbMessageLocalService.addDiscussionMessage(rootDiscussionComment.getUserId(), rootDiscussionComment.getUserName(), rootDiscussionComment.getGroupId(), rootDiscussionComment.getClassName(), newClassPK, 1);
        rootMBMessage.setCreateDate(rootDiscussionComment.getCreateDate());
        rootMBMessage.setModifiedDate(rootDiscussionComment.getModifiedDate());
        return this._mbMessageLocalService.updateMBMessage(rootMBMessage);
    }

    private void _duplicateComment(Comment comment, long parentCommentId, long newClassPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessage mbMessage = this._mbMessageLocalService.getMBMessage(comment.getCommentId());
        long newCommentId = this.addComment(null, comment.getUserId(), comment.getClassName(), newClassPK, comment.getUserName(), parentCommentId, mbMessage.getSubject(), comment.getBody(), serviceContextFunction);
        MBMessage newMBMessage = this._mbMessageLocalService.fetchMBMessage(newCommentId);
        int childCommentsCount = this.getChildCommentsCount(comment.getCommentId(), -1);
        if (childCommentsCount > 0) {
            List<Comment> childComments = this.getChildComments(comment.getCommentId(), -1, 0, childCommentsCount);
            for (Comment childComment : childComments) {
                this._duplicateComment(childComment, newCommentId, newClassPK, serviceContextFunction);
            }
        }
        newMBMessage.setCreateDate(mbMessage.getCreateDate());
        newMBMessage.setModifiedDate(mbMessage.getModifiedDate());
        newMBMessage.setStatus(mbMessage.getStatus());
        this._mbMessageLocalService.updateMBMessage(newMBMessage);
    }

    private DiscussionComment _getDiscussionComment(long userId, MBMessageDisplay messageDisplay) {
        MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
        List messages = treeWalker.getMessages();
        ArrayList<Long> classPKs = new ArrayList<Long>();
        if (messages.size() > 1) {
            for (MBMessage curMessage : messages) {
                if (curMessage.isRoot()) continue;
                classPKs.add(curMessage.getMessageId());
            }
        }
        if (classPKs.isEmpty()) {
            return new MBDiscussionCommentImpl(treeWalker.getRoot(), treeWalker, Collections.emptyMap(), Collections.emptyMap());
        }
        long[] classPKsArray = ArrayUtil.toLongArray(classPKs);
        Map ratingsEntries = null;
        Map ratingsStats = this._ratingsStatsLocalService.getStats(CommentConstants.getDiscussionClassName(), classPKsArray);
        ratingsEntries = ratingsStats.isEmpty() ? Collections.emptyMap() : this._ratingsEntryLocalService.getEntries(userId, CommentConstants.getDiscussionClassName(), classPKsArray);
        return new MBDiscussionCommentImpl(treeWalker.getRoot(), treeWalker, ratingsEntries, ratingsStats);
    }
}

