/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.message.boards.comment.internal;

import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;

/**
 * @author Adolfo Pérez
 */
public class MBDiscussionImpl implements Discussion {

	public MBDiscussionImpl(
		DiscussionComment rootDiscussionComment,
		boolean maxCommentsLimitExceeded) {

		_rootDiscussionComment = rootDiscussionComment;
		_maxCommentsLimitExceeded = maxCommentsLimitExceeded;
	}

	@Override
	public DiscussionComment getRootDiscussionComment() {
		return _rootDiscussionComment;
	}

	@Override
	public boolean isMaxCommentsLimitExceeded() {
		return _maxCommentsLimitExceeded;
	}

	private final boolean _maxCommentsLimitExceeded;
	private final DiscussionComment _rootDiscussionComment;

}