/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.comment.internal;

import com.liferay.message.boards.comment.internal.MBCommentImpl;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBTreeWalker;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionCommentIterator;
import com.liferay.portal.kernel.comment.WorkflowableComment;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.persistence.RatingsStatsUtil;
import java.util.ArrayList;
import java.util.List;

public class MBDiscussionCommentImpl
extends MBCommentImpl
implements DiscussionComment,
WorkflowableComment {
    private final List<RatingsEntry> _ratingsEntries;
    private final List<RatingsStats> _ratingsStats;
    private final MBTreeWalker _treeWalker;

    public MBDiscussionCommentImpl(MBMessage message, MBTreeWalker treeWalker, List<RatingsEntry> ratingsEntries, List<RatingsStats> ratingsStats) {
        super(message);
        this._treeWalker = treeWalker;
        this._ratingsEntries = ratingsEntries;
        this._ratingsStats = ratingsStats;
    }

    public DiscussionComment getParentComment() throws PortalException {
        MBMessage message = this.getMessage();
        long parentMessageId = message.getParentMessageId();
        if (parentMessageId == 0L) {
            return null;
        }
        MBMessage parentMessage = MBMessageLocalServiceUtil.getMessage((long)parentMessageId);
        return new MBDiscussionCommentImpl(parentMessage, this._treeWalker, this._ratingsEntries, this._ratingsStats);
    }

    public RatingsEntry getRatingsEntry() {
        long classPK = this.getCommentId();
        for (RatingsEntry ratingsEntry : this._ratingsEntries) {
            if (ratingsEntry.getClassPK() != classPK) continue;
            return ratingsEntry;
        }
        return null;
    }

    public RatingsStats getRatingsStats() {
        long classPK = this.getCommentId();
        for (RatingsStats ratingsStats : this._ratingsStats) {
            if (ratingsStats.getClassPK() != classPK) continue;
            return ratingsStats;
        }
        return RatingsStatsUtil.create((long)0L);
    }

    public List<DiscussionComment> getThreadComments() {
        ArrayList<DiscussionComment> discussionComments = new ArrayList<DiscussionComment>();
        DiscussionCommentIterator discussionCommentIterator = this.getThreadDiscussionCommentIterator();
        while (discussionCommentIterator.hasNext()) {
            discussionComments.add((DiscussionComment)discussionCommentIterator.next());
        }
        return discussionComments;
    }

    public int getThreadCommentsCount() {
        List messages = this._treeWalker.getMessages();
        return messages.size();
    }

    public DiscussionCommentIterator getThreadDiscussionCommentIterator() {
        List messages = this._treeWalker.getMessages();
        int[] range = this._treeWalker.getChildrenRange(this.getMessage());
        return new MBDiscussionCommentIterator(messages, range[0], range[1], this._treeWalker);
    }

    public DiscussionCommentIterator getThreadDiscussionCommentIterator(int from) {
        List messages = this._treeWalker.getMessages();
        int[] range = this._treeWalker.getChildrenRange(this.getMessage());
        return new MBDiscussionCommentIterator(messages, from + 1, range[1], this._treeWalker);
    }

    public boolean isInTrash() {
        MBMessage message = this.getMessage();
        return message.isInTrash();
    }

    @Override
    public boolean isRoot() {
        MBMessage message = this.getMessage();
        return message.isRoot();
    }

    private class MBDiscussionCommentIterator
    implements DiscussionCommentIterator {
        private int _from;
        private final List<MBMessage> _messages;
        private final int _to;
        private final MBTreeWalker _treeWalker;

        public MBDiscussionCommentIterator(List<MBMessage> messages, int from, int to, MBTreeWalker treeWalker) {
            this._messages = messages;
            this._from = from;
            this._to = to;
            this._treeWalker = treeWalker;
        }

        public int getIndexPage() {
            return this._from;
        }

        public boolean hasNext() {
            return this._from < this._to;
        }

        public DiscussionComment next() {
            MBDiscussionCommentImpl discussionComment = new MBDiscussionCommentImpl(this._messages.get(this._from), this._treeWalker, MBDiscussionCommentImpl.this._ratingsEntries, MBDiscussionCommentImpl.this._ratingsStats);
            ++this._from;
            return discussionComment;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

