/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.comment.internal;

import com.liferay.message.boards.comment.internal.MBCommentImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionCommentImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionPermissionImpl;
import com.liferay.message.boards.comment.internal.MBDiscussionStagingHandler;
import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBMessageDisplay;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.model.MBTreeWalker;
import com.liferay.message.boards.kernel.service.MBDiscussionLocalService;
import com.liferay.message.boards.kernel.service.MBMessageLocalService;
import com.liferay.message.boards.kernel.service.MBThreadLocalService;
import com.liferay.message.boards.kernel.util.comparator.MessageThreadComparator;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentConstants;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.DiscussionStagingHandler;
import com.liferay.portal.kernel.comment.DuplicateCommentException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommentManager.class})
public class MBCommentManagerImpl
implements CommentManager {
    private MBDiscussionLocalService _mbDiscussionLocalService;
    private MBMessageLocalService _mbMessageLocalService;
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private Portal _portal;
    private RatingsEntryLocalService _ratingsEntryLocalService;
    private RatingsStatsLocalService _ratingsStatsLocalService;

    public long addComment(long userId, long groupId, String className, long classPK, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread thread = messageDisplay.getThread();
        List messages = this._mbMessageLocalService.getThreadMessages(thread.getThreadId(), 0);
        for (MBMessage message : messages) {
            String messageBody = message.getBody();
            if (!messageBody.equals(body)) continue;
            throw new DuplicateCommentException(body);
        }
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(userId, "", groupId, className, classPK, thread.getThreadId(), thread.getRootMessageId(), "", body, serviceContext);
        return mbMessage.getMessageId();
    }

    public long addComment(long userId, long groupId, String className, long classPK, String userName, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay mbMessageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, 0);
        MBThread mbThread = mbMessageDisplay.getThread();
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(userId, userName, groupId, className, classPK, mbThread.getThreadId(), mbThread.getRootMessageId(), subject, body, serviceContext);
        return mbMessage.getMessageId();
    }

    public long addComment(long userId, String className, long classPK, String userName, long parentCommentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessage parentMessage = this._mbMessageLocalService.getMessage(parentCommentId);
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage mbMessage = this._mbMessageLocalService.addDiscussionMessage(userId, userName, parentMessage.getGroupId(), className, classPK, parentMessage.getThreadId(), parentCommentId, subject, body, serviceContext);
        return mbMessage.getMessageId();
    }

    public void addDiscussion(long userId, long groupId, String className, long classPK, String userName) throws PortalException {
        this._mbMessageLocalService.addDiscussionMessage(userId, userName, groupId, className, classPK, 1);
    }

    public void deleteComment(long commentId) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessage(commentId);
    }

    public void deleteDiscussion(String className, long classPK) throws PortalException {
        this._mbMessageLocalService.deleteDiscussionMessages(className, classPK);
    }

    public void deleteGroupComments(long groupId) throws PortalException {
        this._mbThreadLocalService.deleteThreads(groupId, -1L);
    }

    public Comment fetchComment(long commentId) {
        return new MBCommentImpl(this._mbMessageLocalService.fetchMBMessage(commentId));
    }

    public int getCommentsCount(String className, long classPK) {
        long classNameId = this._portal.getClassNameId(className);
        return this._mbMessageLocalService.getDiscussionMessagesCount(classNameId, classPK, 0);
    }

    public Discussion getDiscussion(long userId, long groupId, String className, long classPK, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        MBMessageDisplay messageDisplay = this._mbMessageLocalService.getDiscussionMessageDisplay(userId, groupId, className, classPK, -1, (Comparator)new MessageThreadComparator());
        MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
        List messages = treeWalker.getMessages();
        List ratingsEntries = Collections.emptyList();
        List ratingsStats = Collections.emptyList();
        if (messages.size() > 1) {
            ArrayList<Long> classPKs = new ArrayList<Long>();
            for (MBMessage curMessage : messages) {
                if (curMessage.isRoot()) continue;
                classPKs.add(curMessage.getMessageId());
            }
            ratingsEntries = this._ratingsEntryLocalService.getEntries(userId, CommentConstants.getDiscussionClassName(), classPKs);
            ratingsStats = this._ratingsStatsLocalService.getStats(CommentConstants.getDiscussionClassName(), classPKs);
        }
        MBDiscussionCommentImpl rootDiscussionComment = new MBDiscussionCommentImpl(treeWalker.getRoot(), treeWalker, ratingsEntries, ratingsStats);
        return new MBDiscussionImpl(rootDiscussionComment, messageDisplay.isDiscussionMaxComments());
    }

    public DiscussionPermission getDiscussionPermission(PermissionChecker permissionChecker) {
        return new MBDiscussionPermissionImpl(permissionChecker);
    }

    public DiscussionStagingHandler getDiscussionStagingHandler() {
        return new MBDiscussionStagingHandler();
    }

    public boolean hasDiscussion(String className, long classPK) {
        MBDiscussion discussion = this._mbDiscussionLocalService.fetchDiscussion(className, classPK);
        return discussion != null;
    }

    public void moveDiscussionToTrash(String className, long classPK) {
        List messages = this._mbMessageLocalService.getMessages(className, classPK, 0);
        for (MBMessage message : messages) {
            message.setStatus(8);
            this._mbMessageLocalService.updateMBMessage(message);
        }
    }

    public void restoreDiscussionFromTrash(String className, long classPK) {
        List messages = this._mbMessageLocalService.getMessages(className, classPK, 8);
        for (MBMessage message : messages) {
            message.setStatus(0);
            this._mbMessageLocalService.updateMBMessage(message);
        }
    }

    @Reference(unbind="-")
    public void setMBDiscussionLocalService(MBDiscussionLocalService mbDiscussionLocalService) {
        this._mbDiscussionLocalService = mbDiscussionLocalService;
    }

    @Reference(unbind="-")
    public void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    public void setRatingsEntryLocalService(RatingsEntryLocalService ratingsEntryLocalService) {
        this._ratingsEntryLocalService = ratingsEntryLocalService;
    }

    @Reference(unbind="-")
    public void setRatingsStatsLocalService(RatingsStatsLocalService ratingsStatsLocalService) {
        this._ratingsStatsLocalService = ratingsStatsLocalService;
    }

    public void subscribeDiscussion(long userId, long groupId, String className, long classPK) throws PortalException {
        this._mbDiscussionLocalService.subscribeDiscussion(userId, groupId, className, classPK);
    }

    public void unsubscribeDiscussion(long userId, String className, long classPK) throws PortalException {
        this._mbDiscussionLocalService.unsubscribeDiscussion(userId, className, classPK);
    }

    public long updateComment(long userId, String className, long classPK, long commentId, String subject, String body, Function<String, ServiceContext> serviceContextFunction) throws PortalException {
        ServiceContext serviceContext = (ServiceContext)serviceContextFunction.apply((Object)MBMessage.class.getName());
        MBMessage message = this._mbMessageLocalService.updateDiscussionMessage(userId, commentId, className, classPK, subject, body, serviceContext);
        return message.getMessageId();
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }
}

