Liferay.Loader.define("map-openstreetmap@4.0.35/js/OpenStreetMapMarker.es", ['module', 'exports', 'require', 'map-common/js/MarkerBase.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.OpenStreetMapMarker = exports["default"] = void 0;

  var _MarkerBase2 = _interopRequireDefault(require("map-common/js/MarkerBase.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * OpenStreetMapMarker
   * @review
   */
  var OpenStreetMapMarker = /*#__PURE__*/function (_MarkerBase) {
    _inherits(OpenStreetMapMarker, _MarkerBase);

    function OpenStreetMapMarker() {
      _classCallCheck(this, OpenStreetMapMarker);

      return _possibleConstructorReturn(this, _getPrototypeOf(OpenStreetMapMarker).apply(this, arguments));
    }

    _createClass(OpenStreetMapMarker, [{
      key: "_getNativeMarker",

      /**
       * @inheritDoc
       * @review
       */
      value: function _getNativeMarker(location, map) {
        if (!this._nativeMarker) {
          this._nativeMarker = L.marker(location, {
            draggable: true
          }).addTo(map);

          this._nativeMarker.on('click', this._getNativeEventFunction('click'));

          this._nativeMarker.on('dblclick', this._getNativeEventFunction('dblclick'));

          this._nativeMarker.on('drag', this._getNativeEventFunction('drag'));

          this._nativeMarker.on('dragend', this._getNativeEventFunction('dragend'));

          this._nativeMarker.on('dragstart', this._getNativeEventFunction('dragstart'));

          this._nativeMarker.on('mousedown', this._getNativeEventFunction('mousedown'));

          this._nativeMarker.on('mouseout', this._getNativeEventFunction('mouseout'));

          this._nativeMarker.on('mouseover', this._getNativeEventFunction('mouseover'));
        }

        return this._nativeMarker;
      }
      /**
       * @inheritDoc
       * @review
       */

    }, {
      key: "_getNormalizedEventData",
      value: function _getNormalizedEventData(nativeEvent) {
        return {
          location: nativeEvent.target.getLatLng()
        };
      }
      /**
       * If a marked has been created, sets the marker location to the given one
       * @param {Object} location Location to set the native marker in
       * @review
       */

    }, {
      key: "setPosition",
      value: function setPosition(location) {
        if (this._nativeMarker) {
          this._nativeMarker.setLatLng(location);
        }
      }
    }]);

    return OpenStreetMapMarker;
  }(_MarkerBase2["default"]);

  exports.OpenStreetMapMarker = OpenStreetMapMarker;
  var _default = OpenStreetMapMarker;
  exports["default"] = _default;
  //# sourceMappingURL=OpenStreetMapMarker.es.js.map
});
//# sourceMappingURL=OpenStreetMapMarker.es.js.map