/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.persistence.impl;

import com.liferay.mail.reader.exception.NoSuchFolderException;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.model.FolderTable;
import com.liferay.mail.reader.model.impl.FolderImpl;
import com.liferay.mail.reader.model.impl.FolderModelImpl;
import com.liferay.mail.reader.service.persistence.FolderPersistence;
import com.liferay.mail.reader.service.persistence.FolderUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={FolderPersistence.class})
public class FolderPersistenceImpl
extends BasePersistenceImpl<Folder>
implements FolderPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = FolderImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByAccountId;
    private FinderPath _finderPathWithoutPaginationFindByAccountId;
    private FinderPath _finderPathCountByAccountId;
    private static final String _FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2 = "folder.accountId = ?";
    private FinderPath _finderPathFetchByA_F;
    private FinderPath _finderPathCountByA_F;
    private static final String _FINDER_COLUMN_A_F_ACCOUNTID_2 = "folder.accountId = ? AND ";
    private static final String _FINDER_COLUMN_A_F_FULLNAME_2 = "folder.fullName = ?";
    private static final String _FINDER_COLUMN_A_F_FULLNAME_3 = "(folder.fullName IS NULL OR folder.fullName = '')";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_FOLDER = "SELECT folder FROM Folder folder";
    private static final String _SQL_SELECT_FOLDER_WHERE = "SELECT folder FROM Folder folder WHERE ";
    private static final String _SQL_COUNT_FOLDER = "SELECT COUNT(folder) FROM Folder folder";
    private static final String _SQL_COUNT_FOLDER_WHERE = "SELECT COUNT(folder) FROM Folder folder WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "folder.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Folder exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Folder exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(FolderPersistenceImpl.class);
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<Folder> findByAccountId(long accountId) {
        return this.findByAccountId(accountId, -1, -1, null);
    }

    public List<Folder> findByAccountId(long accountId, int start, int end) {
        return this.findByAccountId(accountId, start, end, null);
    }

    public List<Folder> findByAccountId(long accountId, int start, int end, OrderByComparator<Folder> orderByComparator) {
        return this.findByAccountId(accountId, start, end, orderByComparator, true);
    }

    public List<Folder> findByAccountId(long accountId, int start, int end, OrderByComparator<Folder> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByAccountId;
                finderArgs = new Object[]{accountId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByAccountId;
            finderArgs = new Object[]{accountId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Folder folder : list) {
                if (accountId == folder.getAccountId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_FOLDER_WHERE);
            sb.append(_FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY folder.fullName ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Folder findByAccountId_First(long accountId, OrderByComparator<Folder> orderByComparator) throws NoSuchFolderException {
        Folder folder = this.fetchByAccountId_First(accountId, orderByComparator);
        if (folder != null) {
            return folder;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accountId=");
        sb.append(accountId);
        sb.append("}");
        throw new NoSuchFolderException(sb.toString());
    }

    public Folder fetchByAccountId_First(long accountId, OrderByComparator<Folder> orderByComparator) {
        List<Folder> list = this.findByAccountId(accountId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Folder findByAccountId_Last(long accountId, OrderByComparator<Folder> orderByComparator) throws NoSuchFolderException {
        Folder folder = this.fetchByAccountId_Last(accountId, orderByComparator);
        if (folder != null) {
            return folder;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accountId=");
        sb.append(accountId);
        sb.append("}");
        throw new NoSuchFolderException(sb.toString());
    }

    public Folder fetchByAccountId_Last(long accountId, OrderByComparator<Folder> orderByComparator) {
        int count = this.countByAccountId(accountId);
        if (count == 0) {
            return null;
        }
        List<Folder> list = this.findByAccountId(accountId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Folder[] findByAccountId_PrevAndNext(long folderId, long accountId, OrderByComparator<Folder> orderByComparator) throws NoSuchFolderException {
        Folder folder = this.findByPrimaryKey(folderId);
        Session session = null;
        try {
            session = this.openSession();
            Folder[] array = new FolderImpl[]{this.getByAccountId_PrevAndNext(session, folder, accountId, orderByComparator, true), folder, this.getByAccountId_PrevAndNext(session, folder, accountId, orderByComparator, false)};
            Folder[] folderArray = array;
            return folderArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Folder getByAccountId_PrevAndNext(Session session, Folder folder, long accountId, OrderByComparator<Folder> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_FOLDER_WHERE);
        sb.append(_FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY folder.fullName ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(accountId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)folder)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Folder)list.get(1);
        }
        return null;
    }

    public void removeByAccountId(long accountId) {
        for (Folder folder : this.findByAccountId(accountId, -1, -1, null)) {
            this.remove((BaseModel)folder);
        }
    }

    public int countByAccountId(long accountId) {
        FinderPath finderPath = this._finderPathCountByAccountId;
        Object[] finderArgs = new Object[]{accountId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_FOLDER_WHERE);
            sb.append(_FINDER_COLUMN_ACCOUNTID_ACCOUNTID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Folder findByA_F(long accountId, String fullName) throws NoSuchFolderException {
        Folder folder = this.fetchByA_F(accountId, fullName);
        if (folder == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("accountId=");
            sb.append(accountId);
            sb.append(", fullName=");
            sb.append(fullName);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchFolderException(sb.toString());
        }
        return folder;
    }

    public Folder fetchByA_F(long accountId, String fullName) {
        return this.fetchByA_F(accountId, fullName, true);
    }

    public Folder fetchByA_F(long accountId, String fullName, boolean useFinderCache) {
        Folder folder;
        fullName = Objects.toString(fullName, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{accountId, fullName};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByA_F, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Folder && (accountId != (folder = (Folder)result).getAccountId() || !Objects.equals(fullName, folder.getFullName()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_FOLDER_WHERE);
            sb.append(_FINDER_COLUMN_A_F_ACCOUNTID_2);
            boolean bindFullName = false;
            if (fullName.isEmpty()) {
                sb.append(_FINDER_COLUMN_A_F_FULLNAME_3);
            } else {
                bindFullName = true;
                sb.append(_FINDER_COLUMN_A_F_FULLNAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountId);
                if (bindFullName) {
                    queryPos.add(fullName);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByA_F, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{accountId, fullName};
                            }
                            _log.warn((Object)("FolderPersistenceImpl.fetchByA_F(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Folder folder2 = (Folder)list.get(0);
                    result = folder2;
                    this.cacheResult(folder2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Folder)result;
    }

    public Folder removeByA_F(long accountId, String fullName) throws NoSuchFolderException {
        Folder folder = this.findByA_F(accountId, fullName);
        return (Folder)this.remove((BaseModel)folder);
    }

    public int countByA_F(long accountId, String fullName) {
        fullName = Objects.toString(fullName, "");
        FinderPath finderPath = this._finderPathCountByA_F;
        Object[] finderArgs = new Object[]{accountId, fullName};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_FOLDER_WHERE);
            sb.append(_FINDER_COLUMN_A_F_ACCOUNTID_2);
            boolean bindFullName = false;
            if (fullName.isEmpty()) {
                sb.append(_FINDER_COLUMN_A_F_FULLNAME_3);
            } else {
                bindFullName = true;
                sb.append(_FINDER_COLUMN_A_F_FULLNAME_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accountId);
                if (bindFullName) {
                    queryPos.add(fullName);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public FolderPersistenceImpl() {
        this.setModelClass(Folder.class);
        this.setModelImplClass(FolderImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)FolderTable.INSTANCE);
    }

    public void cacheResult(Folder folder) {
        this.entityCache.putResult(FolderImpl.class, (Serializable)Long.valueOf(folder.getPrimaryKey()), (Serializable)folder);
        this.finderCache.putResult(this._finderPathFetchByA_F, new Object[]{folder.getAccountId(), folder.getFullName()}, (Object)folder);
    }

    public void cacheResult(List<Folder> folders) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && folders.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Folder folder : folders) {
            if (this.entityCache.getResult(FolderImpl.class, (Serializable)Long.valueOf(folder.getPrimaryKey())) != null) continue;
            this.cacheResult(folder);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(FolderImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Folder folder) {
        this.entityCache.removeResult(FolderImpl.class, (BaseModel)folder);
    }

    public void clearCache(List<Folder> folders) {
        for (Folder folder : folders) {
            this.entityCache.removeResult(FolderImpl.class, (BaseModel)folder);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(FolderImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(FolderModelImpl folderModelImpl) {
        Object[] args = new Object[]{folderModelImpl.getAccountId(), folderModelImpl.getFullName()};
        this.finderCache.putResult(this._finderPathCountByA_F, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByA_F, args, (Object)folderModelImpl, false);
    }

    public Folder create(long folderId) {
        FolderImpl folder = new FolderImpl();
        folder.setNew(true);
        folder.setPrimaryKey(folderId);
        folder.setCompanyId(CompanyThreadLocal.getCompanyId());
        return folder;
    }

    public Folder remove(long folderId) throws NoSuchFolderException {
        return this.remove(Long.valueOf(folderId));
    }

    public Folder remove(Serializable primaryKey) throws NoSuchFolderException {
        Session session = null;
        try {
            session = this.openSession();
            Folder folder = (Folder)session.get(FolderImpl.class, primaryKey);
            if (folder == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchFolderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Folder folder2 = (Folder)this.remove((BaseModel)folder);
            return folder2;
        }
        catch (NoSuchFolderException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Folder removeImpl(Folder folder) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)folder)) {
                folder = (Folder)session.get(FolderImpl.class, folder.getPrimaryKeyObj());
            }
            if (folder != null) {
                session.delete((Object)folder);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (folder != null) {
            this.clearCache(folder);
        }
        return folder;
    }

    public Folder updateImpl(Folder folder) {
        boolean isNew = folder.isNew();
        if (!(folder instanceof FolderModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(folder.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)folder);
                throw new IllegalArgumentException("Implement ModelWrapper in folder proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Folder implementation " + folder.getClass());
        }
        FolderModelImpl folderModelImpl = (FolderModelImpl)folder;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && folder.getCreateDate() == null) {
            if (serviceContext == null) {
                folder.setCreateDate(date);
            } else {
                folder.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!folderModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                folder.setModifiedDate(date);
            } else {
                folder.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)folder);
            } else {
                folder = (Folder)session.merge((Object)folder);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(FolderImpl.class, (BaseModel)folderModelImpl, false, true);
        this.cacheUniqueFindersCache(folderModelImpl);
        if (isNew) {
            folder.setNew(false);
        }
        folder.resetOriginalValues();
        return folder;
    }

    public Folder findByPrimaryKey(Serializable primaryKey) throws NoSuchFolderException {
        Folder folder = (Folder)this.fetchByPrimaryKey(primaryKey);
        if (folder == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchFolderException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return folder;
    }

    public Folder findByPrimaryKey(long folderId) throws NoSuchFolderException {
        return this.findByPrimaryKey(Long.valueOf(folderId));
    }

    public Folder fetchByPrimaryKey(long folderId) {
        return (Folder)this.fetchByPrimaryKey(Long.valueOf(folderId));
    }

    public List<Folder> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Folder> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Folder> findAll(int start, int end, OrderByComparator<Folder> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Folder> findAll(int start, int end, OrderByComparator<Folder> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_FOLDER);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_FOLDER;
                sql = sql.concat(" ORDER BY folder.fullName ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Folder folder : this.findAll()) {
            this.remove((BaseModel)folder);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_FOLDER);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "folderId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_FOLDER;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return FolderModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new FolderModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)Folder.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByAccountId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByAccountId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"accountId"}, true);
        this._finderPathWithoutPaginationFindByAccountId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByAccountId", new String[]{Long.class.getName()}, new String[]{"accountId"}, true);
        this._finderPathCountByAccountId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAccountId", new String[]{Long.class.getName()}, new String[]{"accountId"}, false);
        this._finderPathFetchByA_F = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByA_F", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"accountId", "fullName"}, true);
        this._finderPathCountByA_F = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByA_F", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"accountId", "fullName"}, false);
        FolderUtil.setPersistence((FolderPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        FolderUtil.setPersistence(null);
        this.entityCache.removeCache(FolderImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.mail.reader.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class FolderModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private FolderModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            FolderModelImpl folderModelImpl = (FolderModelImpl)baseModel;
            long columnBitmask = folderModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return FolderModelArgumentsResolver._getValue(folderModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | FolderModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return FolderModelArgumentsResolver._getValue(folderModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(FolderModelImpl folderModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? folderModelImpl.getColumnOriginalValue(columnName) : folderModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= FolderModelImpl.getColumnBitmask("fullName");
        }
    }
}

