/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.persistence.impl;

import com.liferay.mail.reader.exception.NoSuchAccountException;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.model.AccountTable;
import com.liferay.mail.reader.model.impl.AccountImpl;
import com.liferay.mail.reader.model.impl.AccountModelImpl;
import com.liferay.mail.reader.service.persistence.AccountPersistence;
import com.liferay.mail.reader.service.persistence.AccountUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AccountPersistence.class})
public class AccountPersistenceImpl
extends BasePersistenceImpl<Account>
implements AccountPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AccountImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "account.userId = ?";
    private FinderPath _finderPathFetchByU_A;
    private FinderPath _finderPathCountByU_A;
    private static final String _FINDER_COLUMN_U_A_USERID_2 = "account.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_A_ADDRESS_2 = "account.address = ?";
    private static final String _FINDER_COLUMN_U_A_ADDRESS_3 = "(account.address IS NULL OR account.address = '')";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ACCOUNT = "SELECT account FROM Account account";
    private static final String _SQL_SELECT_ACCOUNT_WHERE = "SELECT account FROM Account account WHERE ";
    private static final String _SQL_COUNT_ACCOUNT = "SELECT COUNT(account) FROM Account account";
    private static final String _SQL_COUNT_ACCOUNT_WHERE = "SELECT COUNT(account) FROM Account account WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "account.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Account exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Account exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AccountPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"password"});
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<Account> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<Account> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<Account> findByUserId(long userId, int start, int end, OrderByComparator<Account> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<Account> findByUserId(long userId, int start, int end, OrderByComparator<Account> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Account account : list) {
                if (userId == account.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ACCOUNT_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY account.address ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Account findByUserId_First(long userId, OrderByComparator<Account> orderByComparator) throws NoSuchAccountException {
        Account account = this.fetchByUserId_First(userId, orderByComparator);
        if (account != null) {
            return account;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchAccountException(sb.toString());
    }

    public Account fetchByUserId_First(long userId, OrderByComparator<Account> orderByComparator) {
        List<Account> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Account findByUserId_Last(long userId, OrderByComparator<Account> orderByComparator) throws NoSuchAccountException {
        Account account = this.fetchByUserId_Last(userId, orderByComparator);
        if (account != null) {
            return account;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchAccountException(sb.toString());
    }

    public Account fetchByUserId_Last(long userId, OrderByComparator<Account> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<Account> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Account[] findByUserId_PrevAndNext(long accountId, long userId, OrderByComparator<Account> orderByComparator) throws NoSuchAccountException {
        Account account = this.findByPrimaryKey(accountId);
        Session session = null;
        try {
            session = this.openSession();
            Account[] array = new AccountImpl[]{this.getByUserId_PrevAndNext(session, account, userId, orderByComparator, true), account, this.getByUserId_PrevAndNext(session, account, userId, orderByComparator, false)};
            Account[] accountArray = array;
            return accountArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Account getByUserId_PrevAndNext(Session session, Account account, long userId, OrderByComparator<Account> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_ACCOUNT_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY account.address ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)account)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Account)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (Account account : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)account);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ACCOUNT_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Account findByU_A(long userId, String address) throws NoSuchAccountException {
        Account account = this.fetchByU_A(userId, address);
        if (account == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("userId=");
            sb.append(userId);
            sb.append(", address=");
            sb.append(address);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchAccountException(sb.toString());
        }
        return account;
    }

    public Account fetchByU_A(long userId, String address) {
        return this.fetchByU_A(userId, address, true);
    }

    public Account fetchByU_A(long userId, String address, boolean useFinderCache) {
        Account account;
        address = Objects.toString(address, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{userId, address};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByU_A, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Account && (userId != (account = (Account)result).getUserId() || !Objects.equals(address, account.getAddress()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_ACCOUNT_WHERE);
            sb.append(_FINDER_COLUMN_U_A_USERID_2);
            boolean bindAddress = false;
            if (address.isEmpty()) {
                sb.append(_FINDER_COLUMN_U_A_ADDRESS_3);
            } else {
                bindAddress = true;
                sb.append(_FINDER_COLUMN_U_A_ADDRESS_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindAddress) {
                    queryPos.add(address);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByU_A, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{userId, address};
                            }
                            _log.warn((Object)("AccountPersistenceImpl.fetchByU_A(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Account account2 = (Account)list.get(0);
                    result = account2;
                    this.cacheResult(account2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Account)result;
    }

    public Account removeByU_A(long userId, String address) throws NoSuchAccountException {
        Account account = this.findByU_A(userId, address);
        return (Account)this.remove((BaseModel)account);
    }

    public int countByU_A(long userId, String address) {
        address = Objects.toString(address, "");
        FinderPath finderPath = this._finderPathCountByU_A;
        Object[] finderArgs = new Object[]{userId, address};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_ACCOUNT_WHERE);
            sb.append(_FINDER_COLUMN_U_A_USERID_2);
            boolean bindAddress = false;
            if (address.isEmpty()) {
                sb.append(_FINDER_COLUMN_U_A_ADDRESS_3);
            } else {
                bindAddress = true;
                sb.append(_FINDER_COLUMN_U_A_ADDRESS_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindAddress) {
                    queryPos.add(address);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AccountPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("password", "password_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Account.class);
        this.setModelImplClass(AccountImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)AccountTable.INSTANCE);
    }

    public void cacheResult(Account account) {
        this.entityCache.putResult(AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey()), (Serializable)account);
        this.finderCache.putResult(this._finderPathFetchByU_A, new Object[]{account.getUserId(), account.getAddress()}, (Object)account);
    }

    public void cacheResult(List<Account> accounts) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && accounts.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Account account : accounts) {
            if (this.entityCache.getResult(AccountImpl.class, (Serializable)Long.valueOf(account.getPrimaryKey())) != null) continue;
            this.cacheResult(account);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AccountImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Account account) {
        this.entityCache.removeResult(AccountImpl.class, (BaseModel)account);
    }

    public void clearCache(List<Account> accounts) {
        for (Account account : accounts) {
            this.entityCache.removeResult(AccountImpl.class, (BaseModel)account);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(AccountImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(AccountModelImpl accountModelImpl) {
        Object[] args = new Object[]{accountModelImpl.getUserId(), accountModelImpl.getAddress()};
        this.finderCache.putResult(this._finderPathCountByU_A, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByU_A, args, (Object)accountModelImpl, false);
    }

    public Account create(long accountId) {
        AccountImpl account = new AccountImpl();
        account.setNew(true);
        account.setPrimaryKey(accountId);
        account.setCompanyId(CompanyThreadLocal.getCompanyId());
        return account;
    }

    public Account remove(long accountId) throws NoSuchAccountException {
        return this.remove(Long.valueOf(accountId));
    }

    public Account remove(Serializable primaryKey) throws NoSuchAccountException {
        Session session = null;
        try {
            session = this.openSession();
            Account account = (Account)session.get(AccountImpl.class, primaryKey);
            if (account == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Account account2 = (Account)this.remove((BaseModel)account);
            return account2;
        }
        catch (NoSuchAccountException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Account removeImpl(Account account) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)account)) {
                account = (Account)session.get(AccountImpl.class, account.getPrimaryKeyObj());
            }
            if (account != null) {
                session.delete((Object)account);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (account != null) {
            this.clearCache(account);
        }
        return account;
    }

    public Account updateImpl(Account account) {
        boolean isNew = account.isNew();
        if (!(account instanceof AccountModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(account.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)account);
                throw new IllegalArgumentException("Implement ModelWrapper in account proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Account implementation " + account.getClass());
        }
        AccountModelImpl accountModelImpl = (AccountModelImpl)account;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && account.getCreateDate() == null) {
            if (serviceContext == null) {
                account.setCreateDate(date);
            } else {
                account.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!accountModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                account.setModifiedDate(date);
            } else {
                account.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)account);
            } else {
                account = (Account)session.merge((Object)account);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(AccountImpl.class, (BaseModel)accountModelImpl, false, true);
        this.cacheUniqueFindersCache(accountModelImpl);
        if (isNew) {
            account.setNew(false);
        }
        account.resetOriginalValues();
        return account;
    }

    public Account findByPrimaryKey(Serializable primaryKey) throws NoSuchAccountException {
        Account account = (Account)this.fetchByPrimaryKey(primaryKey);
        if (account == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAccountException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return account;
    }

    public Account findByPrimaryKey(long accountId) throws NoSuchAccountException {
        return this.findByPrimaryKey(Long.valueOf(accountId));
    }

    public Account fetchByPrimaryKey(long accountId) {
        return (Account)this.fetchByPrimaryKey(Long.valueOf(accountId));
    }

    public List<Account> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Account> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Account> findAll(int start, int end, OrderByComparator<Account> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ACCOUNT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ACCOUNT;
                sql = sql.concat(" ORDER BY account.address ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Account account : this.findAll()) {
            this.remove((BaseModel)account);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ACCOUNT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "accountId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ACCOUNT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AccountModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new AccountModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)Account.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId"}, true);
        this._finderPathWithoutPaginationFindByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, true);
        this._finderPathCountByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, false);
        this._finderPathFetchByU_A = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByU_A", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"userId", "address"}, true);
        this._finderPathCountByU_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByU_A", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"userId", "address"}, false);
        AccountUtil.setPersistence((AccountPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        AccountUtil.setPersistence(null);
        this.entityCache.removeCache(AccountImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.mail.reader.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class AccountModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private AccountModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            AccountModelImpl accountModelImpl = (AccountModelImpl)baseModel;
            long columnBitmask = accountModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return AccountModelArgumentsResolver._getValue(accountModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | AccountModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return AccountModelArgumentsResolver._getValue(accountModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(AccountModelImpl accountModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? accountModelImpl.getColumnOriginalValue(columnName) : accountModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= AccountModelImpl.getColumnBitmask("address");
        }
    }
}

