/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.persistence.impl;

import com.liferay.mail.reader.exception.NoSuchAttachmentException;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.model.impl.AttachmentImpl;
import com.liferay.mail.reader.model.impl.AttachmentModelImpl;
import com.liferay.mail.reader.service.persistence.AttachmentPersistence;
import com.liferay.mail.reader.service.persistence.AttachmentUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={AttachmentPersistence.class})
public class AttachmentPersistenceImpl
extends BasePersistenceImpl<Attachment>
implements AttachmentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AttachmentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByMessageId;
    private FinderPath _finderPathWithoutPaginationFindByMessageId;
    private FinderPath _finderPathCountByMessageId;
    private static final String _FINDER_COLUMN_MESSAGEID_MESSAGEID_2 = "attachment.messageId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ATTACHMENT = "SELECT attachment FROM Attachment attachment";
    private static final String _SQL_SELECT_ATTACHMENT_WHERE = "SELECT attachment FROM Attachment attachment WHERE ";
    private static final String _SQL_COUNT_ATTACHMENT = "SELECT COUNT(attachment) FROM Attachment attachment";
    private static final String _SQL_COUNT_ATTACHMENT_WHERE = "SELECT COUNT(attachment) FROM Attachment attachment WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "attachment.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Attachment exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Attachment exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AttachmentPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"size"});

    public List<Attachment> findByMessageId(long messageId) {
        return this.findByMessageId(messageId, -1, -1, null);
    }

    public List<Attachment> findByMessageId(long messageId, int start, int end) {
        return this.findByMessageId(messageId, start, end, null);
    }

    public List<Attachment> findByMessageId(long messageId, int start, int end, OrderByComparator<Attachment> orderByComparator) {
        return this.findByMessageId(messageId, start, end, orderByComparator, true);
    }

    public List<Attachment> findByMessageId(long messageId, int start, int end, OrderByComparator<Attachment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByMessageId;
                finderArgs = new Object[]{messageId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByMessageId;
            finderArgs = new Object[]{messageId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Attachment attachment : list) {
                if (messageId == attachment.getMessageId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ATTACHMENT_WHERE);
            sb.append(_FINDER_COLUMN_MESSAGEID_MESSAGEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY attachment.attachmentId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(messageId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Attachment findByMessageId_First(long messageId, OrderByComparator<Attachment> orderByComparator) throws NoSuchAttachmentException {
        Attachment attachment = this.fetchByMessageId_First(messageId, orderByComparator);
        if (attachment != null) {
            return attachment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("messageId=");
        sb.append(messageId);
        sb.append("}");
        throw new NoSuchAttachmentException(sb.toString());
    }

    public Attachment fetchByMessageId_First(long messageId, OrderByComparator<Attachment> orderByComparator) {
        List<Attachment> list = this.findByMessageId(messageId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Attachment findByMessageId_Last(long messageId, OrderByComparator<Attachment> orderByComparator) throws NoSuchAttachmentException {
        Attachment attachment = this.fetchByMessageId_Last(messageId, orderByComparator);
        if (attachment != null) {
            return attachment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("messageId=");
        sb.append(messageId);
        sb.append("}");
        throw new NoSuchAttachmentException(sb.toString());
    }

    public Attachment fetchByMessageId_Last(long messageId, OrderByComparator<Attachment> orderByComparator) {
        int count = this.countByMessageId(messageId);
        if (count == 0) {
            return null;
        }
        List<Attachment> list = this.findByMessageId(messageId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Attachment[] findByMessageId_PrevAndNext(long attachmentId, long messageId, OrderByComparator<Attachment> orderByComparator) throws NoSuchAttachmentException {
        Attachment attachment = this.findByPrimaryKey(attachmentId);
        Session session = null;
        try {
            session = this.openSession();
            Attachment[] array = new AttachmentImpl[]{this.getByMessageId_PrevAndNext(session, attachment, messageId, orderByComparator, true), attachment, this.getByMessageId_PrevAndNext(session, attachment, messageId, orderByComparator, false)};
            Attachment[] attachmentArray = array;
            return attachmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Attachment getByMessageId_PrevAndNext(Session session, Attachment attachment, long messageId, OrderByComparator<Attachment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_ATTACHMENT_WHERE);
        sb.append(_FINDER_COLUMN_MESSAGEID_MESSAGEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY attachment.attachmentId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(messageId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)attachment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Attachment)list.get(1);
        }
        return null;
    }

    public void removeByMessageId(long messageId) {
        for (Attachment attachment : this.findByMessageId(messageId, -1, -1, null)) {
            this.remove((BaseModel)attachment);
        }
    }

    public int countByMessageId(long messageId) {
        FinderPath finderPath = this._finderPathCountByMessageId;
        Object[] finderArgs = new Object[]{messageId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ATTACHMENT_WHERE);
            sb.append(_FINDER_COLUMN_MESSAGEID_MESSAGEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(messageId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AttachmentPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(Attachment.class);
        this.setModelImplClass(AttachmentImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(Attachment attachment) {
        this.entityCache.putResult(this.entityCacheEnabled, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()), (Serializable)attachment);
        attachment.resetOriginalValues();
    }

    public void cacheResult(List<Attachment> attachments) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && attachments.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Attachment attachment : attachments) {
            if (this.entityCache.getResult(this.entityCacheEnabled, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey())) == null) {
                this.cacheResult(attachment);
                continue;
            }
            attachment.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AttachmentImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Attachment attachment) {
        this.entityCache.removeResult(this.entityCacheEnabled, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<Attachment> attachments) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Attachment attachment : attachments) {
            this.entityCache.removeResult(this.entityCacheEnabled, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()));
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, AttachmentImpl.class, primaryKey);
        }
    }

    public Attachment create(long attachmentId) {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setNew(true);
        attachment.setPrimaryKey(attachmentId);
        attachment.setCompanyId(CompanyThreadLocal.getCompanyId());
        return attachment;
    }

    public Attachment remove(long attachmentId) throws NoSuchAttachmentException {
        return this.remove(Long.valueOf(attachmentId));
    }

    public Attachment remove(Serializable primaryKey) throws NoSuchAttachmentException {
        Session session = null;
        try {
            session = this.openSession();
            Attachment attachment = (Attachment)session.get(AttachmentImpl.class, primaryKey);
            if (attachment == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAttachmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Attachment attachment2 = (Attachment)this.remove((BaseModel)attachment);
            return attachment2;
        }
        catch (NoSuchAttachmentException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Attachment removeImpl(Attachment attachment) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)attachment)) {
                attachment = (Attachment)session.get(AttachmentImpl.class, attachment.getPrimaryKeyObj());
            }
            if (attachment != null) {
                session.delete((Object)attachment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (attachment != null) {
            this.clearCache(attachment);
        }
        return attachment;
    }

    public Attachment updateImpl(Attachment attachment) {
        boolean isNew = attachment.isNew();
        if (!(attachment instanceof AttachmentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(attachment.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)attachment);
                throw new IllegalArgumentException("Implement ModelWrapper in attachment proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Attachment implementation " + attachment.getClass());
        }
        AttachmentModelImpl attachmentModelImpl = (AttachmentModelImpl)attachment;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)attachment);
                attachment.setNew(false);
            } else {
                attachment = (Attachment)session.merge((Object)attachment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{attachmentModelImpl.getMessageId()};
            this.finderCache.removeResult(this._finderPathCountByMessageId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByMessageId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((attachmentModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByMessageId.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{attachmentModelImpl.getOriginalMessageId()};
            this.finderCache.removeResult(this._finderPathCountByMessageId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByMessageId, args);
            args = new Object[]{attachmentModelImpl.getMessageId()};
            this.finderCache.removeResult(this._finderPathCountByMessageId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByMessageId, args);
        }
        this.entityCache.putResult(this.entityCacheEnabled, AttachmentImpl.class, (Serializable)Long.valueOf(attachment.getPrimaryKey()), (Serializable)attachment, false);
        attachment.resetOriginalValues();
        return attachment;
    }

    public Attachment findByPrimaryKey(Serializable primaryKey) throws NoSuchAttachmentException {
        Attachment attachment = (Attachment)this.fetchByPrimaryKey(primaryKey);
        if (attachment == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAttachmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return attachment;
    }

    public Attachment findByPrimaryKey(long attachmentId) throws NoSuchAttachmentException {
        return this.findByPrimaryKey(Long.valueOf(attachmentId));
    }

    public Attachment fetchByPrimaryKey(long attachmentId) {
        return (Attachment)this.fetchByPrimaryKey(Long.valueOf(attachmentId));
    }

    public List<Attachment> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Attachment> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Attachment> findAll(int start, int end, OrderByComparator<Attachment> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Attachment> findAll(int start, int end, OrderByComparator<Attachment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ATTACHMENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ATTACHMENT;
                sql = sql.concat(" ORDER BY attachment.attachmentId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Attachment attachment : this.findAll()) {
            this.remove((BaseModel)attachment);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ATTACHMENT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "attachmentId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ATTACHMENT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AttachmentModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        AttachmentModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        AttachmentModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByMessageId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByMessageId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByMessageId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, AttachmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByMessageId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByMessageId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMessageId", new String[]{Long.class.getName()});
        AttachmentUtil.setPersistence((AttachmentPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        AttachmentUtil.setPersistence(null);
        this.entityCache.removeCache(AttachmentImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.mail.reader.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.mail.reader.model.Attachment"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.mail.reader.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }
}

