/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.service.AccountLocalService;
import com.liferay.mail.reader.service.AccountLocalServiceUtil;
import com.liferay.mail.reader.service.persistence.AccountPersistence;
import com.liferay.mail.reader.service.persistence.AttachmentPersistence;
import com.liferay.mail.reader.service.persistence.FolderPersistence;
import com.liferay.mail.reader.service.persistence.MessagePersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class AccountLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AccountLocalService,
AopService,
IdentifiableOSGiService {
    protected AccountLocalService accountLocalService;
    @Reference
    protected AccountPersistence accountPersistence;
    @Reference
    protected AttachmentPersistence attachmentPersistence;
    @Reference
    protected FolderPersistence folderPersistence;
    @Reference
    protected MessagePersistence messagePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected ResourceLocalService resourceLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(AccountLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Account addAccount(Account account) {
        account.setNew(true);
        return (Account)this.accountPersistence.update((BaseModel)account);
    }

    @Transactional(enabled=false)
    public Account createAccount(long accountId) {
        return this.accountPersistence.create(accountId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Account deleteAccount(long accountId) throws PortalException {
        return this.accountPersistence.remove(accountId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Account deleteAccount(Account account) throws PortalException {
        return (Account)this.accountPersistence.remove((BaseModel)account);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Account.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.accountPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.accountPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.accountPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.accountPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.accountPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Account fetchAccount(long accountId) {
        return this.accountPersistence.fetchByPrimaryKey(accountId);
    }

    public Account getAccount(long accountId) throws PortalException {
        return this.accountPersistence.findByPrimaryKey(accountId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.accountLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Account.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("accountId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.accountLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Account.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("accountId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.accountLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Account.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("accountId");
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.accountLocalService.deleteAccount((Account)persistedModel);
    }

    public BasePersistence<Account> getBasePersistence() {
        return this.accountPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.accountPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<Account> getAccounts(int start, int end) {
        return this.accountPersistence.findAll(start, end);
    }

    public int getAccountsCount() {
        return this.accountPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Account updateAccount(Account account) {
        return (Account)this.accountPersistence.update((BaseModel)account);
    }

    @Deactivate
    protected void deactivate() {
        AccountLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{AccountLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.accountLocalService = (AccountLocalService)aopProxy;
        AccountLocalServiceUtil.setService((AccountLocalService)this.accountLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return AccountLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Account.class;
    }

    protected String getModelClassName() {
        return Account.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.accountPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

