/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.imap;

import com.liferay.mail.reader.attachment.AttachmentHandler;
import com.liferay.mail.reader.configuration.MailGroupServiceConfiguration;
import com.liferay.mail.reader.exception.MailException;
import com.liferay.mail.reader.exception.NoSuchMessageException;
import com.liferay.mail.reader.internal.imap.IMAPAttachmentHandler;
import com.liferay.mail.reader.internal.imap.IMAPConnection;
import com.liferay.mail.reader.internal.imap.IMAPMessageCountListener;
import com.liferay.mail.reader.internal.util.HtmlContentUtil;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.model.MailFile;
import com.liferay.mail.reader.service.AttachmentLocalServiceUtil;
import com.liferay.mail.reader.service.FolderLocalServiceUtil;
import com.liferay.mail.reader.service.MessageLocalServiceUtil;
import com.liferay.petra.mail.InternetAddressUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.UIDFolder;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.time.StopWatch;

public class IMAPAccessor {
    private static final Log _log = LogFactoryUtil.getLog(IMAPAccessor.class);
    private final Account _account;
    private final IMAPConnection _imapConnection;
    private MailGroupServiceConfiguration _mailGroupServiceConfiguration;
    private final String _password;
    private final User _user;

    public IMAPAccessor(User user, Account account, String password) {
        this._user = user;
        this._account = account;
        this._password = password;
        this._imapConnection = new IMAPConnection(account, password);
    }

    public String[] addFolder(String displayName) throws MailException {
        try {
            javax.mail.Folder jxFolder;
            String fullName = displayName;
            if (Validator.isNotNull((String)this._account.getFolderPrefix())) {
                Store store = this._imapConnection.getStore(true);
                javax.mail.Folder jxFolder2 = store.getDefaultFolder();
                fullName = this._account.getFolderPrefix() + jxFolder2.getSeparator() + displayName;
            }
            if ((jxFolder = this.getFolder(fullName)).exists()) {
                throw new MailException(5);
            }
            if (jxFolder.create(1)) {
                return new String[]{jxFolder.getFullName(), jxFolder.getName()};
            }
            throw new MailException(6);
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public void closeFolder(javax.mail.Folder jxFolder, boolean expunge) throws MailException {
        try {
            if (jxFolder == null || !jxFolder.isOpen()) {
                return;
            }
            if (expunge) {
                jxFolder.expunge();
            }
            jxFolder.close(expunge);
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public void deleteFolder(long folderId) throws PortalException {
        try {
            javax.mail.Folder jxFolder = this.getFolder(folderId);
            if (!jxFolder.exists()) {
                throw new MailException(8);
            }
            jxFolder.delete(true);
            if (jxFolder.exists()) {
                throw new MailException(7);
            }
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public void deleteMessages(long folderId, long[] messageIds) throws PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(folderId);
            jxFolder.addMessageCountListener((MessageCountListener)new IMAPMessageCountListener(this._user, this._account, this._password));
            List<Message> jxMessages = this.getMessages(jxFolder, messageIds, true);
            for (Message jxMessage : jxMessages) {
                jxMessage.setFlag(Flags.Flag.DELETED, true);
            }
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        finally {
            this.closeFolder(jxFolder, true);
        }
    }

    public AttachmentHandler getAttachment(long folderId, long messageId, String contentPath) throws IOException, PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(folderId);
            Message jxMessage = this.getMessage(jxFolder, messageId);
            if (jxMessage == null) {
                throw new MailException(16);
            }
            Part part = this.getPart((Part)jxMessage, contentPath);
            return new IMAPAttachmentHandler(part.getInputStream(), jxFolder);
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public List<javax.mail.Folder> getFolders() throws MailException {
        try {
            ArrayList<javax.mail.Folder> jxFolders = new ArrayList<javax.mail.Folder>();
            Store store = this._imapConnection.getStore(true);
            javax.mail.Folder jxFolder = store.getDefaultFolder();
            this.getFolders(jxFolders, jxFolder.list());
            return jxFolders;
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public long[] getMessageUIDs(javax.mail.Folder jxFolder, Message[] jxMessages) throws MailException {
        try {
            FetchProfile fetchProfile = new FetchProfile();
            fetchProfile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
            jxFolder.fetch(jxMessages, fetchProfile);
            long[] remoteMessageIds = new long[jxMessages.length];
            for (int i = 0; i < jxMessages.length; ++i) {
                Message jxMessage = jxMessages[i];
                remoteMessageIds[i] = this.getUID(jxFolder, jxMessage);
            }
            return remoteMessageIds;
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public long[] getMessageUIDs(long folderId, int pageNumber, int messagesPerPage) throws PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(folderId);
            int[] messageIndexes = this.getMessageIndexes(jxFolder.getMessageCount(), pageNumber, messagesPerPage);
            if (messageIndexes[0] == 0) {
                long[] lArray = new long[]{};
                return lArray;
            }
            Message[] jxMessages = jxFolder.getMessages(messageIndexes[0], messageIndexes[1]);
            long[] lArray = this.getMessageUIDs(jxFolder, jxMessages);
            return lArray;
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        finally {
            this.closeFolder(jxFolder, false);
        }
    }

    public boolean hasNewMessages(long folderId) throws PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(folderId);
            int messageCount = jxFolder.getMessageCount();
            Message jxMessage = this.getMessage(folderId, jxFolder, false);
            if (jxMessage == null) {
                if (messageCount <= 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            if (messageCount == jxMessage.getMessageNumber()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        finally {
            this.closeFolder(jxFolder, false);
        }
    }

    public void moveMessages(long sourceFolderId, long destinationFolderId, long[] messageIds, boolean deleteMissingMessages) throws PortalException {
        javax.mail.Folder sourceJxFolder = null;
        javax.mail.Folder destinationJxFolder = null;
        try {
            sourceJxFolder = this.openFolder(sourceFolderId);
            sourceJxFolder.addMessageCountListener((MessageCountListener)new IMAPMessageCountListener(this._user, this._account, this._password));
            destinationJxFolder = this.openFolder(destinationFolderId);
            destinationJxFolder.addMessageCountListener((MessageCountListener)new IMAPMessageCountListener(this._user, this._account, this._password));
            List<Message> jxMessages = this.getMessages(sourceJxFolder, messageIds, deleteMissingMessages);
            for (Message jxMessage : jxMessages) {
                destinationJxFolder.appendMessages(new Message[]{jxMessage});
                jxMessage.setFlag(Flags.Flag.DELETED, true);
            }
        }
        catch (MessagingException messagingException) {
            try {
                throw new MailException((Throwable)messagingException);
            }
            catch (Throwable throwable) {
                this.closeFolder(sourceJxFolder, true);
                this.closeFolder(destinationJxFolder, false);
                throw throwable;
            }
        }
        this.closeFolder(sourceJxFolder, true);
        this.closeFolder(destinationJxFolder, false);
    }

    public javax.mail.Folder openFolder(javax.mail.Folder jxFolder) throws MailException {
        try {
            if (jxFolder.isOpen()) {
                return jxFolder;
            }
            jxFolder.open(2);
            return jxFolder;
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public String[] renameFolder(long folderId, String newDisplayName) throws PortalException {
        try {
            javax.mail.Folder jxFolder = this.getFolder(folderId);
            String newFullName = "";
            if (Validator.isNotNull((String)this._account.getFolderPrefix())) {
                Store store = this._imapConnection.getStore(true);
                javax.mail.Folder defaultJxFolder = store.getDefaultFolder();
                newFullName = this._account.getFolderPrefix() + defaultJxFolder.getSeparator() + newDisplayName;
            }
            if (!jxFolder.exists()) {
                throw new MailException(8);
            }
            if (jxFolder.renameTo(this.getFolder(newFullName))) {
                return new String[]{jxFolder.getFullName(), jxFolder.getName()};
            }
            throw new MailException(11);
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
    }

    public void sendMessage(String personalName, String sender, Address[] to, Address[] cc, Address[] bcc, String subject, String body, List<MailFile> mailFiles) throws PortalException {
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(Session.class.getClassLoader());
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(this._account.getSentFolderId());
            Message jxMessage = this.createMessage(personalName, sender, to, cc, bcc, subject, body, mailFiles);
            Transport transport = this._imapConnection.getTransport();
            transport.sendMessage(jxMessage, jxMessage.getAllRecipients());
            transport.close();
            jxFolder.addMessageCountListener((MessageCountListener)new IMAPMessageCountListener(this._user, this._account, this._password));
            jxFolder.appendMessages(new Message[]{jxMessage});
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MailException((Throwable)unsupportedEncodingException);
        }
        finally {
            this.closeFolder(jxFolder, false);
            currentThread.setContextClassLoader(IMAPAccessor.class.getClassLoader());
        }
    }

    public void storeContents(long folderId, long[] remoteMessageIds) throws IOException, PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(folderId);
            Message[] jxMessages = this.getMessagesByUID(jxFolder, remoteMessageIds);
            FetchProfile fetchProfile = new FetchProfile();
            fetchProfile.add(UIDFolder.FetchProfileItem.CONTENT_INFO);
            fetchProfile.add(UIDFolder.FetchProfileItem.FLAGS);
            fetchProfile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
            jxFolder.fetch(jxMessages, fetchProfile);
            for (Message jxMessage : jxMessages) {
                String flags = this.getFlags(jxMessage);
                long remoteMessageId = this.getUID(jxFolder, jxMessage);
                com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)folderId, (long)remoteMessageId);
                StringBundler bodyPlainSB = new StringBundler();
                StringBundler bodyHtmlSB = new StringBundler();
                ArrayList<MailFile> mailFiles = new ArrayList<MailFile>();
                this.getParts(this._user.getUserId(), bodyPlainSB, bodyHtmlSB, "", (Part)jxMessage, mailFiles);
                if (bodyHtmlSB.length() == 0) {
                    if (bodyPlainSB.length() == 0) {
                        bodyHtmlSB.append("&nbsp;");
                    } else {
                        bodyHtmlSB = bodyPlainSB;
                    }
                }
                if (flags.indexOf(6) == -1) {
                    jxMessage.setFlag(Flags.Flag.SEEN, false);
                }
                AttachmentLocalServiceUtil.deleteAttachments((long)message.getCompanyId(), (long)message.getMessageId());
                for (MailFile mailFile : mailFiles) {
                    AttachmentLocalServiceUtil.addAttachment((long)this._user.getUserId(), (long)message.getMessageId(), (String)mailFile.getContentPath(), (String)mailFile.getFileName(), (long)mailFile.getSize(), (File)mailFile.getFile());
                }
                MessageLocalServiceUtil.updateContent((long)message.getMessageId(), (String)bodyHtmlSB.toString(), (String)flags);
            }
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        finally {
            this.closeFolder(jxFolder, false);
        }
    }

    public void storeEnvelopes(long folderId, boolean allMessages) throws PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            Folder folder = FolderLocalServiceUtil.fetchFolder((long)folderId);
            if (folder == null) {
                return;
            }
            jxFolder = this.openFolder(folderId);
            int messageCount = jxFolder.getMessageCount();
            FolderLocalServiceUtil.updateFolder((long)folderId, (String)folder.getFullName(), (String)folder.getDisplayName(), (int)messageCount);
            if (messageCount == 0) {
                this.closeFolder(jxFolder, false);
                return;
            }
            Message oldestJxMessage = this.getMessage(folderId, jxFolder, true);
            Message newestJxMessage = this.getMessage(folderId, jxFolder, false);
            Message[] jxMessages = new Message[]{};
            if (allMessages) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Downloading all messages from folder " + jxFolder.getFullName()));
                }
                jxMessages = jxFolder.getMessages();
            } else if (oldestJxMessage == null && newestJxMessage == null) {
                int startingMessageNumber;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Downloading messages from folder " + jxFolder.getFullName() + " for the first time"));
                }
                if ((startingMessageNumber = messageCount - this.getMessageSyncContact()) < 1) {
                    startingMessageNumber = 1;
                }
                jxMessages = jxFolder.getMessages(startingMessageNumber, messageCount);
            } else {
                int oldestMessageNumber = oldestJxMessage.getMessageNumber();
                int newestMessageNumber = newestJxMessage.getMessageNumber();
                if (newestMessageNumber != messageCount) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Downloading new messages from folder " + jxFolder.getFullName()));
                    }
                    jxMessages = jxFolder.getMessages(newestMessageNumber + 1, messageCount);
                } else if (oldestMessageNumber != 1) {
                    int startingMessageNumber;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Downloading old messages from folder " + jxFolder.getFullName()));
                    }
                    if ((startingMessageNumber = oldestMessageNumber - this.getMessageSyncContact()) < 1) {
                        startingMessageNumber = 1;
                    }
                    jxMessages = jxFolder.getMessages(startingMessageNumber, oldestMessageNumber - 1);
                }
            }
            this.storeEnvelopes(folderId, jxFolder, jxMessages);
            this.closeFolder(jxFolder, false);
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        finally {
            this.closeFolder(jxFolder, false);
        }
    }

    public void storeEnvelopes(long folderId, javax.mail.Folder jxFolder, Message[] jxMessages) throws PortalException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            FetchProfile fetchProfile = new FetchProfile();
            fetchProfile.add(UIDFolder.FetchProfileItem.ENVELOPE);
            fetchProfile.add(UIDFolder.FetchProfileItem.FLAGS);
            fetchProfile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
            jxFolder.fetch(jxMessages, fetchProfile);
            for (Message jxMessage : jxMessages) {
                String sender = InternetAddressUtil.toString((Address[])jxMessage.getFrom());
                String to = InternetAddressUtil.toString((Address[])jxMessage.getRecipients(Message.RecipientType.TO));
                String cc = InternetAddressUtil.toString((Address[])jxMessage.getRecipients(Message.RecipientType.CC));
                String bcc = InternetAddressUtil.toString((Address[])jxMessage.getRecipients(Message.RecipientType.BCC));
                Date sentDate = jxMessage.getSentDate();
                String subject = jxMessage.getSubject();
                String flags = this.getFlags(jxMessage);
                long remoteMessageId = this.getUID(jxFolder, jxMessage);
                String contentType = jxMessage.getContentType();
                try {
                    MessageLocalServiceUtil.getMessage((long)folderId, (long)remoteMessageId);
                }
                catch (NoSuchMessageException noSuchMessageException) {
                    MessageLocalServiceUtil.addMessage((long)this._user.getUserId(), (long)folderId, (String)sender, (String)to, (String)cc, (String)bcc, (Date)sentDate, (String)subject, (String)"", (String)flags, (long)remoteMessageId, (String)contentType);
                }
            }
            Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
            FolderLocalServiceUtil.updateFolder((long)folderId, (String)folder.getFullName(), (String)folder.getDisplayName(), (int)jxFolder.getMessageCount());
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        if (_log.isDebugEnabled()) {
            stopWatch.stop();
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Downloaded ", jxMessages.length, " messages from folder ", jxFolder.getFullName(), " completed in ", stopWatch.getTime(), " ms"}));
        }
    }

    public void storeEnvelopes(long folderId, long[] remoteMessageIds) throws PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(folderId);
            Message[] jxMessages = this.getMessagesByUID(jxFolder, remoteMessageIds);
            this.storeEnvelopes(folderId, jxFolder, jxMessages);
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        finally {
            this.closeFolder(jxFolder, false);
        }
    }

    public void updateFlags(long folderId, long[] messageIds, int flag, boolean value, boolean deleteMissingMessages) throws PortalException {
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this.openFolder(folderId);
            List<Message> jxMessages = this.getMessages(jxFolder, messageIds, deleteMissingMessages);
            for (Message jxMessage : jxMessages) {
                if (flag == 4) {
                    jxMessage.setFlag(Flags.Flag.FLAGGED, value);
                    continue;
                }
                if (flag == 6) {
                    jxMessage.setFlag(Flags.Flag.SEEN, value);
                    continue;
                }
                throw new MailException(15);
            }
        }
        catch (MessagingException messagingException) {
            throw new MailException((Throwable)messagingException);
        }
        finally {
            this.closeFolder(jxFolder, true);
        }
    }

    protected Message createMessage(String personalName, String sender, Address[] to, Address[] cc, Address[] bcc, String subject, String body, List<MailFile> mailFiles) throws MessagingException, UnsupportedEncodingException {
        MimeMessage jxMessage = new MimeMessage(this._imapConnection.getSession());
        jxMessage.setFrom((Address)new InternetAddress(sender, personalName));
        jxMessage.addRecipients(Message.RecipientType.TO, to);
        jxMessage.addRecipients(Message.RecipientType.CC, cc);
        jxMessage.addRecipients(Message.RecipientType.BCC, bcc);
        jxMessage.setSentDate(new Date());
        jxMessage.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)body, "text/html; charset=UTF-8");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        if (mailFiles != null) {
            for (MailFile mailFile : mailFiles) {
                File file = mailFile.getFile();
                if (!file.exists()) continue;
                FileDataSource dataSource = new FileDataSource(file);
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                attachmentBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                attachmentBodyPart.setFileName(mailFile.getFileName());
                multipart.addBodyPart((BodyPart)attachmentBodyPart);
            }
        }
        jxMessage.setContent((Multipart)multipart);
        return jxMessage;
    }

    protected String getFlags(Message jxMessage) throws MessagingException {
        StringBundler sb = new StringBundler(4);
        if (jxMessage.isSet(Flags.Flag.FLAGGED)) {
            sb.append(4);
            sb.append(",");
        }
        if (jxMessage.isSet(Flags.Flag.SEEN)) {
            sb.append(6);
            sb.append(",");
        }
        return sb.toString();
    }

    protected javax.mail.Folder getFolder(long folderId) throws MessagingException, PortalException {
        Store store = this._imapConnection.getStore(true);
        Folder folder = FolderLocalServiceUtil.getFolder((long)folderId);
        return store.getFolder(folder.getFullName());
    }

    protected javax.mail.Folder getFolder(String fullName) throws MailException, MessagingException {
        Store store = this._imapConnection.getStore(true);
        return store.getFolder(fullName);
    }

    protected void getFolders(List<javax.mail.Folder> allJxFolders, javax.mail.Folder[] jxFolders) {
        for (javax.mail.Folder jxFolder : jxFolders) {
            try {
                int folderType = jxFolder.getType();
                if ((folderType & 1) != 0) {
                    allJxFolders.add(jxFolder);
                }
                if ((folderType & 2) == 0) continue;
                this.getFolders(allJxFolders, jxFolder.list());
            }
            catch (MessagingException messagingException) {
                _log.error((Object)("Unable to get folder " + jxFolder.getFullName()), (Throwable)messagingException);
            }
        }
    }

    protected Message getMessage(javax.mail.Folder jxFolder, long remoteMessageId) throws MessagingException {
        UIDFolder uidFolder = (UIDFolder)jxFolder;
        return uidFolder.getMessageByUID(remoteMessageId);
    }

    protected Message getMessage(long folderId, javax.mail.Folder jxFolder, boolean oldest) throws MessagingException, PortalException {
        com.liferay.mail.reader.model.Message message = null;
        try {
            message = MessageLocalServiceUtil.getRemoteMessage((long)folderId, (boolean)oldest);
        }
        catch (NoSuchMessageException noSuchMessageException) {
            return null;
        }
        Message jxMessage = this.getMessage(jxFolder, message.getRemoteMessageId());
        if (jxMessage == null) {
            MessageLocalServiceUtil.deleteMessage((com.liferay.mail.reader.model.Message)message);
            return this.getMessage(folderId, jxFolder, oldest);
        }
        return jxMessage;
    }

    protected int[] getMessageIndexes(int messageCount, int page, int messagesPerPage) throws MailException {
        int pageCount = (int)Math.ceil((double)messageCount / (double)messagesPerPage);
        if (messageCount == 0) {
            return new int[]{0, 0};
        }
        if (page > pageCount) {
            throw new MailException(10);
        }
        int startIndex = messageCount - page * messagesPerPage + 1;
        int endIndex = messageCount - (page - 1) * messagesPerPage;
        if (startIndex < 1) {
            startIndex = 1;
        }
        if (endIndex < 1) {
            endIndex = 1;
        }
        return new int[]{startIndex, endIndex};
    }

    protected List<Message> getMessages(javax.mail.Folder jxFolder, long[] messageIds, boolean deleteMissingMessages) throws MessagingException, PortalException {
        long[] remoteMessageIds = new long[messageIds.length];
        for (int i = 0; i < messageIds.length; ++i) {
            com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageIds[i]);
            remoteMessageIds[i] = message.getRemoteMessageId();
        }
        ArrayList<Message> jxMessages = new ArrayList<Message>();
        Message[] jxMessagesArray = this.getMessagesByUID(jxFolder, remoteMessageIds);
        for (int i = 0; i < jxMessagesArray.length; ++i) {
            Message jxMessage = jxMessagesArray[i];
            if (jxMessage != null) {
                jxMessages.add(jxMessage);
                continue;
            }
            if (!deleteMissingMessages || remoteMessageIds[i] == 0L) continue;
            MessageLocalServiceUtil.deleteMessage((long)messageIds[i]);
        }
        return jxMessages;
    }

    protected Message[] getMessagesByUID(javax.mail.Folder jxFolder, long[] remoteMessageIds) throws MessagingException {
        UIDFolder uidFolder = (UIDFolder)jxFolder;
        return uidFolder.getMessagesByUID(remoteMessageIds);
    }

    protected int getMessageSyncContact() {
        if (this._mailGroupServiceConfiguration == null) {
            long companyId = PortalUtil.getDefaultCompanyId();
            try {
                this._mailGroupServiceConfiguration = (MailGroupServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(MailGroupServiceConfiguration.class, (long)companyId);
            }
            catch (ConfigurationException configurationException) {
                _log.error((Object)"Unable to get mail configuration", (Throwable)configurationException);
            }
        }
        return this._mailGroupServiceConfiguration.messagesSyncCount();
    }

    protected Part getPart(Part part, String contentPath) throws IOException, MessagingException {
        if (!(part.getContent() instanceof Multipart)) {
            return part;
        }
        int index = GetterUtil.getInteger((String)StringUtil.split((String)contentPath.substring(1), (String)".")[0]);
        Multipart multipart = (Multipart)part.getContent();
        for (int i = 0; i < multipart.getCount(); ++i) {
            if (i != index) continue;
            String indexValue = String.valueOf(index);
            String prefix = indexValue.concat(".");
            return this.getPart((Part)multipart.getBodyPart(i), contentPath.substring(prefix.length()));
        }
        return part;
    }

    protected void getParts(long userId, StringBundler bodyPlainSB, StringBundler bodyHtmlSB, String contentPath, Part part, List<MailFile> mailFiles) throws IOException, MessagingException {
        String fileName = part.getFileName();
        Object content = part.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart curPart = multipart.getBodyPart(i);
                this.getParts(userId, bodyPlainSB, bodyHtmlSB, contentPath.concat(".").concat(String.valueOf(i)), (Part)curPart, mailFiles);
            }
        } else if (Validator.isNull((String)fileName)) {
            String contentString = content.toString();
            String contentType = StringUtil.toLowerCase((String)part.getContentType());
            if (contentType.startsWith("text/plain")) {
                bodyPlainSB.append(contentString.replaceAll("\r\n", "<br />"));
            } else if (contentType.startsWith("text/html")) {
                bodyHtmlSB.append(HtmlContentUtil.getInlineHtml(contentString));
            }
        } else {
            MailFile mailFile = new MailFile(contentPath.concat(".").concat("-1"), fileName, (long)part.getSize());
            mailFiles.add(mailFile);
        }
    }

    protected InternetAddress[] getRecipients(long messageId) throws PortalException {
        try {
            com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageId);
            StringBundler sb = new StringBundler(6);
            sb.append(message.getTo());
            sb.append(",");
            sb.append(message.getCc());
            sb.append(",");
            sb.append(message.getBcc());
            sb.append(",");
            return InternetAddress.parse((String)sb.toString(), (boolean)true);
        }
        catch (AddressException addressException) {
            throw new MailException(14, (Throwable)addressException);
        }
    }

    protected InternetAddress[] getRecipients(long messageId, Message.RecipientType recipientType) throws PortalException {
        try {
            com.liferay.mail.reader.model.Message message = MessageLocalServiceUtil.getMessage((long)messageId);
            if (recipientType.equals(Message.RecipientType.TO)) {
                return InternetAddress.parse((String)message.getTo());
            }
            if (recipientType.equals(Message.RecipientType.CC)) {
                return InternetAddress.parse((String)message.getCc());
            }
            if (recipientType.equals(Message.RecipientType.BCC)) {
                return InternetAddress.parse((String)message.getBcc());
            }
            throw new IllegalArgumentException("Invalid recipient type " + recipientType);
        }
        catch (AddressException addressException) {
            throw new MailException(14, (Throwable)addressException);
        }
    }

    protected long getUID(javax.mail.Folder jxFolder, Message jxMessage) throws MessagingException {
        UIDFolder uidFolder = (UIDFolder)jxFolder;
        return uidFolder.getUID(jxMessage);
    }

    protected javax.mail.Folder openFolder(long folderId) throws MessagingException, PortalException {
        return this.openFolder(this.getFolder(folderId));
    }
}

