/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.impl;

import com.liferay.mail.reader.exception.NoSuchMessageException;
import com.liferay.mail.reader.internal.util.HtmlContentUtil;
import com.liferay.mail.reader.model.Attachment;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.model.Message;
import com.liferay.mail.reader.service.base.MessageLocalServiceBaseImpl;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;

public class MessageLocalServiceImpl
extends MessageLocalServiceBaseImpl {
    public Message addMessage(long userId, long folderId, String sender, String to, String cc, String bcc, Date sentDate, String subject, String body, String flags, long remoteMessageId, String contentType) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Folder folder = this.folderPersistence.findByPrimaryKey(folderId);
        Date now = new Date();
        long messageId = this.counterLocalService.increment();
        Message message = this.messagePersistence.create(messageId);
        subject = this.encode(subject);
        message.setCompanyId(user.getCompanyId());
        message.setUserId(user.getUserId());
        message.setUserName(user.getFullName());
        message.setCreateDate(now);
        message.setModifiedDate(now);
        message.setAccountId(folder.getAccountId());
        message.setFolderId(folderId);
        message.setSender(sender);
        message.setTo(to);
        message.setCc(cc);
        message.setBcc(bcc);
        message.setSentDate(sentDate);
        message.setSubject(subject);
        message.setPreview(this.getPreview(body));
        message.setBody(this.getBody(body));
        message.setFlags(flags);
        message.setSize(this.getSize(messageId, body));
        message.setRemoteMessageId(remoteMessageId);
        message.setContentType(this.removeBoundaryMarker(contentType));
        message = (Message)this.messagePersistence.update((BaseModel)message);
        Indexer indexer = IndexerRegistryUtil.getIndexer(Message.class);
        indexer.reindex((Object)message);
        return message;
    }

    @Override
    public Message deleteMessage(long messageId) throws PortalException {
        Message message = this.messagePersistence.findByPrimaryKey(messageId);
        return this.deleteMessage(message);
    }

    @Override
    public Message deleteMessage(Message message) throws PortalException {
        this.messagePersistence.remove((BaseModel)message);
        this.attachmentLocalService.deleteAttachments(message.getCompanyId(), message.getMessageId());
        Indexer indexer = IndexerRegistryUtil.getIndexer(Message.class);
        indexer.delete((Object)message);
        return message;
    }

    public void deleteMessages(long folderId) throws PortalException {
        List messages = this.messagePersistence.findByFolderId(folderId);
        for (Message message : messages) {
            this.deleteMessage(message);
        }
    }

    public int getAccountUnreadMessagesCount(long accountId) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Message.class, (ClassLoader)this.getClassLoader());
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"accountId", (Object)accountId));
        dynamicQuery.add(RestrictionsFactoryUtil.not((Criterion)RestrictionsFactoryUtil.like((String)"flags", (Object)"%6,%")));
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public List<Message> getCompanyMessages(long companyId, int start, int end) {
        return this.messagePersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyMessagesCount(long companyId) {
        return this.messagePersistence.countByCompanyId(companyId);
    }

    public List<Message> getFolderMessages(long folderId) {
        return this.messagePersistence.findByFolderId(folderId);
    }

    public int getFolderMessagesCount(long folderId) {
        return this.messagePersistence.countByFolderId(folderId);
    }

    public int getFolderUnreadMessagesCount(long folderId) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Message.class, (ClassLoader)this.getClassLoader());
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"folderId", (Object)folderId));
        dynamicQuery.add(RestrictionsFactoryUtil.not((Criterion)RestrictionsFactoryUtil.like((String)"flags", (Object)"%6,%")));
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public Message getMessage(long folderId, long remoteMessageId) throws PortalException {
        return this.messagePersistence.findByF_R(folderId, remoteMessageId);
    }

    public Message getRemoteMessage(long folderId, boolean oldest) throws PortalException {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Message.class, (ClassLoader)this.getClassLoader());
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"folderId", (Object)folderId));
        dynamicQuery.add(RestrictionsFactoryUtil.gt((String)"remoteMessageId", (Object)0L));
        if (oldest) {
            dynamicQuery.addOrder(OrderFactoryUtil.asc((String)"remoteMessageId"));
        } else {
            dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"remoteMessageId"));
        }
        List messages = this.messagePersistence.findWithDynamicQuery(dynamicQuery, 0, 1);
        if (messages.isEmpty()) {
            throw new NoSuchMessageException();
        }
        return (Message)messages.get(0);
    }

    public int populateMessages(List<Message> messages, long folderId, String keywords, int pageNumber, int messagesPerPage, String orderByField, String orderByType) {
        DynamicQuery countDynamicQuery = DynamicQueryFactoryUtil.forClass(Message.class, (ClassLoader)this.getClassLoader());
        countDynamicQuery.add(RestrictionsFactoryUtil.eq((String)"folderId", (Object)folderId));
        DynamicQuery messageDynamicQuery = DynamicQueryFactoryUtil.forClass(Message.class, (ClassLoader)this.getClassLoader());
        messageDynamicQuery.add(RestrictionsFactoryUtil.eq((String)"folderId", (Object)folderId));
        if (Validator.isNotNull((String)keywords)) {
            String value = "%" + keywords + "%";
            Disjunction disjunction = RestrictionsFactoryUtil.disjunction();
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"subject", (Object)value));
            disjunction.add(RestrictionsFactoryUtil.ilike((String)"body", (Object)value));
            countDynamicQuery.add((Criterion)disjunction);
            messageDynamicQuery.add((Criterion)disjunction);
        }
        if (orderByType.equals("desc")) {
            messageDynamicQuery.addOrder(OrderFactoryUtil.desc((String)orderByField));
        } else {
            messageDynamicQuery.addOrder(OrderFactoryUtil.asc((String)orderByField));
        }
        int start = messagesPerPage * (pageNumber - 1);
        int end = messagesPerPage * pageNumber;
        messages.addAll(this.messagePersistence.findWithDynamicQuery(messageDynamicQuery, start, end));
        return (int)this.dynamicQueryCount(countDynamicQuery);
    }

    public Message updateContent(long messageId, String body, String flags) throws PortalException {
        Message message = this.messagePersistence.findByPrimaryKey(messageId);
        message.setModifiedDate(new Date());
        message.setPreview(this.getPreview(body));
        message.setBody(this.getBody(body));
        message.setFlags(flags);
        message.setSize(this.getSize(messageId, body));
        return (Message)this.messagePersistence.update((BaseModel)message);
    }

    public Message updateFlag(long messageId, int flag, boolean value) throws PortalException {
        String flagString = String.valueOf(flag);
        Message message = this.messagePersistence.findByPrimaryKey(messageId);
        String flags = message.getFlags();
        if (value && !StringUtil.contains((String)flags, (String)flagString)) {
            message.setFlags(StringUtil.add((String)flags, (String)flagString));
        } else if (!value && StringUtil.contains((String)flags, (String)flagString)) {
            message.setFlags(StringUtil.removeFromList((String)flags, (String)flagString));
        }
        return (Message)this.messagePersistence.update((BaseModel)message);
    }

    public Message updateMessage(long messageId, long folderId, String sender, String to, String cc, String bcc, Date sentDate, String subject, String body, String flags, long remoteMessageId) throws PortalException {
        Message message = this.messagePersistence.findByPrimaryKey(messageId);
        message.setModifiedDate(new Date());
        message.setFolderId(folderId);
        message.setSender(sender);
        message.setTo(to);
        message.setCc(cc);
        message.setBcc(bcc);
        message.setSentDate(sentDate);
        message.setSubject(subject);
        message.setPreview(this.getPreview(body));
        message.setBody(this.getBody(body));
        message.setFlags(flags);
        message.setSize(this.getSize(messageId, body));
        message.setRemoteMessageId(remoteMessageId);
        message = (Message)this.messagePersistence.update((BaseModel)message);
        Indexer indexer = IndexerRegistryUtil.getIndexer(Message.class);
        indexer.reindex((Object)message);
        return message;
    }

    protected String encode(String subject) {
        byte[] bytes = subject.getBytes(StandardCharsets.ISO_8859_1);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    protected String getBody(String body) {
        if (Validator.isNull((String)body)) {
            return body;
        }
        return HtmlContentUtil.getInlineHtml(body);
    }

    protected String getPreview(String body) {
        if (Validator.isNull((String)body)) {
            return body;
        }
        return StringUtil.shorten((String)HtmlContentUtil.getPlainText(body), (int)50);
    }

    protected long getSize(long messageId, String body) {
        if (Validator.isNull((String)body)) {
            return 0L;
        }
        byte[] bytes = body.getBytes();
        long size = bytes.length;
        List attachments = this.attachmentPersistence.findByMessageId(messageId);
        for (Attachment attachment : attachments) {
            size += attachment.getSize();
        }
        return size;
    }

    protected String removeBoundaryMarker(String contentType) {
        int i = contentType.indexOf(59);
        if (i == -1) {
            return contentType;
        }
        return contentType.substring(0, i);
    }
}

