/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.lcs.messaging.analytics;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.liferay.lcs.messaging.Message;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(defaultImpl=AnalyticsEventsMessage.class, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="messageFormat", use=JsonTypeInfo.Id.NAME, visible=true)
public class AnalyticsEventsMessage
extends Message {
    private String _analyticsKey;
    private String _clientIP;
    private Map<String, String> _context = Collections.emptyMap();
    private List<Event> _events = Collections.emptyList();
    private String _userId;

    @NotNull
    public String getAnalyticsKey() {
        return this._analyticsKey;
    }

    public String getClientIP() {
        return this._clientIP;
    }

    public Map<String, String> getContext() {
        return this._context;
    }

    @Size(min=1)
    @Valid
    public List<Event> getEvents() {
        return this._events;
    }

    public String getUserId() {
        return this._userId;
    }

    public void setAnalyticsKey(String analyticsKey) {
        this._analyticsKey = analyticsKey;
    }

    public void setClientIP(String clientIP) {
        this._clientIP = clientIP;
    }

    public void setContext(Map<String, String> context) {
        this._context = context;
    }

    public void setEvents(List<Event> events) {
        this._events = events;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Event {
        private String _applicationId;
        @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", shape=JsonFormat.Shape.STRING, timezone="UTC")
        private Date _eventDate;
        private String _eventId;
        private Map<String, String> _properties = Collections.emptyMap();

        @NotNull
        public String getApplicationId() {
            return this._applicationId;
        }

        public Date getEventDate() {
            return this._eventDate;
        }

        @NotNull
        public String getEventId() {
            return this._eventId;
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this._properties);
        }

        public void setApplicationId(String applicationId) {
            this._applicationId = applicationId;
        }

        public void setEventDate(Date eventDate) {
            this._eventDate = eventDate;
        }

        public void setEventId(String eventId) {
            this._eventId = eventId;
        }

        public void setProperties(Map<String, String> properties) {
            this._properties = properties;
        }
    }
}

