/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.service;

import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.fragment.cache.FragmentEntryLinkCache;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.layout.friendly.url.LayoutFriendlyURLEntryHelper;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.layout.util.structure.DeletedLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.RoleModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.PortletPreferencesLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CopyLayoutThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.sites.kernel.util.Sites;
import jakarta.portlet.PortletPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class LayoutLocalServiceWrapper
extends com.liferay.portal.kernel.service.LayoutLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceWrapper.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private CommentManager _commentManager;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private FragmentEntryLinkCache _fragmentEntryLinkCache;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutFriendlyURLEntryHelper _layoutFriendlyURLEntryHelper;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;
    @Reference
    private PortletPreferencesLocalService _portletPreferencesLocalService;
    @Reference
    private PortletRegistry _portletRegistry;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private Sites _sites;
    @Reference
    private UserLocalService _userLocalService;

    public Layout copyLayoutContent(Layout sourceLayout, Layout targetLayout) throws Exception {
        List segmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(sourceLayout.getGroupId(), sourceLayout.getPlid());
        long[] sourceSegmentsExperiencesIds = TransformUtil.transformToLongArray((Collection)segmentsExperiences, SegmentsExperienceModel::getSegmentsExperienceId);
        long[] targetSegmentsExperiencesIds = TransformUtil.transformToLongArray((Collection)segmentsExperiences, segmentsExperience -> {
            SegmentsExperience targetSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(targetLayout.getGroupId(), segmentsExperience.getSegmentsExperienceKey(), targetLayout.getPlid());
            if (targetSegmentsExperience == null) {
                return null;
            }
            return targetSegmentsExperience.getSegmentsExperienceId();
        });
        return this._copyLayoutContent(false, sourceLayout, sourceSegmentsExperiencesIds, targetLayout, targetSegmentsExperiencesIds);
    }

    public Layout copyLayoutContent(long sourceSegmentsExperienceId, Layout sourceLayout, long targetSegmentsExperienceId, Layout targetLayout) throws Exception {
        return this._copyLayoutContent(true, sourceLayout, new long[]{sourceSegmentsExperienceId}, targetLayout, new long[]{targetSegmentsExperienceId});
    }

    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        Layout layout = super.fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
        if (layout != null) {
            return layout;
        }
        return this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        try {
            return super.getFriendlyURLLayout(groupId, privateLayout, friendlyURL);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            Layout layout = this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
            if (layout != null) {
                return layout;
            }
            throw noSuchLayoutException;
        }
    }

    public void updateLayoutContent(String data, Layout layout, long segmentsExperienceId) throws Exception {
        boolean copyLayout = CopyLayoutThreadLocal.isCopyLayout();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)layout.getCtCollectionId());){
            CopyLayoutThreadLocal.setCopyLayout((boolean)true);
            User user = this._getUser(0L, 0L, currentServiceContext);
            if (currentServiceContext == null || currentServiceContext.getUserId() != user.getUserId()) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(layout.getCompanyId());
                serviceContext.setUserId(user.getUserId());
                ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
            }
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                this._updateLayoutPageTemplateStructureData(data, layout, segmentsExperienceId, layout, segmentsExperienceId, user);
                return null;
            });
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug(throwable);
            }
            throw new Exception(throwable);
        }
        finally {
            CopyLayoutThreadLocal.setCopyLayout((boolean)copyLayout);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    private void _cleanDeletedSegmentsExperiences(Map<Long, Long> segmentsExperienceIdsMap, Layout targetLayout) throws Exception {
        List targetSegmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(targetLayout.getGroupId(), targetLayout.getPlid());
        for (SegmentsExperience targetSegmentsExperience : targetSegmentsExperiences) {
            if (segmentsExperienceIdsMap.containsValue(targetSegmentsExperience.getSegmentsExperienceId())) continue;
            this._segmentsExperienceLocalService.deleteSegmentsExperience(targetSegmentsExperience.getSegmentsExperienceId());
        }
    }

    private void _copyAssetCategoryIdsAndAssetTagNames(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        this.updateAsset(userId, targetLayout, this._assetCategoryLocalService.getCategoryIds(Layout.class.getName(), sourceLayout.getPlid()), this._assetTagLocalService.getTagNames(Layout.class.getName(), sourceLayout.getPlid()));
    }

    private void _copyLayoutClassedModelUsages(Layout sourceLayout, Layout targetLayout) {
        List sourceLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(sourceLayout.getPlid());
        this._deleteLayoutClassedModelUsages(sourceLayoutLayoutClassedModelUsages, targetLayout);
        List targetLayoutLayoutClassedModelUsages = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid());
        for (LayoutClassedModelUsage sourceLayoutLayoutClassedModelUsage : sourceLayoutLayoutClassedModelUsages) {
            if (this._hasLayoutClassedModelUsage(targetLayoutLayoutClassedModelUsages, sourceLayoutLayoutClassedModelUsage)) continue;
            String containerKey = sourceLayoutLayoutClassedModelUsage.getContainerKey();
            long containerType = sourceLayoutLayoutClassedModelUsage.getContainerType();
            if (containerType == this._portal.getClassNameId(FragmentEntryLink.class.getName())) {
                long originalFragmentEntryLinkId = GetterUtil.getLong((String)sourceLayoutLayoutClassedModelUsage.getContainerKey());
                FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(originalFragmentEntryLinkId);
                if (originalFragmentEntryLink != null && originalFragmentEntryLink.isDeleted()) continue;
                FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(sourceLayout.getGroupId(), originalFragmentEntryLinkId, targetLayout.getPlid());
                if (fragmentEntryLink != null) {
                    containerKey = String.valueOf(fragmentEntryLink.getFragmentEntryLinkId());
                    LayoutClassedModelUsage layoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(targetLayout.getGroupId(), sourceLayoutLayoutClassedModelUsage.getClassNameId(), sourceLayoutLayoutClassedModelUsage.getClassPK(), sourceLayoutLayoutClassedModelUsage.getClassedModelExternalReferenceCode(), containerKey, sourceLayoutLayoutClassedModelUsage.getContainerType(), targetLayout.getPlid());
                    if (layoutClassedModelUsage != null) continue;
                }
            }
            this._layoutClassedModelUsageLocalService.addLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsage.getGroupId(), sourceLayoutLayoutClassedModelUsage.getClassNameId(), sourceLayoutLayoutClassedModelUsage.getClassPK(), sourceLayoutLayoutClassedModelUsage.getClassedModelExternalReferenceCode(), containerKey, sourceLayoutLayoutClassedModelUsage.getContainerType(), targetLayout.getPlid(), ServiceContextThreadLocal.getServiceContext());
        }
    }

    private Layout _copyLayoutContent(boolean copySegmentsExperience, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds) throws Exception {
        boolean copyLayout = CopyLayoutThreadLocal.isCopyLayout();
        ServiceContext currentServiceContext = ServiceContextThreadLocal.getServiceContext();
        long ctCollectionId = sourceLayout.getCtCollectionId();
        if (ctCollectionId == 0L) {
            ctCollectionId = targetLayout.getCtCollectionId();
        }
        try {
            Layout layout;
            block14: {
                SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
                try {
                    CopyLayoutThreadLocal.setCopyLayout((boolean)true);
                    User user = this._getUser(sourceLayout.getUserId(), targetLayout.getUserId(), currentServiceContext);
                    if (currentServiceContext == null || currentServiceContext.getUserId() != user.getUserId()) {
                        ServiceContext serviceContext = new ServiceContext();
                        serviceContext.setCompanyId(targetLayout.getCompanyId());
                        serviceContext.setUserId(user.getUserId());
                        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
                    }
                    layout = (Layout)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)new CopyLayoutCallable(copySegmentsExperience, sourceLayout, sourceSegmentsExperiencesIds, targetLayout, targetSegmentsExperiencesIds, user));
                    if (safeCloseable == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (safeCloseable != null) {
                            try {
                                safeCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (_log.isDebugEnabled()) {
                            _log.debug(throwable3);
                        }
                        throw new Exception(throwable3);
                    }
                }
                safeCloseable.close();
            }
            return layout;
        }
        finally {
            CopyLayoutThreadLocal.setCopyLayout((boolean)copyLayout);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)currentServiceContext);
        }
    }

    private void _copyLayoutPageTemplateStructure(long[] sourceSegmentsExperiencesIds, Layout sourceLayout, long[] targetSegmentsExperiencesIds, Layout targetLayout, User user) throws Exception {
        Map<Long, FragmentEntryLink> fragmentEntryLinksMap = this._getFragmentEntryLinksMap(sourceLayout, sourceSegmentsExperiencesIds, targetLayout);
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        Set<Long> targetFragmentEntryLinkIds = this._getTargetFragmentEntryLinkIds(targetSegmentsExperiencesIds, targetLayout);
        LayoutPageTemplateStructure targetLayoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(targetLayout.getGroupId(), targetLayout.getPlid());
        if (targetLayoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(user.getUserId(), targetLayout.getGroupId(), targetLayout.getPlid(), this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(targetLayout.getPlid()), null, ServiceContextThreadLocal.getServiceContext());
        }
        Map<Long, Long> segmentsExperienceIdsMap = this._getSegmentsExperienceIds(sourceSegmentsExperiencesIds, targetLayout, user);
        this._cleanDeletedSegmentsExperiences(segmentsExperienceIdsMap, targetLayout);
        for (Map.Entry<Long, Long> entry : segmentsExperienceIdsMap.entrySet()) {
            String data = layoutPageTemplateStructure.getData(entry.getKey().longValue());
            if (Validator.isNull((String)data)) {
                this._segmentsExperienceLocalService.deleteSegmentsExperience(entry.getKey().longValue());
                continue;
            }
            JSONObject dataJSONObject = this._processDataJSONObject(LayoutStructure.of((String)data), sourceLayout, targetLayout, fragmentEntryLinksMap, targetFragmentEntryLinkIds, entry.getValue(), user);
            this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(targetLayout.getGroupId(), targetLayout.getPlid(), entry.getValue().longValue(), dataJSONObject.toString());
            SegmentsExperience targetSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(entry.getValue().longValue());
            SegmentsExperience sourceSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(entry.getKey().longValue());
            targetSegmentsExperience.setPriority(sourceSegmentsExperience.getPriority());
            this._segmentsExperienceLocalService.updateSegmentsExperience(targetSegmentsExperience);
        }
        this._fragmentEntryLinkLocalService.deleteFragmentEntryLinks(ArrayUtil.toLongArray(targetFragmentEntryLinkIds));
    }

    private void _copyLayoutPageTemplateStructureFromSegmentsExperience(Layout sourceLayout, long sourceSegmentsExperienceId, Layout targetLayout, long targetSegmentsExperienceId, User user) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(sourceLayout.getGroupId(), sourceLayout.getPlid());
        String data = layoutPageTemplateStructure.getData(sourceSegmentsExperienceId);
        if (Validator.isNull((String)data)) {
            return;
        }
        this._updateLayoutPageTemplateStructureData(data, sourceLayout, sourceSegmentsExperienceId, targetLayout, targetSegmentsExperienceId, user);
    }

    private void _copyLayoutSEOEntry(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
        if (sourceLayout.isDraftLayout() || targetLayout.isDraftLayout()) {
            return;
        }
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getLayoutId());
        if (layoutSEOEntry == null) {
            LayoutSEOEntry targetLayoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            if (targetLayoutSEOEntry != null) {
                this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId());
            }
            return;
        }
        this._layoutSEOEntryLocalService.copyLayoutSEOEntry(userId, targetLayout.getGroupId(), targetLayout.isPrivateLayout(), targetLayout.getLayoutId(), layoutSEOEntry, ServiceContextThreadLocal.getServiceContext());
    }

    private void _copyPortletPermissions(List<String> portletIds, Layout sourceLayout, Layout targetLayout) throws Exception {
        for (String portletId : portletIds) {
            String resourceName = PortletIdCodec.decodePortletName((String)portletId);
            String sourceResourcePrimKey = PortletPermissionUtil.getPrimaryKey((long)sourceLayout.getPlid(), (String)portletId);
            Map sourceRoleIdsToActionIds = this._resourcePermissionLocalService.getAvailableResourcePermissionActionIds(targetLayout.getCompanyId(), resourceName, 4, sourceResourcePrimKey, (Collection)ResourceActionsUtil.getPortletResourceActions((String)resourceName));
            if (sourceRoleIdsToActionIds.isEmpty()) continue;
            List roleIds = TransformUtil.transform((Collection)ListUtil.filter((List)this._roleLocalService.getGroupRelatedRoles(targetLayout.getGroupId()), role -> !Objects.equals("Administrator", role.getName())), RoleModel::getRoleId);
            HashMap<Long, String[]> targetRoleIdsToActionIds = new HashMap<Long, String[]>();
            for (Map.Entry entry : sourceRoleIdsToActionIds.entrySet()) {
                Long roleId = (Long)entry.getKey();
                if (!roleIds.contains(roleId)) continue;
                Set sourceActionIds = (Set)entry.getValue();
                targetRoleIdsToActionIds.put(roleId, sourceActionIds.toArray(new String[0]));
            }
            this._resourcePermissionLocalService.setResourcePermissions(targetLayout.getCompanyId(), resourceName, 4, PortletPermissionUtil.getPrimaryKey((long)targetLayout.getPlid(), (String)portletId), targetRoleIdsToActionIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _copyPortletPreferences(List<String> portletIds, Layout sourceLayout, Layout targetLayout) {
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled((boolean)false);
            for (String portletId : portletIds) {
                PortletPreferencesIds portletPreferencesIds;
                PortletPreferences jxPortletPreferences;
                Portlet portlet = this._portletLocalService.getPortletById(portletId);
                if (portlet == null || portlet.isUndeployedPortlet() || (jxPortletPreferences = this._portletPreferencesLocalService.fetchPreferences(portletPreferencesIds = this._portletPreferencesFactory.getPortletPreferencesIds(sourceLayout.getCompanyId(), sourceLayout.getGroupId(), 0L, sourceLayout.getPlid(), portletId))) == null) continue;
                com.liferay.portal.kernel.model.PortletPreferences targetPortletPreferences = this._portletPreferencesLocalService.fetchPortletPreferences(portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), portletId);
                if (targetPortletPreferences != null) {
                    this._portletPreferencesLocalService.updatePreferences(targetPortletPreferences.getOwnerId(), targetPortletPreferences.getOwnerType(), targetPortletPreferences.getPlid(), targetPortletPreferences.getPortletId(), jxPortletPreferences);
                    continue;
                }
                this._portletPreferencesLocalService.addPortletPreferences(targetLayout.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), targetLayout.getPlid(), portletId, portlet, PortletPreferencesFactoryUtil.toXML((PortletPreferences)jxPortletPreferences));
            }
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled((boolean)stagingAdvicesThreadLocalEnabled);
        }
    }

    private void _deleteLayoutClassedModelUsages(List<LayoutClassedModelUsage> sourceLayoutLayoutClassedModelUsages, Layout targetLayout) {
        for (LayoutClassedModelUsage targetLayoutClassedModelUsage : this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesByPlid(targetLayout.getPlid())) {
            if (this._hasLayoutClassedModelUsage(sourceLayoutLayoutClassedModelUsages, targetLayoutClassedModelUsage)) continue;
            this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(targetLayoutClassedModelUsage);
        }
    }

    private List<String> _deletePortletPermissions(Layout layout, long[] segmentsExperiencesIds) throws Exception {
        List<String> portletIds = this._getLayoutPortletIds(layout, segmentsExperiencesIds);
        for (String portletId : portletIds) {
            this._resourcePermissionLocalService.deleteResourcePermissions(layout.getCompanyId(), PortletIdCodec.decodePortletName((String)portletId), 4, PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)portletId));
        }
        return portletIds;
    }

    private Layout _fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, this._layoutFriendlyURLEntryHelper.getClassNameId(privateLayout), friendlyURL);
        if (friendlyURLEntry == null) {
            return null;
        }
        Layout layout = this.fetchLayout(friendlyURLEntry.getClassPK());
        if (layout != null) {
            return layout;
        }
        return null;
    }

    private Map<Long, FragmentEntryLink> _getFragmentEntryLinksMap(Layout sourceLayout, long[] segmentsExperiencesIds, Layout targetLayout) {
        HashMap<Long, FragmentEntryLink> fragmentEntryLinksMap = new HashMap<Long, FragmentEntryLink>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(sourceLayout.getGroupId(), segmentsExperiencesIds, sourceLayout.getPlid())) {
            if (fragmentEntryLink.isDeleted()) {
                FragmentEntryLink targetLayoutFragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(targetLayout.getGroupId(), fragmentEntryLink.getFragmentEntryLinkId(), targetLayout.getPlid());
                if (targetLayoutFragmentEntryLink == null) continue;
                this._fragmentEntryLinkLocalService.deleteFragmentEntryLink(targetLayoutFragmentEntryLink);
                continue;
            }
            fragmentEntryLinksMap.put(fragmentEntryLink.getFragmentEntryLinkId(), fragmentEntryLink);
        }
        return fragmentEntryLinksMap;
    }

    private List<String> _getLayoutPortletIds(Layout layout, long[] segmentsExperiencesIds) {
        ArrayList<String> layoutPortletIds = new ArrayList<String>();
        for (FragmentEntryLink fragmentEntryLink : this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(layout.getGroupId(), segmentsExperiencesIds, layout.getPlid(), false)) {
            layoutPortletIds.addAll(this._portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink));
        }
        return layoutPortletIds;
    }

    private Map<Long, Long> _getSegmentsExperienceIds(long[] segmentsExperiencesIds, Layout targetLayout, User user) {
        HashMap<Long, Long> segmentsExperienceIdsMap = new HashMap<Long, Long>();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        int minPriority = Integer.MIN_VALUE;
        for (long segmentsExperienceId : segmentsExperiencesIds) {
            SegmentsExperience sourceSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
            SegmentsExperience targetSegmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(targetLayout.getGroupId(), sourceSegmentsExperience.getSegmentsExperienceKey(), targetLayout.getPlid());
            if (targetSegmentsExperience != null) {
                segmentsExperienceIdsMap.put(sourceSegmentsExperience.getSegmentsExperienceId(), targetSegmentsExperience.getSegmentsExperienceId());
                if (Objects.equals("DEFAULT", targetSegmentsExperience.getSegmentsExperienceKey())) continue;
                targetSegmentsExperience.setPriority(minPriority++);
                this._segmentsExperienceLocalService.updateSegmentsExperience(targetSegmentsExperience);
                continue;
            }
            SegmentsExperience newSegmentsExperience = (SegmentsExperience)sourceSegmentsExperience.clone();
            newSegmentsExperience.setUuid(serviceContext.getUuid());
            newSegmentsExperience.setExternalReferenceCode(null);
            newSegmentsExperience.setSegmentsExperienceId(this._counterLocalService.increment());
            newSegmentsExperience.setUserId(user.getUserId());
            newSegmentsExperience.setUserName(user.getFullName());
            newSegmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
            newSegmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
            newSegmentsExperience.setSegmentsExperienceKey(sourceSegmentsExperience.getSegmentsExperienceKey());
            newSegmentsExperience.setPlid(targetLayout.getPlid());
            newSegmentsExperience.setPriority(minPriority++);
            this._segmentsExperienceLocalService.addSegmentsExperience(newSegmentsExperience);
            segmentsExperienceIdsMap.put(sourceSegmentsExperience.getSegmentsExperienceId(), newSegmentsExperience.getSegmentsExperienceId());
        }
        return segmentsExperienceIdsMap;
    }

    private Set<Long> _getTargetFragmentEntryLinkIds(long[] segmentsExperiencesIds, Layout targetLayout) {
        return new HashSet<Long>(ListUtil.toList((List)this._fragmentEntryLinkLocalService.getFragmentEntryLinksBySegmentsExperienceId(targetLayout.getGroupId(), segmentsExperiencesIds, targetLayout.getPlid()), (Accessor)FragmentEntryLink.FRAGMENT_ENTRY_LINK_ID_ACCESSOR));
    }

    private String _getTypeSettings(Layout sourceLayout, Layout targetLayout) {
        if (!sourceLayout.isDraftLayout() && !targetLayout.isDraftLayout()) {
            return sourceLayout.getTypeSettings();
        }
        if (targetLayout.isDraftLayout()) {
            UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).build();
            return UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).setProperty("published", Boolean.FALSE.toString()).setProperty("query-string", typeSettingsUnicodeProperties.getProperty("query-string")).setProperty("target", typeSettingsUnicodeProperties.getProperty("target")).setProperty("targetType", typeSettingsUnicodeProperties.getProperty("targetType")).buildString();
        }
        UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(targetLayout.getTypeSettings()).build();
        return UnicodePropertiesBuilder.create((boolean)true).fastLoad(sourceLayout.getTypeSettings()).setProperty("query-string", typeSettingsUnicodeProperties.getProperty("query-string")).setProperty("target", typeSettingsUnicodeProperties.getProperty("target")).setProperty("targetType", typeSettingsUnicodeProperties.getProperty("targetType")).buildString();
    }

    private User _getUser(long sourceLayoutUserId, long targetLayoutUserId, ServiceContext serviceContext) throws PortalException {
        User user = null;
        if (targetLayoutUserId > 0L) {
            user = this._userLocalService.fetchUser(targetLayoutUserId);
        }
        if (user != null) {
            return user;
        }
        if (sourceLayoutUserId > 0L) {
            user = this._userLocalService.fetchUser(sourceLayoutUserId);
        }
        if (user != null) {
            return user;
        }
        if (serviceContext != null) {
            user = serviceContext.fetchUser();
        }
        if (user != null) {
            return user;
        }
        return GuestOrUserUtil.getGuestOrUser();
    }

    private boolean _hasLayoutClassedModelUsage(List<LayoutClassedModelUsage> layoutClassedModelUsages, LayoutClassedModelUsage targetLayoutClassedModelUsage) {
        for (LayoutClassedModelUsage layoutClassedModelUsage : layoutClassedModelUsages) {
            if (layoutClassedModelUsage.getClassNameId() != targetLayoutClassedModelUsage.getClassNameId() || layoutClassedModelUsage.getClassPK() != targetLayoutClassedModelUsage.getClassPK() || !Objects.equals(layoutClassedModelUsage.getContainerKey(), targetLayoutClassedModelUsage.getContainerKey()) || layoutClassedModelUsage.getContainerType() != targetLayoutClassedModelUsage.getContainerType()) continue;
            return true;
        }
        return false;
    }

    private JSONObject _processDataJSONObject(LayoutStructure layoutStructure, Layout sourceLayout, Layout targetLayout, Map<Long, FragmentEntryLink> sourceFragmentEntryLinksMap, Set<Long> targetFragmentEntryLinkIds, long targetSegmentsExperienceId, User user) throws Exception {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem;
            FragmentEntryLink sourceLayoutfragmentEntryLink;
            if (!(layoutStructureItem instanceof FragmentStyledLayoutStructureItem) || (sourceLayoutfragmentEntryLink = sourceFragmentEntryLinksMap.get((fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructureItem).getFragmentEntryLinkId())) == null) continue;
            FragmentEntryLink newFragmentEntryLink = null;
            FragmentEntryLink targetLayoutFragmentEntryLink = this._fragmentEntryLinkLocalService.getFragmentEntryLink(targetLayout.getGroupId(), fragmentStyledLayoutStructureItem.getFragmentEntryLinkId(), targetLayout.getPlid());
            if (targetLayoutFragmentEntryLink != null) {
                targetLayoutFragmentEntryLink.setUserId(user.getUserId());
                targetLayoutFragmentEntryLink.setUserName(user.getFullName());
                targetLayoutFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
                if (sourceLayout.getClassPK() == targetLayout.getPlid()) {
                    targetLayoutFragmentEntryLink.setOriginalFragmentEntryLinkId(sourceLayoutfragmentEntryLink.getFragmentEntryLinkId());
                } else {
                    targetLayoutFragmentEntryLink.setOriginalFragmentEntryLinkId(0L);
                }
                targetLayoutFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
                targetLayoutFragmentEntryLink.setClassPK(targetLayout.getPlid());
                targetLayoutFragmentEntryLink.setPlid(targetLayout.getPlid());
                targetLayoutFragmentEntryLink.setCss(sourceLayoutfragmentEntryLink.getCss());
                targetLayoutFragmentEntryLink.setHtml(sourceLayoutfragmentEntryLink.getHtml());
                targetLayoutFragmentEntryLink.setJs(sourceLayoutfragmentEntryLink.getJs());
                targetLayoutFragmentEntryLink.setConfiguration(sourceLayoutfragmentEntryLink.getConfiguration());
                targetLayoutFragmentEntryLink.setEditableValues(sourceLayoutfragmentEntryLink.getEditableValues());
                targetLayoutFragmentEntryLink.setLastPropagationDate(sourceLayoutfragmentEntryLink.getLastPropagationDate());
                newFragmentEntryLink = this._fragmentEntryLinkLocalService.updateFragmentEntryLink(targetLayoutFragmentEntryLink);
                this._commentManager.deleteDiscussion(FragmentEntryLink.class.getName(), newFragmentEntryLink.getFragmentEntryLinkId());
                this._fragmentEntryLinkCache.removeFragmentEntryLinkCache(newFragmentEntryLink);
            } else {
                newFragmentEntryLink = (FragmentEntryLink)sourceLayoutfragmentEntryLink.clone();
                newFragmentEntryLink.setUuid(serviceContext.getUuid());
                newFragmentEntryLink.setExternalReferenceCode(null);
                newFragmentEntryLink.setFragmentEntryLinkId(this._counterLocalService.increment());
                newFragmentEntryLink.setUserId(user.getUserId());
                newFragmentEntryLink.setUserName(user.getFullName());
                newFragmentEntryLink.setCreateDate(serviceContext.getCreateDate(new Date()));
                newFragmentEntryLink.setModifiedDate(serviceContext.getModifiedDate(new Date()));
                if (sourceLayout.getClassPK() == targetLayout.getPlid()) {
                    newFragmentEntryLink.setOriginalFragmentEntryLinkId(sourceLayoutfragmentEntryLink.getFragmentEntryLinkId());
                } else {
                    newFragmentEntryLink.setOriginalFragmentEntryLinkId(0L);
                }
                newFragmentEntryLink.setSegmentsExperienceId(targetSegmentsExperienceId);
                newFragmentEntryLink.setClassNameId(this._portal.getClassNameId(Layout.class));
                newFragmentEntryLink.setClassPK(targetLayout.getPlid());
                newFragmentEntryLink.setPlid(targetLayout.getPlid());
                newFragmentEntryLink.setLastPropagationDate(sourceLayoutfragmentEntryLink.getLastPropagationDate());
                newFragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(newFragmentEntryLink);
            }
            fragmentStyledLayoutStructureItem.setFragmentEntryLinkId(newFragmentEntryLink.getFragmentEntryLinkId());
            targetFragmentEntryLinkIds.remove(newFragmentEntryLink.getFragmentEntryLinkId());
            this._commentManager.copyDiscussion(user.getUserId(), targetLayout.getGroupId(), FragmentEntryLink.class.getName(), sourceLayoutfragmentEntryLink.getFragmentEntryLinkId(), newFragmentEntryLink.getFragmentEntryLinkId(), className -> serviceContext);
        }
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : layoutStructure.getDeletedLayoutStructureItems()) {
            layoutStructure.deleteLayoutStructureItem(deletedLayoutStructureItem.getItemId());
        }
        return layoutStructure.toJSONObject();
    }

    private void _updateLayoutPageTemplateStructureData(String data, Layout sourceLayout, long sourceSegmentsExperienceId, Layout targetLayout, long targetSegmentsExperienceId, User user) throws Exception {
        Set<Long> targetFragmentEntryLinkIds = this._getTargetFragmentEntryLinkIds(new long[]{targetSegmentsExperienceId}, targetLayout);
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (DeletedLayoutStructureItem deletedLayoutStructureItem : layoutStructure.getDeletedLayoutStructureItems()) {
            layoutStructure.deleteLayoutStructureItem(deletedLayoutStructureItem.getItemId());
        }
        JSONObject dataJSONObject = this._processDataJSONObject(layoutStructure, sourceLayout, targetLayout, this._getFragmentEntryLinksMap(sourceLayout, new long[]{sourceSegmentsExperienceId}, targetLayout), targetFragmentEntryLinkIds, targetSegmentsExperienceId, user);
        this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructureData(targetLayout.getGroupId(), targetLayout.getPlid(), targetSegmentsExperienceId, dataJSONObject.toString());
        this._fragmentEntryLinkLocalService.deleteFragmentEntryLinks(ArrayUtil.toLongArray(targetFragmentEntryLinkIds));
    }

    private class CopyLayoutCallable
    implements Callable<Layout> {
        private final boolean _copySegmentsExperience;
        private final Layout _sourceLayout;
        private final long[] _sourceSegmentsExperiencesIds;
        private final Layout _targetLayout;
        private final long[] _targetSegmentsExperiencesIds;
        private final User _user;

        @Override
        public Layout call() throws Exception {
            if (Objects.equals(this._sourceLayout.getType(), "portlet")) {
                LayoutLocalServiceWrapper.this._sites.copyPortletPermissions(this._targetLayout, this._sourceLayout);
            } else {
                List<String> oldPortletIds = LayoutLocalServiceWrapper.this._deletePortletPermissions(this._targetLayout, this._targetSegmentsExperiencesIds);
                if (this._copySegmentsExperience) {
                    LayoutLocalServiceWrapper.this._copyLayoutPageTemplateStructureFromSegmentsExperience(this._sourceLayout, this._sourceSegmentsExperiencesIds[0], this._targetLayout, this._targetSegmentsExperiencesIds[0], this._user);
                } else {
                    LayoutLocalServiceWrapper.this._copyLayoutPageTemplateStructure(this._sourceSegmentsExperiencesIds, this._sourceLayout, this._targetSegmentsExperiencesIds, this._targetLayout, this._user);
                }
                List<String> portletIds = LayoutLocalServiceWrapper.this._getLayoutPortletIds(this._sourceLayout, this._sourceSegmentsExperiencesIds);
                LayoutLocalServiceWrapper.this._copyPortletPermissions(portletIds, this._sourceLayout, this._targetLayout);
                LayoutLocalServiceWrapper.this._copyPortletPreferences(portletIds, this._sourceLayout, this._targetLayout);
                this._deleteOrphanPortletPreferences(portletIds, oldPortletIds);
            }
            LayoutLocalServiceWrapper.this._copyLayoutClassedModelUsages(this._sourceLayout, this._targetLayout);
            LayoutLocalServiceWrapper.this._sites.copyExpandoBridgeAttributes(this._sourceLayout, this._targetLayout);
            LayoutLocalServiceWrapper.this._sites.copyPortletSetups(this._sourceLayout, this._targetLayout);
            LayoutLocalServiceWrapper.this._copyAssetCategoryIdsAndAssetTagNames(this._sourceLayout, this._targetLayout, this._user.getUserId());
            LayoutLocalServiceWrapper.this._copyLayoutSEOEntry(this._sourceLayout, this._targetLayout, this._user.getUserId());
            this._copyLayoutClientExtensions(this._sourceLayout, this._targetLayout, this._user.getUserId());
            Image image = LayoutLocalServiceWrapper.this._imageLocalService.getImage(this._sourceLayout.getIconImageId());
            byte[] imageBytes = null;
            if (image != null) {
                imageBytes = image.getTextObj();
            }
            return LayoutLocalServiceWrapper.this.updateLayout(this._targetLayout.getGroupId(), this._targetLayout.isPrivateLayout(), this._targetLayout.getLayoutId(), LayoutLocalServiceWrapper.this._getTypeSettings(this._sourceLayout, this._targetLayout), imageBytes, this._sourceLayout.getThemeId(), this._sourceLayout.getColorSchemeId(), this._sourceLayout.getStyleBookEntryId(), this._sourceLayout.getCss(), this._sourceLayout.getFaviconFileEntryId(), this._sourceLayout.getMasterLayoutPlid());
        }

        private CopyLayoutCallable(boolean copySegmentsExperience, Layout sourceLayout, long[] sourceSegmentsExperiencesIds, Layout targetLayout, long[] targetSegmentsExperiencesIds, User user) {
            this._copySegmentsExperience = copySegmentsExperience;
            this._sourceLayout = sourceLayout;
            this._sourceSegmentsExperiencesIds = sourceSegmentsExperiencesIds;
            this._targetLayout = targetLayout;
            this._targetSegmentsExperiencesIds = targetSegmentsExperiencesIds;
            this._user = user;
        }

        private void _copyLayoutClientExtensions(Layout sourceLayout, Layout targetLayout, long userId) throws Exception {
            long classNameId = LayoutLocalServiceWrapper.this._portal.getClassNameId(Layout.class);
            LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.deleteClientExtensionEntryRels(classNameId, targetLayout.getPlid());
            List clientExtensionEntryRels = LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(classNameId, sourceLayout.getPlid());
            for (ClientExtensionEntryRel clientExtensionEntryRel : clientExtensionEntryRels) {
                LayoutLocalServiceWrapper.this._clientExtensionEntryRelLocalService.addClientExtensionEntryRel(userId, targetLayout.getGroupId(), classNameId, targetLayout.getPlid(), clientExtensionEntryRel.getCETExternalReferenceCode(), clientExtensionEntryRel.getType(), clientExtensionEntryRel.getTypeSettings(), ServiceContextThreadLocal.getServiceContext());
            }
        }

        private void _deleteOrphanPortletPreferences(List<String> portletIds, List<String> oldPortletIds) {
            Object[] deletedPortletIds = (String[])TransformUtil.transformToArray(oldPortletIds, portletId -> {
                if (portletIds.contains(portletId)) {
                    return null;
                }
                return portletId;
            }, String.class);
            if (ArrayUtil.isEmpty((Object[])deletedPortletIds)) {
                return;
            }
            LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutLocalServiceWrapper.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(this._targetLayout.getPlid());
            if (layoutPageTemplateEntry == null || !Objects.equals(layoutPageTemplateEntry.getType(), 3)) {
                return;
            }
            for (Object portletId2 : deletedPortletIds) {
                for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : LayoutLocalServiceWrapper.this._portletPreferencesLocalService.getPortletPreferencesByPortletId((String)portletId2)) {
                    try {
                        LayoutLocalServiceWrapper.this._portletPreferencesLocalService.deletePortletPreferences(portletPreferences);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
    }
}

