/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.service;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class LayoutServiceWrapper
extends com.liferay.portal.kernel.service.LayoutServiceWrapper {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public Layout publishLayout(long plid) throws Exception {
        Layout layout = this._layoutLocalService.getLayout(plid);
        if (!layout.isTypeContent()) {
            throw new UnsupportedOperationException("Only layouts of type content can be published");
        }
        LayoutPermissionUtil.check((PermissionChecker)GuestOrUserUtil.getPermissionChecker(), (Layout)layout, (String)"UPDATE");
        Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layout.getPlid());
        LayoutPermissionUtil.check((PermissionChecker)GuestOrUserUtil.getPermissionChecker(), (Layout)draftLayout, (String)"UPDATE");
        layout = this._layoutLocalService.copyLayoutContent(draftLayout, layout);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        this._layoutLocalService.updateStatus(draftLayout.getUserId(), draftLayout.getPlid(), 0, serviceContext);
        return this._layoutLocalService.updateStatus(layout.getUserId(), layout.getPlid(), 0, serviceContext);
    }
}

