/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.layout.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.layout.model.LayoutLocalization;
import com.liferay.layout.model.LayoutLocalizationModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LayoutLocalization service. Represents a row in the &quot;LayoutLocalization&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutLocalizationModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutLocalizationImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutLocalizationImpl
 * @generated
 */
public class LayoutLocalizationModelImpl
	extends BaseModelImpl<LayoutLocalization>
	implements LayoutLocalizationModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout localization model instance should use the <code>LayoutLocalization</code> interface instead.
	 */
	public static final String TABLE_NAME = "LayoutLocalization";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"layoutLocalizationId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"content", Types.CLOB}, {"languageId", Types.VARCHAR},
		{"plid", Types.BIGINT}, {"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutLocalizationId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("content", Types.CLOB);
		TABLE_COLUMNS_MAP.put("languageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LayoutLocalization (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,layoutLocalizationId LONG not null,groupId LONG,companyId LONG,createDate DATE null,modifiedDate DATE null,content TEXT null,languageId VARCHAR(75) null,plid LONG,lastPublishDate DATE null,primary key (layoutLocalizationId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table LayoutLocalization";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layoutLocalization.layoutLocalizationId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LayoutLocalization.layoutLocalizationId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LANGUAGEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PLID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTLOCALIZATIONID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public LayoutLocalizationModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _layoutLocalizationId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLayoutLocalizationId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _layoutLocalizationId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LayoutLocalization.class;
	}

	@Override
	public String getModelClassName() {
		return LayoutLocalization.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LayoutLocalization, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LayoutLocalization, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutLocalization, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((LayoutLocalization)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LayoutLocalization, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LayoutLocalization, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LayoutLocalization)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LayoutLocalization, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LayoutLocalization, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<LayoutLocalization, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<LayoutLocalization, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<LayoutLocalization, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", LayoutLocalization::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", LayoutLocalization::getCtCollectionId);
			attributeGetterFunctions.put("uuid", LayoutLocalization::getUuid);
			attributeGetterFunctions.put(
				"layoutLocalizationId",
				LayoutLocalization::getLayoutLocalizationId);
			attributeGetterFunctions.put(
				"groupId", LayoutLocalization::getGroupId);
			attributeGetterFunctions.put(
				"companyId", LayoutLocalization::getCompanyId);
			attributeGetterFunctions.put(
				"createDate", LayoutLocalization::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", LayoutLocalization::getModifiedDate);
			attributeGetterFunctions.put(
				"content", LayoutLocalization::getContent);
			attributeGetterFunctions.put(
				"languageId", LayoutLocalization::getLanguageId);
			attributeGetterFunctions.put("plid", LayoutLocalization::getPlid);
			attributeGetterFunctions.put(
				"lastPublishDate", LayoutLocalization::getLastPublishDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<LayoutLocalization, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<LayoutLocalization, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<LayoutLocalization, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<LayoutLocalization, Long>)
					LayoutLocalization::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<LayoutLocalization, Long>)
					LayoutLocalization::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<LayoutLocalization, String>)
					LayoutLocalization::setUuid);
			attributeSetterBiConsumers.put(
				"layoutLocalizationId",
				(BiConsumer<LayoutLocalization, Long>)
					LayoutLocalization::setLayoutLocalizationId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<LayoutLocalization, Long>)
					LayoutLocalization::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<LayoutLocalization, Long>)
					LayoutLocalization::setCompanyId);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<LayoutLocalization, Date>)
					LayoutLocalization::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<LayoutLocalization, Date>)
					LayoutLocalization::setModifiedDate);
			attributeSetterBiConsumers.put(
				"content",
				(BiConsumer<LayoutLocalization, String>)
					LayoutLocalization::setContent);
			attributeSetterBiConsumers.put(
				"languageId",
				(BiConsumer<LayoutLocalization, String>)
					LayoutLocalization::setLanguageId);
			attributeSetterBiConsumers.put(
				"plid",
				(BiConsumer<LayoutLocalization, Long>)
					LayoutLocalization::setPlid);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<LayoutLocalization, Date>)
					LayoutLocalization::setLastPublishDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getLayoutLocalizationId() {
		return _layoutLocalizationId;
	}

	@Override
	public void setLayoutLocalizationId(long layoutLocalizationId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutLocalizationId = layoutLocalizationId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getContent() {
		if (_content == null) {
			return "";
		}
		else {
			return _content;
		}
	}

	@Override
	public void setContent(String content) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_content = content;
	}

	@Override
	public String getLanguageId() {
		if (_languageId == null) {
			return "";
		}
		else {
			return _languageId;
		}
	}

	@Override
	public void setLanguageId(String languageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_languageId = languageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalLanguageId() {
		return getColumnOriginalValue("languageId");
	}

	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPlid() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("plid"));
	}

	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(LayoutLocalization.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LayoutLocalization.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public LayoutLocalization toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LayoutLocalization>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutLocalizationImpl layoutLocalizationImpl =
			new LayoutLocalizationImpl();

		layoutLocalizationImpl.setMvccVersion(getMvccVersion());
		layoutLocalizationImpl.setCtCollectionId(getCtCollectionId());
		layoutLocalizationImpl.setUuid(getUuid());
		layoutLocalizationImpl.setLayoutLocalizationId(
			getLayoutLocalizationId());
		layoutLocalizationImpl.setGroupId(getGroupId());
		layoutLocalizationImpl.setCompanyId(getCompanyId());
		layoutLocalizationImpl.setCreateDate(getCreateDate());
		layoutLocalizationImpl.setModifiedDate(getModifiedDate());
		layoutLocalizationImpl.setContent(getContent());
		layoutLocalizationImpl.setLanguageId(getLanguageId());
		layoutLocalizationImpl.setPlid(getPlid());
		layoutLocalizationImpl.setLastPublishDate(getLastPublishDate());

		layoutLocalizationImpl.resetOriginalValues();

		return layoutLocalizationImpl;
	}

	@Override
	public LayoutLocalization cloneWithOriginalValues() {
		LayoutLocalizationImpl layoutLocalizationImpl =
			new LayoutLocalizationImpl();

		layoutLocalizationImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		layoutLocalizationImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		layoutLocalizationImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		layoutLocalizationImpl.setLayoutLocalizationId(
			this.<Long>getColumnOriginalValue("layoutLocalizationId"));
		layoutLocalizationImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		layoutLocalizationImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		layoutLocalizationImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		layoutLocalizationImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		layoutLocalizationImpl.setContent(
			this.<String>getColumnOriginalValue("content"));
		layoutLocalizationImpl.setLanguageId(
			this.<String>getColumnOriginalValue("languageId"));
		layoutLocalizationImpl.setPlid(
			this.<Long>getColumnOriginalValue("plid"));
		layoutLocalizationImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return layoutLocalizationImpl;
	}

	@Override
	public int compareTo(LayoutLocalization layoutLocalization) {
		long primaryKey = layoutLocalization.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LayoutLocalization)) {
			return false;
		}

		LayoutLocalization layoutLocalization = (LayoutLocalization)object;

		long primaryKey = layoutLocalization.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LayoutLocalization> toCacheModel() {
		LayoutLocalizationCacheModel layoutLocalizationCacheModel =
			new LayoutLocalizationCacheModel();

		layoutLocalizationCacheModel.mvccVersion = getMvccVersion();

		layoutLocalizationCacheModel.ctCollectionId = getCtCollectionId();

		layoutLocalizationCacheModel.uuid = getUuid();

		String uuid = layoutLocalizationCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			layoutLocalizationCacheModel.uuid = null;
		}

		layoutLocalizationCacheModel.layoutLocalizationId =
			getLayoutLocalizationId();

		layoutLocalizationCacheModel.groupId = getGroupId();

		layoutLocalizationCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			layoutLocalizationCacheModel.createDate = createDate.getTime();
		}
		else {
			layoutLocalizationCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			layoutLocalizationCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			layoutLocalizationCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		layoutLocalizationCacheModel.content = getContent();

		String content = layoutLocalizationCacheModel.content;

		if ((content != null) && (content.length() == 0)) {
			layoutLocalizationCacheModel.content = null;
		}

		layoutLocalizationCacheModel.languageId = getLanguageId();

		String languageId = layoutLocalizationCacheModel.languageId;

		if ((languageId != null) && (languageId.length() == 0)) {
			layoutLocalizationCacheModel.languageId = null;
		}

		layoutLocalizationCacheModel.plid = getPlid();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			layoutLocalizationCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			layoutLocalizationCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return layoutLocalizationCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LayoutLocalization, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LayoutLocalization, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutLocalization, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(LayoutLocalization)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, LayoutLocalization>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					LayoutLocalization.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _layoutLocalizationId;
	private long _groupId;
	private long _companyId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _content;
	private String _languageId;
	private long _plid;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<LayoutLocalization, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((LayoutLocalization)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"layoutLocalizationId", _layoutLocalizationId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("content", _content);
		_columnOriginalValues.put("languageId", _languageId);
		_columnOriginalValues.put("plid", _plid);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("layoutLocalizationId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("content", 256L);

		columnBitmasks.put("languageId", 512L);

		columnBitmasks.put("plid", 1024L);

		columnBitmasks.put("lastPublishDate", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private LayoutLocalization _escapedModel;

}