/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.model.impl;

import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalServiceUtil;

/**
 * The extended model base implementation for the LayoutClassedModelUsage service. Represents a row in the &quot;LayoutClassedModelUsage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutClassedModelUsageImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutClassedModelUsageImpl
 * @see LayoutClassedModelUsage
 * @generated
 */
public abstract class LayoutClassedModelUsageBaseImpl
	extends LayoutClassedModelUsageModelImpl
	implements LayoutClassedModelUsage {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout classed model usage model instance should use the <code>LayoutClassedModelUsage</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			LayoutClassedModelUsageLocalServiceUtil.addLayoutClassedModelUsage(
				this);
		}
		else {
			LayoutClassedModelUsageLocalServiceUtil.
				updateLayoutClassedModelUsage(this);
		}
	}

}