/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.internal.friendly.url;

import com.liferay.layout.friendly.url.LayoutFriendlyURLEntryHelper;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.util.Portal;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alejandro Tardín
 */
@Component(service = LayoutFriendlyURLEntryHelper.class)
public class LayoutFriendlyURLEntryHelperImpl
	implements LayoutFriendlyURLEntryHelper {

	@Override
	public String getClassName(boolean privateLayout) {
		return _resourceActions.getCompositeModelName(
			Layout.class.getName(), String.valueOf(privateLayout));
	}

	@Override
	public long getClassNameId(boolean privateLayout) {
		return _portal.getClassNameId(getClassName(privateLayout));
	}

	@Reference
	private Portal _portal;

	@Reference
	private ResourceActions _resourceActions;

}