/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.service;

import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.layout.friendly.url.LayoutFriendlyURLEntryHelper;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ServiceWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class LayoutLocalServiceWrapper
extends com.liferay.portal.kernel.service.LayoutLocalServiceWrapper {
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private LayoutFriendlyURLEntryHelper _layoutFriendlyURLEntryHelper;

    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        Layout layout = super.fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
        if (layout != null) {
            return layout;
        }
        return this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        try {
            return super.getFriendlyURLLayout(groupId, privateLayout, friendlyURL);
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            Layout layout = this._fetchLayoutByFriendlyURL(groupId, privateLayout, friendlyURL);
            if (layout != null) {
                return layout;
            }
            throw noSuchLayoutException;
        }
    }

    private Layout _fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        Layout layout;
        FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.fetchFriendlyURLEntry(groupId, this._layoutFriendlyURLEntryHelper.getClassNameId(privateLayout), friendlyURL);
        if (friendlyURLEntry != null && (layout = this.fetchLayout(friendlyURLEntry.getClassPK())) != null) {
            return layout;
        }
        return null;
    }
}

