/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.language.LanguageResources;

import java.util.Locale;
import java.util.ResourceBundle;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author David Truong
 */
@Component(service = ConstraintResolver.class)
public class LayoutClassedModelUsageConstraintResolver
	implements ConstraintResolver<LayoutClassedModelUsage> {

	@Override
	public String getConflictDescriptionKey() {
		return "duplicate-layout-classed-model-usages";
	}

	@Override
	public Class<LayoutClassedModelUsage> getModelClass() {
		return LayoutClassedModelUsage.class;
	}

	@Override
	public String getResolutionDescriptionKey() {
		return "duplicate-layout-classed-model-usages-were-removed";
	}

	@Override
	public ResourceBundle getResourceBundle(Locale locale) {
		return LanguageResources.getResourceBundle(locale);
	}

	@Override
	public String[] getUniqueIndexColumnNames() {
		return new String[] {
			"classNameId", "classPK", "containerKey", "containerType", "plid"
		};
	}

	@Override
	public void resolveConflict(
			ConstraintResolverContext<LayoutClassedModelUsage>
				constraintResolverContext)
		throws PortalException {

		_layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(
			constraintResolverContext.getSourceCTModel());
	}

	@Reference
	private LayoutClassedModelUsageLocalService
		_layoutClassedModelUsageLocalService;

}