/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.layout.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.model.LayoutClassedModelUsageModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the LayoutClassedModelUsage service. Represents a row in the &quot;LayoutClassedModelUsage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>LayoutClassedModelUsageModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link LayoutClassedModelUsageImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see LayoutClassedModelUsageImpl
 * @generated
 */
public class LayoutClassedModelUsageModelImpl
	extends BaseModelImpl<LayoutClassedModelUsage>
	implements LayoutClassedModelUsageModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a layout classed model usage model instance should use the <code>LayoutClassedModelUsage</code> interface instead.
	 */
	public static final String TABLE_NAME = "LayoutClassedModelUsage";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"layoutClassedModelUsageId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"containerKey", Types.VARCHAR}, {"containerType", Types.BIGINT},
		{"plid", Types.BIGINT}, {"type_", Types.INTEGER},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("layoutClassedModelUsageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("containerKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("containerType", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("plid", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table LayoutClassedModelUsage (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,layoutClassedModelUsageId LONG not null,groupId LONG,companyId LONG,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,containerKey VARCHAR(200) null,containerType LONG,plid LONG,type_ INTEGER,lastPublishDate DATE null,primary key (layoutClassedModelUsageId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table LayoutClassedModelUsage";

	public static final String ORDER_BY_JPQL =
		" ORDER BY layoutClassedModelUsage.layoutClassedModelUsageId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY LayoutClassedModelUsage.layoutClassedModelUsageId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CONTAINERKEY_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CONTAINERTYPE_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PLID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LAYOUTCLASSEDMODELUSAGEID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public LayoutClassedModelUsageModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _layoutClassedModelUsageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setLayoutClassedModelUsageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _layoutClassedModelUsageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return LayoutClassedModelUsage.class;
	}

	@Override
	public String getModelClassName() {
		return LayoutClassedModelUsage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<LayoutClassedModelUsage, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<LayoutClassedModelUsage, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutClassedModelUsage, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((LayoutClassedModelUsage)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<LayoutClassedModelUsage, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<LayoutClassedModelUsage, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(LayoutClassedModelUsage)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<LayoutClassedModelUsage, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<LayoutClassedModelUsage, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<LayoutClassedModelUsage, Object>>
		_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<LayoutClassedModelUsage, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<LayoutClassedModelUsage, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<LayoutClassedModelUsage, Object>>();
		Map<String, BiConsumer<LayoutClassedModelUsage, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<LayoutClassedModelUsage, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", LayoutClassedModelUsage::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", LayoutClassedModelUsage::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setCtCollectionId);
		attributeGetterFunctions.put("uuid", LayoutClassedModelUsage::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<LayoutClassedModelUsage, String>)
				LayoutClassedModelUsage::setUuid);
		attributeGetterFunctions.put(
			"layoutClassedModelUsageId",
			LayoutClassedModelUsage::getLayoutClassedModelUsageId);
		attributeSetterBiConsumers.put(
			"layoutClassedModelUsageId",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setLayoutClassedModelUsageId);
		attributeGetterFunctions.put(
			"groupId", LayoutClassedModelUsage::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setGroupId);
		attributeGetterFunctions.put(
			"companyId", LayoutClassedModelUsage::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setCompanyId);
		attributeGetterFunctions.put(
			"createDate", LayoutClassedModelUsage::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<LayoutClassedModelUsage, Date>)
				LayoutClassedModelUsage::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", LayoutClassedModelUsage::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<LayoutClassedModelUsage, Date>)
				LayoutClassedModelUsage::setModifiedDate);
		attributeGetterFunctions.put(
			"classNameId", LayoutClassedModelUsage::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setClassNameId);
		attributeGetterFunctions.put(
			"classPK", LayoutClassedModelUsage::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setClassPK);
		attributeGetterFunctions.put(
			"containerKey", LayoutClassedModelUsage::getContainerKey);
		attributeSetterBiConsumers.put(
			"containerKey",
			(BiConsumer<LayoutClassedModelUsage, String>)
				LayoutClassedModelUsage::setContainerKey);
		attributeGetterFunctions.put(
			"containerType", LayoutClassedModelUsage::getContainerType);
		attributeSetterBiConsumers.put(
			"containerType",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setContainerType);
		attributeGetterFunctions.put("plid", LayoutClassedModelUsage::getPlid);
		attributeSetterBiConsumers.put(
			"plid",
			(BiConsumer<LayoutClassedModelUsage, Long>)
				LayoutClassedModelUsage::setPlid);
		attributeGetterFunctions.put("type", LayoutClassedModelUsage::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<LayoutClassedModelUsage, Integer>)
				LayoutClassedModelUsage::setType);
		attributeGetterFunctions.put(
			"lastPublishDate", LayoutClassedModelUsage::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<LayoutClassedModelUsage, Date>)
				LayoutClassedModelUsage::setLastPublishDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getLayoutClassedModelUsageId() {
		return _layoutClassedModelUsageId;
	}

	@Override
	public void setLayoutClassedModelUsageId(long layoutClassedModelUsageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_layoutClassedModelUsageId = layoutClassedModelUsageId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@Override
	public String getContainerKey() {
		if (_containerKey == null) {
			return "";
		}
		else {
			return _containerKey;
		}
	}

	@Override
	public void setContainerKey(String containerKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_containerKey = containerKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalContainerKey() {
		return getColumnOriginalValue("containerKey");
	}

	@Override
	public long getContainerType() {
		return _containerType;
	}

	@Override
	public void setContainerType(long containerType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_containerType = containerType;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalContainerType() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("containerType"));
	}

	@Override
	public long getPlid() {
		return _plid;
	}

	@Override
	public void setPlid(long plid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_plid = plid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalPlid() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("plid"));
	}

	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(LayoutClassedModelUsage.class.getName()),
			getClassNameId());
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), LayoutClassedModelUsage.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public LayoutClassedModelUsage toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, LayoutClassedModelUsage>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		LayoutClassedModelUsageImpl layoutClassedModelUsageImpl =
			new LayoutClassedModelUsageImpl();

		layoutClassedModelUsageImpl.setMvccVersion(getMvccVersion());
		layoutClassedModelUsageImpl.setCtCollectionId(getCtCollectionId());
		layoutClassedModelUsageImpl.setUuid(getUuid());
		layoutClassedModelUsageImpl.setLayoutClassedModelUsageId(
			getLayoutClassedModelUsageId());
		layoutClassedModelUsageImpl.setGroupId(getGroupId());
		layoutClassedModelUsageImpl.setCompanyId(getCompanyId());
		layoutClassedModelUsageImpl.setCreateDate(getCreateDate());
		layoutClassedModelUsageImpl.setModifiedDate(getModifiedDate());
		layoutClassedModelUsageImpl.setClassNameId(getClassNameId());
		layoutClassedModelUsageImpl.setClassPK(getClassPK());
		layoutClassedModelUsageImpl.setContainerKey(getContainerKey());
		layoutClassedModelUsageImpl.setContainerType(getContainerType());
		layoutClassedModelUsageImpl.setPlid(getPlid());
		layoutClassedModelUsageImpl.setType(getType());
		layoutClassedModelUsageImpl.setLastPublishDate(getLastPublishDate());

		layoutClassedModelUsageImpl.resetOriginalValues();

		return layoutClassedModelUsageImpl;
	}

	@Override
	public LayoutClassedModelUsage cloneWithOriginalValues() {
		LayoutClassedModelUsageImpl layoutClassedModelUsageImpl =
			new LayoutClassedModelUsageImpl();

		layoutClassedModelUsageImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		layoutClassedModelUsageImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		layoutClassedModelUsageImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		layoutClassedModelUsageImpl.setLayoutClassedModelUsageId(
			this.<Long>getColumnOriginalValue("layoutClassedModelUsageId"));
		layoutClassedModelUsageImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		layoutClassedModelUsageImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		layoutClassedModelUsageImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		layoutClassedModelUsageImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		layoutClassedModelUsageImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		layoutClassedModelUsageImpl.setClassPK(
			this.<Long>getColumnOriginalValue("classPK"));
		layoutClassedModelUsageImpl.setContainerKey(
			this.<String>getColumnOriginalValue("containerKey"));
		layoutClassedModelUsageImpl.setContainerType(
			this.<Long>getColumnOriginalValue("containerType"));
		layoutClassedModelUsageImpl.setPlid(
			this.<Long>getColumnOriginalValue("plid"));
		layoutClassedModelUsageImpl.setType(
			this.<Integer>getColumnOriginalValue("type_"));
		layoutClassedModelUsageImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));

		return layoutClassedModelUsageImpl;
	}

	@Override
	public int compareTo(LayoutClassedModelUsage layoutClassedModelUsage) {
		long primaryKey = layoutClassedModelUsage.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof LayoutClassedModelUsage)) {
			return false;
		}

		LayoutClassedModelUsage layoutClassedModelUsage =
			(LayoutClassedModelUsage)object;

		long primaryKey = layoutClassedModelUsage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<LayoutClassedModelUsage> toCacheModel() {
		LayoutClassedModelUsageCacheModel layoutClassedModelUsageCacheModel =
			new LayoutClassedModelUsageCacheModel();

		layoutClassedModelUsageCacheModel.mvccVersion = getMvccVersion();

		layoutClassedModelUsageCacheModel.ctCollectionId = getCtCollectionId();

		layoutClassedModelUsageCacheModel.uuid = getUuid();

		String uuid = layoutClassedModelUsageCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			layoutClassedModelUsageCacheModel.uuid = null;
		}

		layoutClassedModelUsageCacheModel.layoutClassedModelUsageId =
			getLayoutClassedModelUsageId();

		layoutClassedModelUsageCacheModel.groupId = getGroupId();

		layoutClassedModelUsageCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			layoutClassedModelUsageCacheModel.createDate = createDate.getTime();
		}
		else {
			layoutClassedModelUsageCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			layoutClassedModelUsageCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			layoutClassedModelUsageCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		layoutClassedModelUsageCacheModel.classNameId = getClassNameId();

		layoutClassedModelUsageCacheModel.classPK = getClassPK();

		layoutClassedModelUsageCacheModel.containerKey = getContainerKey();

		String containerKey = layoutClassedModelUsageCacheModel.containerKey;

		if ((containerKey != null) && (containerKey.length() == 0)) {
			layoutClassedModelUsageCacheModel.containerKey = null;
		}

		layoutClassedModelUsageCacheModel.containerType = getContainerType();

		layoutClassedModelUsageCacheModel.plid = getPlid();

		layoutClassedModelUsageCacheModel.type = getType();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			layoutClassedModelUsageCacheModel.lastPublishDate =
				lastPublishDate.getTime();
		}
		else {
			layoutClassedModelUsageCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return layoutClassedModelUsageCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<LayoutClassedModelUsage, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<LayoutClassedModelUsage, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutClassedModelUsage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(LayoutClassedModelUsage)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<LayoutClassedModelUsage, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<LayoutClassedModelUsage, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<LayoutClassedModelUsage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((LayoutClassedModelUsage)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, LayoutClassedModelUsage>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						LayoutClassedModelUsage.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _layoutClassedModelUsageId;
	private long _groupId;
	private long _companyId;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private String _containerKey;
	private long _containerType;
	private long _plid;
	private int _type;
	private Date _lastPublishDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<LayoutClassedModelUsage, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((LayoutClassedModelUsage)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"layoutClassedModelUsageId", _layoutClassedModelUsageId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("containerKey", _containerKey);
		_columnOriginalValues.put("containerType", _containerType);
		_columnOriginalValues.put("plid", _plid);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("layoutClassedModelUsageId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("classNameId", 256L);

		columnBitmasks.put("classPK", 512L);

		columnBitmasks.put("containerKey", 1024L);

		columnBitmasks.put("containerType", 2048L);

		columnBitmasks.put("plid", 4096L);

		columnBitmasks.put("type_", 8192L);

		columnBitmasks.put("lastPublishDate", 16384L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private LayoutClassedModelUsage _escapedModel;

}