/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.layout.internal.service;

import com.liferay.friendly.url.exception.DuplicateFriendlyURLEntryException;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.layout.friendly.url.LayoutFriendlyURLEntryHelper;
import com.liferay.portal.kernel.exception.LayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutFriendlyURLEntryValidator;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Noor Najjar
 * @author Roberto Díaz
 */
@Component(service = LayoutFriendlyURLEntryValidator.class)
public class LayoutFriendlyURLEntryValidatorImpl
	implements LayoutFriendlyURLEntryValidator {

	@Override
	public void validateFriendlyURLEntry(
			long groupId, boolean privateLayout, long classPK, String urlTitle)
		throws PortalException {

		try {
			_friendlyURLEntryLocalService.validate(
				groupId,
				_layoutFriendlyURLEntryHelper.getClassNameId(privateLayout),
				classPK, urlTitle);
		}
		catch (DuplicateFriendlyURLEntryException
					duplicateFriendlyURLEntryException) {

			LayoutFriendlyURLException layoutFriendlyURLException =
				new LayoutFriendlyURLException(
					LayoutFriendlyURLException.DUPLICATE);

			layoutFriendlyURLException.setDuplicateClassPK(classPK);
			layoutFriendlyURLException.setDuplicateClassName(
				Layout.class.getName());

			throw layoutFriendlyURLException;
		}
	}

	@Reference
	private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;

	@Reference
	private LayoutFriendlyURLEntryHelper _layoutFriendlyURLEntryHelper;

}