/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class LayoutUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select plid, typeSettings from Layout where classNameId = ? and classPK > 0 and type_ = ? and system_ = ?");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Layout set status = ? where plid = ?");){
            ps1.setLong(1, PortalUtil.getClassNameId(Layout.class));
            ps1.setString(2, "content");
            ps1.setBoolean(3, true);
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long plid = rs.getLong("plid");
                    String typeSettings = rs.getString("typeSettings");
                    UnicodeProperties unicodeProperties = new UnicodeProperties();
                    unicodeProperties.load(typeSettings);
                    boolean published = GetterUtil.getBoolean((String)unicodeProperties.getProperty("published"));
                    if (published) {
                        ps2.setInt(1, 0);
                    } else {
                        ps2.setInt(1, 2);
                    }
                    ps2.setLong(2, plid);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }
}

