/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.service.impl;

import com.liferay.layout.seo.exception.NoSuchEntryException;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTag;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTagProperty;
import com.liferay.layout.seo.service.base.LayoutSEOEntryLocalServiceBaseImpl;
import com.liferay.layout.seo.service.persistence.LayoutSEOEntryCustomMetaTagPersistence;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.seo.model.LayoutSEOEntry"}, service={AopService.class})
public class LayoutSEOEntryLocalServiceImpl
extends LayoutSEOEntryLocalServiceBaseImpl {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutSEOEntryCustomMetaTagPersistence _layoutSEOEntryCustomMetaTagPersistence;

    public LayoutSEOEntry copyLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long targetLayoutId, LayoutSEOEntry sourceLayoutSEOEntry, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry targetLayoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, targetLayoutId);
        targetLayoutSEOEntry = targetLayoutSEOEntry == null ? this._addLayoutSEOEntry(userId, groupId, privateLayout, targetLayoutId, sourceLayoutSEOEntry.isCanonicalURLEnabled(), sourceLayoutSEOEntry.getCanonicalURLMap(), new ArrayList<LayoutSEOEntryCustomMetaTagProperty>(), sourceLayoutSEOEntry.isOpenGraphDescriptionEnabled(), sourceLayoutSEOEntry.getOpenGraphDescriptionMap(), sourceLayoutSEOEntry.getOpenGraphImageAltMap(), sourceLayoutSEOEntry.getOpenGraphImageFileEntryId(), sourceLayoutSEOEntry.isOpenGraphTitleEnabled(), sourceLayoutSEOEntry.getOpenGraphTitleMap(), serviceContext) : this.updateLayoutSEOEntry(userId, groupId, privateLayout, targetLayoutId, sourceLayoutSEOEntry.isCanonicalURLEnabled(), sourceLayoutSEOEntry.getCanonicalURLMap(), sourceLayoutSEOEntry.isOpenGraphDescriptionEnabled(), sourceLayoutSEOEntry.getOpenGraphDescriptionMap(), sourceLayoutSEOEntry.getOpenGraphImageAltMap(), sourceLayoutSEOEntry.getOpenGraphImageFileEntryId(), sourceLayoutSEOEntry.isOpenGraphTitleEnabled(), sourceLayoutSEOEntry.getOpenGraphTitleMap(), serviceContext);
        this._addLayoutSEOEntryCustomMetaTag(targetLayoutSEOEntry.getCompanyId(), groupId, targetLayoutSEOEntry.getLayoutSEOEntryId(), TransformUtil.transform((Collection)this._layoutSEOEntryCustomMetaTagPersistence.findByG_L(groupId, sourceLayoutSEOEntry.getLayoutSEOEntryId()), layoutSEOEntryCustomMetaTag -> new LayoutSEOEntryCustomMetaTagProperty(layoutSEOEntryCustomMetaTag.getContentMap(), layoutSEOEntryCustomMetaTag.getProperty())));
        return targetLayoutSEOEntry;
    }

    @Override
    public LayoutSEOEntry deleteLayoutSEOEntry(LayoutSEOEntry layoutSEOEntry) {
        this.layoutSEOEntryPersistence.remove((BaseModel)layoutSEOEntry);
        this._layoutSEOEntryCustomMetaTagPersistence.removeByG_L(layoutSEOEntry.getGroupId(), layoutSEOEntry.getLayoutSEOEntryId());
        return layoutSEOEntry;
    }

    public void deleteLayoutSEOEntry(long groupId, boolean privateLayout, long layoutId) throws NoSuchEntryException {
        this.layoutSEOEntryLocalService.deleteLayoutSEOEntry(this.layoutSEOEntryPersistence.findByG_P_L(groupId, privateLayout, layoutId));
    }

    public void deleteLayoutSEOEntry(String uuid, long groupId) throws NoSuchEntryException {
        this.layoutSEOEntryLocalService.deleteLayoutSEOEntry(this.layoutSEOEntryPersistence.findByUUID_G(uuid, groupId));
    }

    public LayoutSEOEntry fetchLayoutSEOEntry(long groupId, boolean privateLayout, long layoutId) {
        return this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
    }

    @Override
    public List<LayoutSEOEntry> getLayoutSEOEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.layoutSEOEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<LayoutSEOEntryCustomMetaTag> getLayoutSEOEntryCustomMetaTags(long groupId, long layoutSEOEntryId) {
        return this._layoutSEOEntryCustomMetaTagPersistence.findByG_L(groupId, layoutSEOEntryId);
    }

    public LayoutSEOEntry updateCustomMetaTags(long userId, long groupId, boolean privateLayout, long layoutId, List<LayoutSEOEntryCustomMetaTagProperty> layoutSEOEntryCustomMetaTagProperties, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, false, Collections.emptyMap(), layoutSEOEntryCustomMetaTagProperties, false, Collections.emptyMap(), Collections.emptyMap(), 0L, false, Collections.emptyMap(), serviceContext);
        }
        this._addLayoutSEOEntryCustomMetaTag(layoutSEOEntry.getCompanyId(), groupId, layoutSEOEntry.getLayoutSEOEntryId(), layoutSEOEntryCustomMetaTagProperties);
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    public LayoutSEOEntry updateLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean canonicalURLEnabled, Map<Locale, String> canonicalURLMap, boolean openGraphDescriptionEnabled, Map<Locale, String> openGraphDescriptionMap, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, boolean openGraphTitleEnabled, Map<Locale, String> openGraphTitleMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, canonicalURLEnabled, canonicalURLMap, new ArrayList<LayoutSEOEntryCustomMetaTagProperty>(), openGraphDescriptionEnabled, openGraphDescriptionMap, openGraphImageAltMap, openGraphImageFileEntryId, openGraphTitleEnabled, openGraphTitleMap, serviceContext);
        }
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        layoutSEOEntry.setCanonicalURLEnabled(canonicalURLEnabled);
        layoutSEOEntry.setOpenGraphDescriptionMap(openGraphDescriptionMap);
        layoutSEOEntry.setOpenGraphDescriptionEnabled(openGraphDescriptionEnabled);
        if (openGraphImageFileEntryId != 0L) {
            layoutSEOEntry.setOpenGraphImageAltMap(openGraphImageAltMap);
        } else {
            layoutSEOEntry.setOpenGraphImageAltMap(Collections.emptyMap());
        }
        layoutSEOEntry.setOpenGraphImageFileEntryId(openGraphImageFileEntryId);
        layoutSEOEntry.setOpenGraphTitleMap(openGraphTitleMap);
        layoutSEOEntry.setOpenGraphTitleEnabled(openGraphTitleEnabled);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    public LayoutSEOEntry updateLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean openGraphDescriptionEnabled, Map<Locale, String> openGraphDescriptionMap, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, boolean openGraphTitleEnabled, Map<Locale, String> openGraphTitleMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, false, Collections.emptyMap(), new ArrayList<LayoutSEOEntryCustomMetaTagProperty>(), openGraphDescriptionEnabled, openGraphDescriptionMap, openGraphImageAltMap, openGraphImageFileEntryId, openGraphTitleEnabled, openGraphTitleMap, serviceContext);
        }
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        layoutSEOEntry.setOpenGraphDescriptionMap(openGraphDescriptionMap);
        layoutSEOEntry.setOpenGraphDescriptionEnabled(openGraphDescriptionEnabled);
        if (openGraphImageFileEntryId != 0L) {
            layoutSEOEntry.setOpenGraphImageAltMap(openGraphImageAltMap);
        } else {
            layoutSEOEntry.setOpenGraphImageAltMap(Collections.emptyMap());
        }
        layoutSEOEntry.setOpenGraphImageFileEntryId(openGraphImageFileEntryId);
        layoutSEOEntry.setOpenGraphTitleMap(openGraphTitleMap);
        layoutSEOEntry.setOpenGraphTitleEnabled(openGraphTitleEnabled);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    public LayoutSEOEntry updateLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean canonicalURLEnabled, Map<Locale, String> canonicalURLMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        if (layoutSEOEntry == null) {
            return this._addLayoutSEOEntry(userId, groupId, privateLayout, layoutId, canonicalURLEnabled, canonicalURLMap, new ArrayList<LayoutSEOEntryCustomMetaTagProperty>(), false, Collections.emptyMap(), Collections.emptyMap(), 0L, false, Collections.emptyMap(), serviceContext);
        }
        layoutSEOEntry.setModifiedDate(DateUtil.newDate());
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        layoutSEOEntry.setCanonicalURLEnabled(canonicalURLEnabled);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    private LayoutSEOEntry _addLayoutSEOEntry(long userId, long groupId, boolean privateLayout, long layoutId, boolean canonicalURLEnabled, Map<Locale, String> canonicalURLMap, List<LayoutSEOEntryCustomMetaTagProperty> layoutSEOEntryCustomMetaTagProperties, boolean openGraphDescriptionEnabled, Map<Locale, String> openGraphDescriptionMap, Map<Locale, String> openGraphImageAltMap, long openGraphImageFileEntryId, boolean openGraphTitleEnabled, Map<Locale, String> openGraphTitleMap, ServiceContext serviceContext) throws PortalException {
        LayoutSEOEntry layoutSEOEntry = this.layoutSEOEntryPersistence.create(this.counterLocalService.increment());
        layoutSEOEntry.setUuid(serviceContext.getUuid());
        layoutSEOEntry.setGroupId(groupId);
        Group group = this._groupLocalService.getGroup(groupId);
        layoutSEOEntry.setCompanyId(group.getCompanyId());
        layoutSEOEntry.setUserId(userId);
        Date date = DateUtil.newDate();
        layoutSEOEntry.setCreateDate(date);
        layoutSEOEntry.setModifiedDate(date);
        layoutSEOEntry.setPrivateLayout(privateLayout);
        layoutSEOEntry.setLayoutId(layoutId);
        layoutSEOEntry.setCanonicalURLMap(canonicalURLMap);
        layoutSEOEntry.setCanonicalURLEnabled(canonicalURLEnabled);
        layoutSEOEntry.setOpenGraphDescriptionMap(openGraphDescriptionMap);
        layoutSEOEntry.setOpenGraphDescriptionEnabled(openGraphDescriptionEnabled);
        if (openGraphImageFileEntryId != 0L) {
            layoutSEOEntry.setOpenGraphImageAltMap(openGraphImageAltMap);
        }
        layoutSEOEntry.setOpenGraphImageFileEntryId(openGraphImageFileEntryId);
        layoutSEOEntry.setOpenGraphTitleMap(openGraphTitleMap);
        layoutSEOEntry.setOpenGraphTitleEnabled(openGraphTitleEnabled);
        this._addLayoutSEOEntryCustomMetaTag(group.getCompanyId(), groupId, layoutSEOEntry.getLayoutSEOEntryId(), layoutSEOEntryCustomMetaTagProperties);
        return (LayoutSEOEntry)this.layoutSEOEntryPersistence.update((BaseModel)layoutSEOEntry);
    }

    private void _addLayoutSEOEntryCustomMetaTag(long companyId, long groupId, long layoutSEOEntryId, List<LayoutSEOEntryCustomMetaTagProperty> layoutSEOEntryCustomMetaTagProperties) {
        this._layoutSEOEntryCustomMetaTagPersistence.removeByG_L(groupId, layoutSEOEntryId);
        for (LayoutSEOEntryCustomMetaTagProperty layoutSEOEntryCustomMetaTagProperty : layoutSEOEntryCustomMetaTagProperties) {
            LayoutSEOEntryCustomMetaTag layoutSEOEntryCustomMetaTag = this._layoutSEOEntryCustomMetaTagPersistence.create(this.counterLocalService.increment());
            layoutSEOEntryCustomMetaTag.setGroupId(groupId);
            layoutSEOEntryCustomMetaTag.setCompanyId(companyId);
            layoutSEOEntryCustomMetaTag.setLayoutSEOEntryId(layoutSEOEntryId);
            layoutSEOEntryCustomMetaTag.setContentMap(layoutSEOEntryCustomMetaTagProperty.getContentMap());
            layoutSEOEntryCustomMetaTag.setProperty(layoutSEOEntryCustomMetaTagProperty.getProperty());
            this._layoutSEOEntryCustomMetaTagPersistence.update((BaseModel)layoutSEOEntryCustomMetaTag);
        }
    }
}

