/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTag;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTagProperty;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class LayoutSEOEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutSEOEntry> {
    public static final String[] CLASS_NAMES = new String[]{LayoutSEOEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(LayoutSEOEntryStagedModelDataHandler.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;

    public void deleteStagedModel(LayoutSEOEntry layoutSEOEntry) {
        this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(layoutSEOEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._layoutSEOEntryLocalService.deleteLayoutSEOEntry(uuid, groupId);
    }

    public List<LayoutSEOEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._layoutSEOEntryLocalService.getLayoutSEOEntriesByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutSEOEntry layoutSEOEntry) throws Exception {
        FileEntry openGraphImageFileEntry = this._fetchFileEntry(layoutSEOEntry.getOpenGraphImageFileEntryId());
        if (openGraphImageFileEntry != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutSEOEntry, (StagedModel)openGraphImageFileEntry, (String)"weak");
        }
        Element layoutSEOEntryElement = portletDataContext.getExportDataElement((ClassedModel)layoutSEOEntry);
        List layoutSEOEntryCustomMetaTags = this._layoutSEOEntryLocalService.getLayoutSEOEntryCustomMetaTags(layoutSEOEntry.getGroupId(), layoutSEOEntry.getLayoutSEOEntryId());
        for (LayoutSEOEntryCustomMetaTag layoutSEOEntryCustomMetaTag : layoutSEOEntryCustomMetaTags) {
            Element customMetaTagElement = layoutSEOEntryElement.addElement("custom-meta-tag");
            customMetaTagElement.addAttribute("property", layoutSEOEntryCustomMetaTag.getProperty());
            Map contentMap = layoutSEOEntryCustomMetaTag.getContentMap();
            for (Map.Entry entry : contentMap.entrySet()) {
                Element contentElement = customMetaTagElement.addElement("content");
                contentElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)((Locale)entry.getKey())));
                contentElement.addText((String)entry.getValue());
            }
        }
        portletDataContext.addClassedModel(layoutSEOEntryElement, ExportImportPathUtil.getModelPath((StagedModel)layoutSEOEntry), (ClassedModel)layoutSEOEntry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutSEOEntry layoutSEOEntry) throws Exception {
        Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
        long openGraphImageFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)layoutSEOEntry.getOpenGraphImageFileEntryId(), (long)0L);
        LayoutSEOEntry existingLayoutSEOEntry = (LayoutSEOEntry)this.fetchStagedModelByUuidAndGroupId(layoutSEOEntry.getUuid(), layoutSEOEntry.getGroupId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layoutSEOEntry);
        if (portletDataContext.isDataStrategyMirror() && existingLayoutSEOEntry == null) {
            serviceContext.setUuid(layoutSEOEntry.getUuid());
        }
        if (existingLayoutSEOEntry == null) {
            Layout layout = this._layoutLocalService.getLayout(portletDataContext.getPlid());
            existingLayoutSEOEntry = this._layoutSEOEntryLocalService.updateLayoutSEOEntry(layoutSEOEntry.getUserId(), layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layoutSEOEntry.isCanonicalURLEnabled(), layoutSEOEntry.getCanonicalURLMap(), layoutSEOEntry.isOpenGraphDescriptionEnabled(), layoutSEOEntry.getOpenGraphDescriptionMap(), layoutSEOEntry.getOpenGraphImageAltMap(), openGraphImageFileEntryId, layoutSEOEntry.isOpenGraphTitleEnabled(), layoutSEOEntry.getOpenGraphTitleMap(), serviceContext);
        } else {
            existingLayoutSEOEntry = this._layoutSEOEntryLocalService.updateLayoutSEOEntry(existingLayoutSEOEntry.getUserId(), portletDataContext.getScopeGroupId(), layoutSEOEntry.isPrivateLayout(), existingLayoutSEOEntry.getLayoutId(), layoutSEOEntry.isCanonicalURLEnabled(), layoutSEOEntry.getCanonicalURLMap(), layoutSEOEntry.isOpenGraphDescriptionEnabled(), layoutSEOEntry.getOpenGraphDescriptionMap(), layoutSEOEntry.getOpenGraphImageAltMap(), openGraphImageFileEntryId, layoutSEOEntry.isOpenGraphTitleEnabled(), layoutSEOEntry.getOpenGraphTitleMap(), serviceContext);
        }
        this._layoutSEOEntryLocalService.updateCustomMetaTags(existingLayoutSEOEntry.getUserId(), existingLayoutSEOEntry.getGroupId(), existingLayoutSEOEntry.isPrivateLayout(), existingLayoutSEOEntry.getLayoutId(), this._getLayoutSEOEntryCustomMetaTagProperties(portletDataContext.getImportDataElement((StagedModel)layoutSEOEntry)), serviceContext);
    }

    private FileEntry _fetchFileEntry(long fileEntryId) {
        if (fileEntryId <= 0L) {
            return null;
        }
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get file entry " + fileEntryId), (Throwable)portalException);
            }
            return null;
        }
    }

    private List<LayoutSEOEntryCustomMetaTagProperty> _getLayoutSEOEntryCustomMetaTagProperties(Element layoutSEOEntryElement) {
        ArrayList<LayoutSEOEntryCustomMetaTagProperty> layoutSEOEntryCustomMetaTagProperties = new ArrayList<LayoutSEOEntryCustomMetaTagProperty>();
        for (Element customMetaTagElement : layoutSEOEntryElement.elements("custom-meta-tag")) {
            String property = customMetaTagElement.attributeValue("property");
            if (Validator.isNull((String)property)) continue;
            HashMap<Locale, String> contentMap = new HashMap<Locale, String>();
            for (Element contentElement : customMetaTagElement.elements()) {
                contentMap.put(LocaleUtil.fromLanguageId((String)contentElement.attributeValue("language-id")), contentElement.getText());
            }
            if (!MapUtil.isNotEmpty(contentMap)) continue;
            layoutSEOEntryCustomMetaTagProperties.add(new LayoutSEOEntryCustomMetaTagProperty(contentMap, property));
        }
        return layoutSEOEntryCustomMetaTagProperties;
    }
}

