/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.template;

import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.layout.seo.template.LayoutSEOTemplateProcessor;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;

@Component(service={LayoutSEOTemplateProcessor.class})
public class LayoutSEOTemplateProcessorImpl
implements LayoutSEOTemplateProcessor {
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^:}]+)(?::[^}]*)?\\}");

    public String processTemplate(String template, InfoItemFieldValues infoItemFieldValues, Locale locale) {
        if (infoItemFieldValues == null || Validator.isNull((String)template)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _pattern.matcher(template);
        while (matcher.find()) {
            String variableName = matcher.group(1);
            InfoFieldValue infoFieldValue = infoItemFieldValues.getInfoFieldValue(variableName);
            if (infoFieldValue != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(String.valueOf(infoFieldValue.getValue(locale))));
                continue;
            }
            matcher.appendReplacement(sb, Matcher.quoteReplacement(variableName));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

