/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.layout.seo.model.LayoutSEOSite;
import com.liferay.layout.seo.service.LayoutSEOSiteLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class LayoutSEOSiteStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutSEOSite> {
    public static final String[] CLASS_NAMES = new String[]{LayoutSEOSite.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(LayoutSEOSiteStagedModelDataHandler.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private LayoutSEOSiteLocalService _layoutSEOSiteLocalService;

    public void deleteStagedModel(LayoutSEOSite layoutSEOSite) {
        this._layoutSEOSiteLocalService.deleteLayoutSEOSite(layoutSEOSite);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._layoutSEOSiteLocalService.deleteLayoutSEOSite(uuid, groupId);
    }

    public List<LayoutSEOSite> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._layoutSEOSiteLocalService.getLayoutSEOSitesByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutSEOSite layoutSEOSite) throws Exception {
        FileEntry openGraphImageFileEntry = this._fetchFileEntry(layoutSEOSite.getOpenGraphImageFileEntryId());
        if (openGraphImageFileEntry != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutSEOSite, (StagedModel)openGraphImageFileEntry, (String)"weak");
        }
        portletDataContext.addClassedModel(portletDataContext.getExportDataElement((ClassedModel)layoutSEOSite), ExportImportPathUtil.getModelPath((StagedModel)layoutSEOSite), (ClassedModel)layoutSEOSite);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutSEOSite layoutSEOSite) throws Exception {
        Map fileEntryIds = portletDataContext.getNewPrimaryKeysMap(FileEntry.class);
        long openGraphImageFileEntryId = MapUtil.getLong((Map)fileEntryIds, (long)layoutSEOSite.getOpenGraphImageFileEntryId(), (long)0L);
        LayoutSEOSite existingLayoutSEOSite = (LayoutSEOSite)this.fetchStagedModelByUuidAndGroupId(layoutSEOSite.getUuid(), layoutSEOSite.getGroupId());
        if (existingLayoutSEOSite == null) {
            this._layoutSEOSiteLocalService.updateLayoutSEOSite(portletDataContext.getUserId(layoutSEOSite.getUserUuid()), portletDataContext.getScopeGroupId(), layoutSEOSite.isOpenGraphEnabled(), layoutSEOSite.getOpenGraphImageAltMap(), openGraphImageFileEntryId, this._createServiceContext(layoutSEOSite, null, portletDataContext));
        } else {
            this._layoutSEOSiteLocalService.updateLayoutSEOSite(existingLayoutSEOSite.getUserId(), existingLayoutSEOSite.getGroupId(), layoutSEOSite.isOpenGraphEnabled(), layoutSEOSite.getOpenGraphImageAltMap(), openGraphImageFileEntryId, this._createServiceContext(layoutSEOSite, existingLayoutSEOSite, portletDataContext));
        }
    }

    private ServiceContext _createServiceContext(LayoutSEOSite layoutSEOSite, LayoutSEOSite existingLayoutSEOSite, PortletDataContext portletDataContext) {
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layoutSEOSite);
        if (portletDataContext.isDataStrategyMirror() && existingLayoutSEOSite == null) {
            serviceContext.setUuid(layoutSEOSite.getUuid());
        }
        return serviceContext;
    }

    private FileEntry _fetchFileEntry(long fileEntryId) {
        if (fileEntryId <= 0L) {
            return null;
        }
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get file entry " + fileEntryId), (Throwable)portalException);
            }
            return null;
        }
    }
}

