/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal.util;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.display.page.util.AssetDisplayPageUtil;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;

public class AlternateURLMapperProvider {
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private ClassNameLocalService _classNameLocalService;
    private final Portal _portal;

    public AlternateURLMapperProvider(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, ClassNameLocalService classNameLocalService, Portal portal) {
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
        this._classNameLocalService = classNameLocalService;
        this._portal = portal;
    }

    public AlternateURLMapper getAlternateURLMapper(HttpServletRequest httpServletRequest) {
        LayoutDisplayPageObjectProvider layoutDisplayPageObjectProvider = (LayoutDisplayPageObjectProvider)httpServletRequest.getAttribute("LAYOUT_DISPLAY_PAGE_OBJECT_PROVIDER");
        if (layoutDisplayPageObjectProvider != null && AssetDisplayPageUtil.hasAssetDisplayPage((long)layoutDisplayPageObjectProvider.getGroupId(), (long)layoutDisplayPageObjectProvider.getClassNameId(), (long)layoutDisplayPageObjectProvider.getClassPK(), (long)layoutDisplayPageObjectProvider.getClassTypeId())) {
            return new AssetDisplayPageAlternateURLMapper(this._assetDisplayPageFriendlyURLProvider, this._classNameLocalService, layoutDisplayPageObjectProvider, this._portal);
        }
        return new DefaultPageAlternateURLMapper(this._portal);
    }

    public static class AssetDisplayPageAlternateURLMapper
    implements AlternateURLMapper {
        private final AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
        private final ClassNameLocalService _classNameLocalService;
        private final LayoutDisplayPageObjectProvider<?> _layoutDisplayPageObjectProvider;
        private final Portal _portal;

        @Override
        public String getAlternateURL(String canonicalURL, ThemeDisplay themeDisplay, Locale locale, Layout layout) throws PortalException {
            return this._getAlternateURL(canonicalURL, this._getPortalURL(themeDisplay), themeDisplay, locale, layout);
        }

        @Override
        public Map<Locale, String> getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout, Set<Locale> locales) throws PortalException {
            HashMap<Locale, String> alternateURLs = new HashMap<Locale, String>();
            String portalURL = this._getPortalURL(themeDisplay);
            for (Locale locale : locales) {
                alternateURLs.put(locale, this._getAlternateURL(canonicalURL, portalURL, themeDisplay, locale, layout));
            }
            return alternateURLs;
        }

        protected AssetDisplayPageAlternateURLMapper(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, ClassNameLocalService classNameLocalService, LayoutDisplayPageObjectProvider<?> layoutDisplayPageObjectProvider, Portal portal) {
            this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
            this._classNameLocalService = classNameLocalService;
            this._layoutDisplayPageObjectProvider = layoutDisplayPageObjectProvider;
            this._portal = portal;
        }

        private String _getAlternateURL(String canonicalURL, String portalURL, ThemeDisplay themeDisplay, Locale locale, Layout layout) throws PortalException {
            return this._portal.getAlternateURL(this._getCanonicalFriendlyURL(canonicalURL, portalURL, locale, themeDisplay), themeDisplay, locale, layout);
        }

        private String _getCanonicalFriendlyURL(String defaultURL, String portalURL, Locale locale, ThemeDisplay themeDisplay) throws PortalException {
            String friendlyURL = this._getMappedFriendlyURL(defaultURL, locale, themeDisplay);
            if (friendlyURL.startsWith("http")) {
                return friendlyURL;
            }
            return portalURL.concat(friendlyURL);
        }

        private String _getMappedFriendlyURL(String url, Locale locale, ThemeDisplay themeDisplay) throws PortalException {
            if (this._layoutDisplayPageObjectProvider == null) {
                return url;
            }
            return this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(new InfoItemReference(this._layoutDisplayPageObjectProvider.getClassName(), (InfoItemIdentifier)new ClassPKInfoItemIdentifier(this._layoutDisplayPageObjectProvider.getClassPK())), locale, themeDisplay);
        }

        private String _getPortalURL(ThemeDisplay themeDisplay) {
            TreeMap virtualHostnames = this._portal.getVirtualHostnames(themeDisplay.getLayoutSet());
            String virtualHostname = null;
            if (!virtualHostnames.isEmpty()) {
                virtualHostname = (String)virtualHostnames.firstKey();
            }
            if (Validator.isNull(virtualHostname)) {
                virtualHostname = "localhost";
                Company company = themeDisplay.getCompany();
                if (company != null && Validator.isNotNull((String)company.getVirtualHostname())) {
                    virtualHostname = company.getVirtualHostname();
                }
            }
            return this._portal.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
        }
    }

    public static class DefaultPageAlternateURLMapper
    implements AlternateURLMapper {
        private final Portal _portal;

        @Override
        public String getAlternateURL(String canonicalURL, ThemeDisplay themeDisplay, Locale locale, Layout layout) throws PortalException {
            return this._portal.getAlternateURL(canonicalURL, themeDisplay, locale, layout);
        }

        protected DefaultPageAlternateURLMapper(Portal portal) {
            this._portal = portal;
        }
    }

    public static interface AlternateURLMapper {
        public String getAlternateURL(String var1, ThemeDisplay var2, Locale var3, Layout var4) throws PortalException;

        default public Map<Locale, String> getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout, Set<Locale> locales) throws PortalException {
            HashMap<Locale, String> alternateURLs = new HashMap<Locale, String>();
            for (Locale locale : locales) {
                alternateURLs.put(locale, this.getAlternateURL(canonicalURL, themeDisplay, locale, layout));
            }
            return alternateURLs;
        }
    }
}

