/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.seo.internal;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.layout.seo.canonical.url.LayoutSEOCanonicalURLProvider;
import com.liferay.layout.seo.internal.LayoutSEOLinkImpl;
import com.liferay.layout.seo.internal.configuration.LayoutSEOGeneralGroupConfiguration;
import com.liferay.layout.seo.internal.util.AlternateURLMapperProvider;
import com.liferay.layout.seo.kernel.LayoutSEOLink;
import com.liferay.layout.seo.kernel.LayoutSEOLinkManager;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListMergeable;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutSEOLinkManager.class})
public class LayoutSEOLinkManagerImpl
implements LayoutSEOLinkManager {
    private static final String _SEPARATOR = " - ";
    private static final Log _log = LogFactoryUtil.getLog(LayoutSEOLinkManagerImpl.class);
    private AlternateURLMapperProvider _alternateURLMapperProvider;
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Language _language;
    @Reference
    private LayoutSEOCanonicalURLProvider _layoutSEOCanonicalURLProvider;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private Portal _portal;

    public LayoutSEOLink getCanonicalLayoutSEOLink(Layout layout, Locale locale, String canonicalURL, ThemeDisplay themeDisplay) throws PortalException {
        return new LayoutSEOLinkImpl(HtmlUtil.escapeAttribute((String)this._layoutSEOCanonicalURLProvider.getCanonicalURL(layout, locale, canonicalURL, themeDisplay)), null, LayoutSEOLink.Relationship.CANONICAL);
    }

    public String getFullPageTitle(Layout layout, String portletId, String tilesTitle, ListMergeable<String> titleListMergeable, ListMergeable<String> subtitleListMergeable, String companyName, Locale locale) throws PortalException {
        String layoutTitle = this._getPageTitle(layout, portletId, tilesTitle, titleListMergeable, subtitleListMergeable, locale);
        String suffix = this._getPageTitleSuffix(layout, companyName);
        if (Validator.isNotNull((String)suffix)) {
            return this._merge(layoutTitle, suffix);
        }
        return layoutTitle;
    }

    public List<LayoutSEOLink> getLocalizedLayoutSEOLinks(Layout layout, Locale locale, String canonicalURL, Set<Locale> availableLocales) throws PortalException {
        ThemeDisplay themeDisplay = this._getThemeDisplay();
        AlternateURLMapperProvider.AlternateURLMapper alternateURLMapper = this._alternateURLMapperProvider.getAlternateURLMapper(this._getHttpServletRequest());
        Map<Locale, String> alternateURLs = alternateURLMapper.getAlternateURLs(canonicalURL, themeDisplay, layout, availableLocales);
        ArrayList<LayoutSEOLink> layoutSEOLinks = new ArrayList<LayoutSEOLink>(availableLocales.size() + 2);
        layoutSEOLinks.add(this.getCanonicalLayoutSEOLink(layout, locale, canonicalURL, themeDisplay));
        Locale siteDefaultLocale = this._portal.getSiteDefaultLocale(layout.getGroupId());
        Map<Locale, String> alternateCanonicalURLs = this._getAlternateCanonicalURLs(alternateURLs, layout, siteDefaultLocale);
        for (Map.Entry<Locale, String> entry : alternateCanonicalURLs.entrySet()) {
            layoutSEOLinks.add(new LayoutSEOLinkImpl(HtmlUtil.escapeAttribute((String)entry.getValue()), LocaleUtil.toW3cLanguageId((Locale)entry.getKey()), LayoutSEOLink.Relationship.ALTERNATE));
        }
        String defaultLocaleURL = alternateCanonicalURLs.get(siteDefaultLocale);
        if (defaultLocaleURL == null) {
            return layoutSEOLinks;
        }
        layoutSEOLinks.add(new LayoutSEOLinkImpl(HtmlUtil.escapeAttribute((String)defaultLocaleURL), "x-default", LayoutSEOLink.Relationship.ALTERNATE));
        return layoutSEOLinks;
    }

    public String getPageTitle(Layout layout, String portletId, String tilesTitle, ListMergeable<String> titleListMergeable, ListMergeable<String> subtitleListMergeable, Locale locale) throws PortalException {
        return HtmlUtil.escape((String)this._getPageTitle(layout, portletId, tilesTitle, titleListMergeable, subtitleListMergeable, locale));
    }

    public String getPageTitleSuffix(Layout layout, String companyName) throws PortalException {
        return HtmlUtil.escape((String)this._getPageTitleSuffix(layout, companyName));
    }

    @Activate
    protected void activate() {
        this._alternateURLMapperProvider = new AlternateURLMapperProvider(this._assetDisplayPageFriendlyURLProvider, this._classNameLocalService, this._portal);
    }

    @Deactivate
    protected void deactivate() {
        this._alternateURLMapperProvider = null;
    }

    private Map<Locale, String> _getAlternateCanonicalURLs(Map<Locale, String> alternateURLs, Layout layout, Locale siteDefaultLocale) {
        LayoutSEOEntry layoutSEOEntry = this._layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null || !layoutSEOEntry.isCanonicalURLEnabled()) {
            return alternateURLs;
        }
        HashMap<Locale, String> alternateCanonicalURLs = new HashMap<Locale, String>();
        try {
            siteDefaultLocale = this._portal.getSiteDefaultLocale(layout.getGroupId());
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        String currentCanonicalURL = layoutSEOEntry.getCanonicalURL(siteDefaultLocale);
        for (Map.Entry<Locale, String> entry : alternateURLs.entrySet()) {
            Locale locale = entry.getKey();
            String alternateCanonicalURL = layoutSEOEntry.getCanonicalURL(locale);
            if (!locale.equals(siteDefaultLocale) && currentCanonicalURL.equals(alternateCanonicalURL)) {
                alternateCanonicalURL = entry.getValue();
            }
            alternateCanonicalURLs.put(locale, alternateCanonicalURL);
        }
        return alternateCanonicalURLs;
    }

    private HttpServletRequest _getHttpServletRequest() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            return serviceContext.getRequest();
        }
        return null;
    }

    private String _getPageTitle(Layout layout, String portletId, String tilesTitle, ListMergeable<String> titleListMergeable, ListMergeable<String> subtitleListMergeable, Locale locale) throws PortalException {
        if (Validator.isNotNull((String)portletId) && layout.isSystem() && !layout.isTypeControlPanel() && StringUtil.equals((String)layout.getFriendlyURL(), (String)"/manage")) {
            return this._portal.getPortletTitle(portletId, locale);
        }
        if (Validator.isNotNull((String)tilesTitle)) {
            return this._language.get(locale, tilesTitle);
        }
        if (subtitleListMergeable == null) {
            return this._getTitle(layout, titleListMergeable, locale);
        }
        return this._merge(subtitleListMergeable.mergeToString(_SEPARATOR), this._getTitle(layout, titleListMergeable, locale));
    }

    private String _getPageTitleSuffix(Layout layout, String companyName) throws PortalException {
        LayoutSEOGeneralGroupConfiguration layoutSEOGeneralGroupConfiguration = (LayoutSEOGeneralGroupConfiguration)this._configurationProvider.getGroupConfiguration(LayoutSEOGeneralGroupConfiguration.class, layout.getGroupId());
        if (!layoutSEOGeneralGroupConfiguration.includeInstanceName() && !layoutSEOGeneralGroupConfiguration.includeSiteName()) {
            return "";
        }
        if (layoutSEOGeneralGroupConfiguration.includeInstanceName() && layoutSEOGeneralGroupConfiguration.includeSiteName()) {
            Group group = layout.getGroup();
            if (group.isControlPanel() || group.isLayoutPrototype() || StringUtil.equals((String)companyName, (String)group.getDescriptiveName())) {
                return companyName;
            }
            return this._merge(group.getDescriptiveName(), companyName);
        }
        if (layoutSEOGeneralGroupConfiguration.includeInstanceName()) {
            return companyName;
        }
        Group group = layout.getGroup();
        return group.getDescriptiveName();
    }

    private ThemeDisplay _getThemeDisplay() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            return serviceContext.getThemeDisplay();
        }
        return null;
    }

    private String _getTitle(Layout layout, ListMergeable<String> titleListMergeable, Locale locale) throws PortalException {
        Group group = layout.getGroup();
        if (group.isLayoutPrototype()) {
            return group.getDescriptiveName(locale);
        }
        HttpServletRequest httpServletRequest = this._getHttpServletRequest();
        if (Validator.isNull((String)PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND) && httpServletRequest != null && SessionErrors.contains((HttpServletRequest)httpServletRequest, NoSuchLayoutException.class)) {
            if (titleListMergeable == null) {
                titleListMergeable = new ListMergeable();
            }
            titleListMergeable.add((Object)this._language.get(locale, "status"));
        }
        if (titleListMergeable != null) {
            return titleListMergeable.mergeToString(_SEPARATOR);
        }
        return layout.getHTMLTitle(this._language.getLanguageId(locale));
    }

    private String _merge(String ... strings) {
        return StringUtil.merge((Object[])strings, (String)_SEPARATOR);
    }
}

