/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_4_3;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class ResourcePermissionUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ResourcePermissionUpgradeProcess.class);
    private final ResourcePermissionLocalService _resourcePermissionLocalService;

    public ResourcePermissionUpgradeProcess(ResourcePermissionLocalService resourcePermissionLocalService) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._addResourcePermissions();
    }

    private void _addResourcePermissions() {
        List resourcePermissions = this._resourcePermissionLocalService.getResourcePermissions(LayoutPrototype.class.getName());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            String primKey = resourcePermission.getPrimKey();
            long primKeyId = resourcePermission.getPrimKeyId();
            if (!primKey.equals(LayoutPrototype.class.getName())) {
                long layoutPageTemplateEntryId = this._getLayoutPageTemplateEntryId(primKeyId);
                if (layoutPageTemplateEntryId == 0L) continue;
                primKey = String.valueOf(layoutPageTemplateEntryId);
                primKeyId = layoutPageTemplateEntryId;
            } else {
                primKey = LayoutPageTemplateEntry.class.getName();
            }
            ResourcePermission existingResourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(resourcePermission.getCompanyId(), LayoutPageTemplateEntry.class.getName(), resourcePermission.getScope(), primKey, resourcePermission.getRoleId());
            if (existingResourcePermission != null) continue;
            ResourcePermission newResourcePermission = this._resourcePermissionLocalService.createResourcePermission(this.increment(ResourcePermission.class.getName()));
            newResourcePermission.setCompanyId(resourcePermission.getCompanyId());
            newResourcePermission.setName(LayoutPageTemplateEntry.class.getName());
            newResourcePermission.setScope(resourcePermission.getScope());
            newResourcePermission.setPrimKey(primKey);
            newResourcePermission.setPrimKeyId(primKeyId);
            newResourcePermission.setRoleId(resourcePermission.getRoleId());
            newResourcePermission.setOwnerId(resourcePermission.getOwnerId());
            newResourcePermission.setActionIds(resourcePermission.getActionIds());
            newResourcePermission.setViewActionId(resourcePermission.isViewActionId());
            this._resourcePermissionLocalService.addResourcePermission(newResourcePermission);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private long _getLayoutPageTemplateEntryId(long layoutPrototypeId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select layoutPageTemplateEntryId from ", "LayoutPageTemplateEntry where layoutPrototypeId = ? ", "order by name asc"}));){
            long l;
            block19: {
                ResultSet resultSet;
                block17: {
                    long l2;
                    block18: {
                        preparedStatement.setLong(1, layoutPrototypeId);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (resultSet.next()) break block17;
                            l2 = 0L;
                            if (resultSet == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return l2;
                }
                l = resultSet.getLong("layoutPageTemplateEntryId");
                if (resultSet == null) break block19;
                resultSet.close();
            }
            return l;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return 0L;
        }
    }
}

