/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.asset.kernel.NoSuchClassTypeException;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryDefaultTemplateException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryGroupIdException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryLayoutPageTemplateCollectionIdException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryLayoutPageTemplateEntryKeyException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateEntryNameException;
import com.liferay.layout.page.template.exception.NoSuchPageTemplateEntryException;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateEntryLocalServiceBaseImpl;
import com.liferay.layout.page.template.service.persistence.LayoutPageTemplateCollectionPersistence;
import com.liferay.layout.validator.LayoutValidator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.LockedLayoutException;
import com.liferay.portal.kernel.exception.NoSuchClassNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UniqueUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.staging.StagingGroupHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={AopService.class})
public class LayoutPageTemplateEntryLocalServiceImpl
extends LayoutPageTemplateEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutPageTemplateEntryLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private File _file;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionPersistence _layoutPageTemplateCollectionPersistence;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public LayoutPageTemplateEntry addGlobalLayoutPageTemplateEntry(LayoutPrototype layoutPrototype) throws PortalException {
        Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
        return this._addLayoutPageTemplateEntry(company.getGroupId(), layoutPrototype);
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(LayoutPrototype layoutPrototype) throws PortalException {
        Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
        return this._addLayoutPageTemplateEntry(company.getGroupId(), layoutPrototype);
    }

    @Indexable(type=IndexableType.REINDEX)
    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(String externalReferenceCode, long userId, long groupId, long layoutPageTemplateCollectionId, String layoutPageTemplateEntryKey, long classNameId, long classTypeId, String name, int type, long previewFileEntryId, boolean defaultTemplate, long layoutPrototypeId, long plid, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        Layout layout;
        User user = this._userLocalService.getUser(userId);
        this._validate(groupId, layoutPageTemplateCollectionId, name, type, defaultTemplate, status);
        this._validate(groupId, layoutPageTemplateCollectionId, type);
        if (Validator.isNull((String)layoutPageTemplateEntryKey)) {
            layoutPageTemplateEntryKey = this._generateLayoutPageTemplateEntryKey(groupId, name);
        } else {
            this._validateLayoutPageTemplateEntryKey(groupId, layoutPageTemplateEntryKey, type);
        }
        long layoutPageTemplateEntryId = this.counterLocalService.increment();
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.create(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setUuid(serviceContext.getUuid());
        layoutPageTemplateEntry.setExternalReferenceCode(externalReferenceCode);
        layoutPageTemplateEntry.setGroupId(groupId);
        layoutPageTemplateEntry.setCompanyId(user.getCompanyId());
        layoutPageTemplateEntry.setUserId(user.getUserId());
        layoutPageTemplateEntry.setUserName(user.getFullName());
        layoutPageTemplateEntry.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateEntry.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateEntry.setLayoutPageTemplateCollectionId(layoutPageTemplateCollectionId);
        layoutPageTemplateEntry.setLayoutPageTemplateEntryKey(layoutPageTemplateEntryKey);
        layoutPageTemplateEntry.setClassNameId(classNameId);
        layoutPageTemplateEntry.setClassTypeId(classTypeId);
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry.setType(type);
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        if (type == 2 && layoutPrototypeId == 0L) {
            serviceContext.setAttribute("layoutPageTemplateEntryId", (Serializable)Long.valueOf(layoutPageTemplateEntryId));
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.addLayoutPrototype(userId, user.getCompanyId(), Collections.singletonMap(LocaleUtil.getMostRelevantLocale(), name), Collections.emptyMap(), true, serviceContext);
            layoutPrototypeId = layoutPrototype.getLayoutPrototypeId();
            Layout layout2 = layoutPrototype.getLayout();
            plid = layout2.getPlid();
        }
        layoutPageTemplateEntry.setLayoutPrototypeId(layoutPrototypeId);
        if (plid == 0L && (layout = this._addLayout(userId, groupId, name, type, masterLayoutPlid, status, serviceContext)) != null) {
            plid = layout.getPlid();
        }
        layoutPageTemplateEntry.setPlid(plid);
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        layoutPageTemplateEntry = (LayoutPageTemplateEntry)this.layoutPageTemplateEntryPersistence.update((BaseModel)layoutPageTemplateEntry);
        this._resourceLocalService.addResources(layoutPageTemplateEntry.getCompanyId(), layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getUserId(), LayoutPageTemplateEntry.class.getName(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), false, true, true);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(String externalReferenceCode, long userId, long groupId, long layoutPageTemplateCollectionId, String layoutPageTemplateEntryKey, long classNameId, long classTypeId, String name, int type, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        this._validate(groupId, classNameId, classTypeId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.addLayoutPageTemplateEntry(externalReferenceCode, userId, groupId, layoutPageTemplateCollectionId, layoutPageTemplateEntryKey, classNameId, classTypeId, name, type, 0L, false, 0L, 0L, masterLayoutPlid, status, serviceContext);
        this._ddmStructureLinkLocalService.addStructureLink(this._classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), classTypeId);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry addLayoutPageTemplateEntry(String externalReferenceCode, long userId, long groupId, long layoutPageTemplateCollectionId, String layoutPageTemplateEntryKey, String name, int type, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        return this.addLayoutPageTemplateEntry(externalReferenceCode, userId, groupId, layoutPageTemplateCollectionId, layoutPageTemplateEntryKey, 0L, 0L, name, type, 0L, false, 0L, 0L, masterLayoutPlid, status, serviceContext);
    }

    public LayoutPageTemplateEntry copyLayoutPageTemplateEntry(long userId, long groupId, long layoutPageTemplateCollectionId, long sourceLayoutPageTemplateEntryId, boolean copyPermissions, ServiceContext serviceContext) throws Exception {
        FileEntry targetPreviewFileEntry;
        LayoutPageTemplateEntry sourceLayoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(sourceLayoutPageTemplateEntryId);
        String name = UniqueUtil.getCopyValue(copyValue -> {
            LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_L_N_T(groupId, layoutPageTemplateCollectionId, copyValue, sourceLayoutPageTemplateEntry.getType());
            if (layoutPageTemplateEntry == null) {
                return true;
            }
            return false;
        }, (String)sourceLayoutPageTemplateEntry.getName());
        long masterLayoutPlid = 0L;
        Layout layout = this._layoutLocalService.fetchLayout(sourceLayoutPageTemplateEntry.getPlid());
        if (layout != null) {
            masterLayoutPlid = layout.getMasterLayoutPlid();
        }
        LayoutPageTemplateEntry targetLayoutPageTemplateEntry = this.addLayoutPageTemplateEntry(null, userId, groupId, layoutPageTemplateCollectionId, null, sourceLayoutPageTemplateEntry.getClassNameId(), sourceLayoutPageTemplateEntry.getClassTypeId(), name, sourceLayoutPageTemplateEntry.getType(), 0L, false, sourceLayoutPageTemplateEntry.getLayoutPrototypeId(), 0L, masterLayoutPlid, 2, serviceContext);
        if (copyPermissions) {
            this._resourceLocalService.deleteResource(targetLayoutPageTemplateEntry.getCompanyId(), LayoutPageTemplateEntry.class.getName(), 4, targetLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
            this._resourceLocalService.copyModelResources(sourceLayoutPageTemplateEntry.getCompanyId(), LayoutPageTemplateEntry.class.getName(), sourceLayoutPageTemplateEntry.getLayoutPageTemplateEntryId(), targetLayoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        }
        if ((targetPreviewFileEntry = this._copyPreviewFileEntry(sourceLayoutPageTemplateEntry, targetLayoutPageTemplateEntry, serviceContext)) == null) {
            return targetLayoutPageTemplateEntry;
        }
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(targetLayoutPageTemplateEntry.getLayoutPageTemplateEntryId(), targetPreviewFileEntry.getFileEntryId());
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(LayoutPageTemplateEntry layoutPageTemplateEntry) throws PortalException {
        LayoutPrototype layoutPrototype;
        long layoutPrototypeId;
        this.layoutPageTemplateEntryPersistence.remove((BaseModel)layoutPageTemplateEntry);
        this._resourceLocalService.deleteResource(layoutPageTemplateEntry.getCompanyId(), LayoutPageTemplateEntry.class.getName(), 4, layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        Layout layout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        LayoutSet layoutSet = this._layoutSetLocalService.fetchLayoutSet(layoutPageTemplateEntry.getGroupId(), false);
        if (layout != null && layoutSet != null) {
            this._layoutLocalService.deleteLayout(layout);
        }
        if (!this._stagingGroupHelper.isLocalStagingGroup(layoutPageTemplateEntry.getGroupId()) && (layoutPrototypeId = layoutPageTemplateEntry.getLayoutPrototypeId()) > 0L && (layoutPrototype = this._layoutPrototypeLocalService.fetchLayoutPrototype(layoutPrototypeId)) != null) {
            this._layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototypeId);
        }
        if (layoutPageTemplateEntry.getPreviewFileEntryId() > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)layoutPageTemplateEntry.getPreviewFileEntryId());
        }
        if (Objects.equals(layoutPageTemplateEntry.getType(), 1) && layoutPageTemplateEntry.getClassTypeId() > 0L) {
            this._ddmStructureLinkLocalService.deleteStructureLinks(this._classNameLocalService.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
        }
        return layoutPageTemplateEntry;
    }

    @Override
    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(long layoutPageTemplateEntryId) throws PortalException {
        return this.layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(this.getLayoutPageTemplateEntry(layoutPageTemplateEntryId));
    }

    public LayoutPageTemplateEntry deleteLayoutPageTemplateEntry(String externalReferenceCode, long groupId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByERC_G(externalReferenceCode, groupId);
        return this.layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry fetchDefaultLayoutPageTemplateEntry(long groupId, long classNameId, long classTypeId) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_C_C_D_First(groupId, classNameId, classTypeId, true, null);
    }

    public LayoutPageTemplateEntry fetchFirstLayoutPageTemplateEntry(long layoutPrototypeId) {
        return this.layoutPageTemplateEntryPersistence.fetchByLayoutPrototypeId_First(layoutPrototypeId, null);
    }

    @Override
    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long layoutPageTemplateEntryId) {
        return this.layoutPageTemplateEntryPersistence.fetchByPrimaryKey(layoutPageTemplateEntryId);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long groupId, long layoutPageTemplateCollectionId, String name, int type) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_L_N_T(groupId, layoutPageTemplateCollectionId, name, type);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntry(long groupId, String layoutPageTemplateEntryKey) {
        return this.layoutPageTemplateEntryPersistence.fetchByG_LPTEK(groupId, layoutPageTemplateEntryKey);
    }

    public LayoutPageTemplateEntry fetchLayoutPageTemplateEntryByPlid(long plid) {
        return this.layoutPageTemplateEntryPersistence.fetchByPlid(plid);
    }

    public LayoutPageTemplateEntry getFirstLayoutPageTemplateEntry(long layoutPrototypeId) throws PortalException {
        return this.layoutPageTemplateEntryPersistence.findByLayoutPrototypeId_First(layoutPrototypeId, null);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId) {
        return this.layoutPageTemplateEntryPersistence.findByGroupId(groupId);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, int status) {
        return this.layoutPageTemplateEntryPersistence.findByG_S(groupId, status);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, -1, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int status, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        if (status == -1) {
            if (Validator.isNull((String)name)) {
                return this.layoutPageTemplateEntryPersistence.findByG_L(groupId, layoutPageTemplateCollectionId, start, end, orderByComparator);
            }
            return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN(groupId, layoutPageTemplateCollectionId, name, start, end, orderByComparator);
        }
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateEntryPersistence.findByG_L_S(groupId, layoutPageTemplateCollectionId, status, start, end, orderByComparator);
        }
        return this.layoutPageTemplateEntryPersistence.findByG_L_LikeN_S(groupId, layoutPageTemplateCollectionId, name, status, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntries(long groupId, long layoutPageTemplateCollectionId, String name, int start, int end, OrderByComparator<LayoutPageTemplateEntry> orderByComparator) {
        return this.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId, name, -1, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateEntry> getLayoutPageTemplateEntriesByLayoutPrototypeId(long layoutPrototypeId) {
        return this.layoutPageTemplateEntryPersistence.findByLayoutPrototypeId(layoutPrototypeId);
    }

    public LayoutPageTemplateEntry getLayoutPageTemplateEntry(long groupId, String layoutPageTemplateEntryKey) throws NoSuchPageTemplateEntryException {
        return this.layoutPageTemplateEntryPersistence.findByG_LPTEK(groupId, layoutPageTemplateEntryKey);
    }

    public String getUniqueLayoutPageTemplateEntryName(long groupId, long layoutPageTemplateCollectionId, String name, int type) {
        String newName;
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_L_N_T(groupId, layoutPageTemplateCollectionId, name, type);
        if (layoutPageTemplateEntry == null) {
            return name;
        }
        int count = 1;
        while ((layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_L_N_T(groupId, layoutPageTemplateCollectionId, newName = StringUtil.appendParentheticalSuffix((String)name, (int)count++), type)) != null) {
        }
        return newName;
    }

    public LayoutPageTemplateEntry moveLayoutPageTemplateEntry(long layoutPageTemplateEntryId, long targetLayoutPageTemplateCollectionId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.getLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry.getLayoutPageTemplateCollectionId() == targetLayoutPageTemplateCollectionId) {
            return layoutPageTemplateEntry;
        }
        this._validate(layoutPageTemplateEntry.getGroupId(), targetLayoutPageTemplateCollectionId, layoutPageTemplateEntry.getType());
        layoutPageTemplateEntry.setLayoutPageTemplateCollectionId(targetLayoutPageTemplateCollectionId);
        return this.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, boolean defaultTemplate) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry == null) {
            return null;
        }
        if (layoutPageTemplateEntry.getStatus() != 0) {
            throw new LayoutPageTemplateEntryDefaultTemplateException(layoutPageTemplateEntry.getType());
        }
        LayoutPageTemplateEntry defaultLayoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_C_C_D_First(layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getClassNameId(), layoutPageTemplateEntry.getClassTypeId(), true, null);
        if (defaultTemplate && defaultLayoutPageTemplateEntry != null && defaultLayoutPageTemplateEntry.getLayoutPageTemplateEntryId() != layoutPageTemplateEntryId) {
            layoutPageTemplateEntry.setModifiedDate(new Date());
            defaultLayoutPageTemplateEntry.setDefaultTemplate(false);
            this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(defaultLayoutPageTemplateEntry);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setDefaultTemplate(defaultTemplate);
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, long previewFileEntryId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setPreviewFileEntryId(previewFileEntryId);
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long userId, long layoutPageTemplateEntryId, long classNameId, long classTypeId) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        Layout draftLayout = this._layoutLocalService.fetchDraftLayout(layoutPageTemplateEntry.getPlid());
        if (draftLayout != null && !draftLayout.isUnlocked("edit", userId)) {
            throw new LockedLayoutException();
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setClassNameId(classNameId);
        layoutPageTemplateEntry.setClassTypeId(classTypeId);
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long userId, long layoutPageTemplateEntryId, String name, int status) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (!Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            this._validate(layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getLayoutPageTemplateCollectionId(), name, layoutPageTemplateEntry.getType(), layoutPageTemplateEntry.isDefaultTemplate(), status);
        }
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setLayoutPageTemplateEntryKey(this._generateLayoutPageTemplateEntryKey(layoutPageTemplateEntry.getGroupId(), name));
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public LayoutPageTemplateEntry updateLayoutPageTemplateEntry(long layoutPageTemplateEntryId, String name) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (Objects.equals(layoutPageTemplateEntry.getName(), name)) {
            return layoutPageTemplateEntry;
        }
        this._validate(layoutPageTemplateEntry.getGroupId(), layoutPageTemplateEntry.getLayoutPageTemplateCollectionId(), name, layoutPageTemplateEntry.getType());
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setLayoutPageTemplateEntryKey(this._generateLayoutPageTemplateEntryKey(layoutPageTemplateEntry.getGroupId(), name));
        layoutPageTemplateEntry.setName(name);
        layoutPageTemplateEntry = this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        Layout draftLayout = this._layoutLocalService.fetchDraftLayout(layoutPageTemplateEntry.getPlid());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        this._layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), draftLayout.getParentLayoutId(), titleMap, titleMap, draftLayout.getDescriptionMap(), draftLayout.getKeywordsMap(), draftLayout.getRobotsMap(), draftLayout.getType(), draftLayout.isHidden(), draftLayout.getFriendlyURLMap(), draftLayout.getIconImage(), null, draftLayout.getStyleBookEntryERC(), draftLayout.getFaviconFileEntryId(), draftLayout.getMasterLayoutPlid(), serviceContext);
        Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getParentLayoutId(), titleMap, titleMap, layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getType(), layout.isHidden(), layout.getFriendlyURLMap(), layout.getIconImage(), null, layout.getStyleBookEntryERC(), layout.getFaviconFileEntryId(), layout.getMasterLayoutPlid(), serviceContext);
        return layoutPageTemplateEntry;
    }

    public LayoutPageTemplateEntry updateStatus(long userId, long layoutPageTemplateEntryId, int status) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.findByPrimaryKey(layoutPageTemplateEntryId);
        if (layoutPageTemplateEntry.isDefaultTemplate() && status != 0) {
            throw new LayoutPageTemplateEntryDefaultTemplateException(layoutPageTemplateEntry.getType());
        }
        User user = this._userLocalService.getUser(userId);
        layoutPageTemplateEntry.setModifiedDate(new Date());
        layoutPageTemplateEntry.setStatus(status);
        layoutPageTemplateEntry.setStatusByUserId(userId);
        layoutPageTemplateEntry.setStatusByUserName(user.getScreenName());
        layoutPageTemplateEntry.setStatusDate(new Date());
        return this.layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
    }

    private Layout _addLayout(long userId, long groupId, String name, int type, long masterLayoutPlid, int status, ServiceContext serviceContext) throws PortalException {
        boolean privateLayout = false;
        String layoutType = "asset_display";
        if (type == 0 || type == 3) {
            privateLayout = true;
            layoutType = "content";
        }
        Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), name);
        UnicodeProperties typeSettingsUnicodeProperties = new UnicodeProperties();
        if (status == 0) {
            typeSettingsUnicodeProperties.put("published", "true");
        }
        if (type == 3 || masterLayoutPlid > 0L) {
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-footer", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header-search", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:wrap-widget-page-content", Boolean.FALSE.toString());
        }
        String typeSettings = typeSettingsUnicodeProperties.toString();
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("layout.page.template.entry.type", (Serializable)Integer.valueOf(type));
        Layout layout = this._layoutLocalService.addLayout(null, userId, groupId, privateLayout, 0L, 0L, 0L, titleMap, titleMap, null, null, null, layoutType, typeSettings, true, true, new HashMap(), masterLayoutPlid, serviceContext);
        Layout draftLayout = layout.fetchDraftLayout();
        if (type == 3 || masterLayoutPlid > 0L) {
            LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, false);
            String themeId = layoutSet.getThemeId();
            String colorSchemeId = this._getColorSchemeId(layout.getCompanyId(), themeId, "");
            this._layoutLocalService.updateLookAndFeel(groupId, privateLayout, draftLayout.getLayoutId(), themeId, colorSchemeId, "");
            layout = this._layoutLocalService.updateLookAndFeel(groupId, privateLayout, layout.getLayoutId(), themeId, colorSchemeId, "");
        }
        return layout;
    }

    private LayoutPageTemplateEntry _addLayoutPageTemplateEntry(long groupId, LayoutPrototype layoutPrototype) throws PortalException {
        String nameXML = layoutPrototype.getName();
        Map nameMap = this._localization.getLocalizationMap(nameXML);
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)this._localization.getDefaultLanguageId(nameXML));
        Layout layout = layoutPrototype.getLayout();
        int status = 0;
        if (!layoutPrototype.isActive()) {
            status = 5;
        }
        return this.addLayoutPageTemplateEntry(null, layoutPrototype.getUserId(), groupId, 0L, null, 0L, 0L, (String)nameMap.get(defaultLocale), 2, 0L, false, layoutPrototype.getLayoutPrototypeId(), layout.getPlid(), 0L, status, new ServiceContext());
    }

    private FileEntry _copyPreviewFileEntry(LayoutPageTemplateEntry sourceLayoutPageTemplateEntry, LayoutPageTemplateEntry targetLayoutPageTemplateEntry, ServiceContext serviceContext) throws Exception {
        long sourcePreviewFileEntryId = sourceLayoutPageTemplateEntry.getPreviewFileEntryId();
        if (sourcePreviewFileEntryId <= 0L) {
            return null;
        }
        FileEntry portletFileEntry = this._portletFileRepository.getPortletFileEntry(sourcePreviewFileEntryId);
        Folder folder = portletFileEntry.getFolder();
        long targetLayoutPageTemplateEntryId = targetLayoutPageTemplateEntry.getLayoutPageTemplateEntryId();
        String fileName = targetLayoutPageTemplateEntryId + "_preview." + portletFileEntry.getExtension();
        return this._portletFileRepository.addPortletFileEntry(portletFileEntry.getGroupId(), serviceContext.getUserId(), LayoutPageTemplateEntry.class.getName(), targetLayoutPageTemplateEntryId, "com_liferay_layout_admin_web_portlet_GroupPagesPortlet", folder.getFolderId(), this._file.getBytes(portletFileEntry.getContentStream()), fileName, portletFileEntry.getMimeType(), false);
    }

    private String _generateLayoutPageTemplateEntryKey(long groupId, String name) {
        String layoutPageTemplateEntryKey = StringUtil.toLowerCase((String)name.trim());
        layoutPageTemplateEntryKey = StringUtil.replace((String)layoutPageTemplateEntryKey, (char)' ', (char)'-');
        Object curLayoutPageTemplateEntryKey = layoutPageTemplateEntryKey;
        int count = 0;
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        while ((layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_LPTEK(groupId, (String)curLayoutPageTemplateEntryKey)) != null) {
            curLayoutPageTemplateEntryKey = (String)curLayoutPageTemplateEntryKey + "-" + count++;
        }
        return curLayoutPageTemplateEntryKey;
    }

    private String _getColorSchemeId(long companyId, String themeId, String colorSchemeId) {
        Theme theme = this._themeLocalService.getTheme(companyId, themeId);
        if (!theme.hasColorSchemes()) {
            colorSchemeId = "";
        }
        if (Validator.isNull((String)colorSchemeId)) {
            ColorScheme colorScheme = this._themeLocalService.getColorScheme(companyId, themeId, colorSchemeId);
            colorSchemeId = colorScheme.getColorSchemeId();
        }
        return colorSchemeId;
    }

    private void _validate(long groupId, long layoutPageTemplateCollectionId, int type) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        if (group.isDepot()) {
            throw new LayoutPageTemplateEntryGroupIdException();
        }
        if (group.isCompany()) {
            if (!Objects.equals(2, type)) {
                throw new LayoutPageTemplateEntryGroupIdException();
            }
            if (layoutPageTemplateCollectionId != 0L) {
                throw new LayoutPageTemplateEntryLayoutPageTemplateCollectionIdException();
            }
            return;
        }
        if (Objects.equals(1, type)) {
            if (layoutPageTemplateCollectionId == 0L) {
                return;
            }
            LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionPersistence.findByPrimaryKey(layoutPageTemplateCollectionId);
            if (layoutPageTemplateCollection.getType() != 1) {
                throw new LayoutPageTemplateEntryLayoutPageTemplateCollectionIdException();
            }
            return;
        }
        if (Objects.equals(3, type)) {
            if (layoutPageTemplateCollectionId != 0L) {
                throw new LayoutPageTemplateEntryLayoutPageTemplateCollectionIdException();
            }
            return;
        }
        if (layoutPageTemplateCollectionId == 0L) {
            throw new LayoutPageTemplateEntryLayoutPageTemplateCollectionIdException();
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionPersistence.findByPrimaryKey(layoutPageTemplateCollectionId);
        if (layoutPageTemplateCollection.getType() != 0) {
            throw new LayoutPageTemplateEntryLayoutPageTemplateCollectionIdException();
        }
    }

    private void _validate(long groupId, long classNameId, long classTypeId) throws PortalException {
        String className = "";
        try {
            className = this._portal.getClassName(classNameId);
        }
        catch (RuntimeException runtimeException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)runtimeException);
            }
            throw new NoSuchClassNameException("Class name does not exist for class name ID " + classNameId);
        }
        InfoItemFormProvider infoItemFormProvider = (InfoItemFormProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormProvider.class, className);
        if (infoItemFormProvider == null) {
            throw new PortalException("No item form provider is registered for class name ID " + classNameId);
        }
        InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormVariationsProvider.class, className);
        if (infoItemFormVariationsProvider == null) {
            return;
        }
        InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariation(groupId, String.valueOf(classTypeId));
        if (infoItemFormVariation == null) {
            throw new NoSuchClassTypeException("Class type does not exist for class name ID " + classNameId);
        }
    }

    private void _validate(long groupId, long layoutPageTemplateCollectionId, String name, int type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeNull();
        }
        Character character = LayoutValidator.getBlacklistCharacter((String)name);
        if (character != null) {
            throw new LayoutPageTemplateEntryNameException.MustNotContainInvalidCharacters(character.charValue());
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutPageTemplateEntryNameException.MustNotExceedMaximumSize(nameMaxLength);
        }
        if (Objects.equals(name, "Blank") && type == 3) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeDuplicate(groupId, name);
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_L_N_T(groupId, layoutPageTemplateCollectionId, name, type);
        if (layoutPageTemplateEntry != null) {
            throw new LayoutPageTemplateEntryNameException.MustNotBeDuplicate(groupId, name);
        }
    }

    private void _validate(long groupId, long layoutPageTemplateCollectionId, String name, int type, boolean defaultTemplate, int status) throws PortalException {
        if (defaultTemplate && status != 0) {
            throw new LayoutPageTemplateEntryDefaultTemplateException(type);
        }
        this._validate(groupId, layoutPageTemplateCollectionId, name, type);
    }

    private void _validateLayoutPageTemplateEntryKey(long groupId, String layoutPageTemplateEntryKey, int type) throws PortalException {
        if (LayoutValidator.hasBlacklistedChar((String)layoutPageTemplateEntryKey)) {
            throw new LayoutPageTemplateEntryLayoutPageTemplateEntryKeyException.MustNotContainInvalidCharacters(layoutPageTemplateEntryKey, type);
        }
        int layoutPageTemplateEntryKeyMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"layoutPageTemplateEntryKey");
        if (layoutPageTemplateEntryKey.length() > layoutPageTemplateEntryKeyMaxLength) {
            throw new LayoutPageTemplateEntryLayoutPageTemplateEntryKeyException.MustNotExceedMaximumSize(layoutPageTemplateEntryKey, layoutPageTemplateEntryKeyMaxLength, type);
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this.layoutPageTemplateEntryPersistence.fetchByG_LPTEK(groupId, layoutPageTemplateEntryKey);
        if (layoutPageTemplateEntry != null) {
            throw new LayoutPageTemplateEntryLayoutPageTemplateEntryKeyException.MustNotBeDuplicate(groupId, layoutPageTemplateEntryKey, type);
        }
    }
}

