/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.service.impl;

import com.liferay.layout.page.template.exception.DuplicateLayoutPageTemplateCollectionException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateCollectionGroupIdException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateCollectionLayoutPageTemplateCollectionKeyException;
import com.liferay.layout.page.template.exception.LayoutPageTemplateCollectionNameException;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.base.LayoutPageTemplateCollectionLocalServiceBaseImpl;
import com.liferay.layout.validator.LayoutValidator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateCollection"}, service={AopService.class})
public class LayoutPageTemplateCollectionLocalServiceImpl
extends LayoutPageTemplateCollectionLocalServiceBaseImpl {
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public LayoutPageTemplateCollection addLayoutPageTemplateCollection(String externalReferenceCode, long userId, long groupId, long parentLayoutPageTemplateCollectionId, String layoutPageTemplateCollectionKey, String name, String description, int type, ServiceContext serviceContext) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        if (group.isCompany() || group.isDepot()) {
            throw new LayoutPageTemplateCollectionGroupIdException();
        }
        User user = this._userLocalService.getUser(userId);
        this._validate(groupId, name, parentLayoutPageTemplateCollectionId, type);
        if (Validator.isNull((String)layoutPageTemplateCollectionKey)) {
            layoutPageTemplateCollectionKey = this._generateLayoutPageTemplateCollectionKey(groupId, name, type);
        } else {
            this._validateLayoutPageTemplateCollectionKey(groupId, layoutPageTemplateCollectionKey, type);
        }
        long layoutPageTemplateId = this.counterLocalService.increment();
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.create(layoutPageTemplateId);
        layoutPageTemplateCollection.setUuid(serviceContext.getUuid());
        layoutPageTemplateCollection.setExternalReferenceCode(externalReferenceCode);
        layoutPageTemplateCollection.setGroupId(groupId);
        layoutPageTemplateCollection.setCompanyId(user.getCompanyId());
        layoutPageTemplateCollection.setUserId(user.getUserId());
        layoutPageTemplateCollection.setUserName(user.getFullName());
        layoutPageTemplateCollection.setCreateDate(serviceContext.getCreateDate(new Date()));
        layoutPageTemplateCollection.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutPageTemplateCollection.setParentLayoutPageTemplateCollectionId(parentLayoutPageTemplateCollectionId);
        layoutPageTemplateCollection.setLayoutPageTemplateCollectionKey(layoutPageTemplateCollectionKey);
        layoutPageTemplateCollection.setName(name);
        layoutPageTemplateCollection.setDescription(description);
        layoutPageTemplateCollection.setType(type);
        layoutPageTemplateCollection = (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
        this._resourceLocalService.addModelResources((AuditedModel)layoutPageTemplateCollection, serviceContext);
        return layoutPageTemplateCollection;
    }

    public LayoutPageTemplateCollection copyLayoutPageTemplateCollection(long userId, long groupId, long sourceLayoutPageTemplateCollectionId, long layoutParentPageTemplateCollectionId, boolean copyPermissions, ServiceContext serviceContext) throws Exception {
        LayoutPageTemplateCollection sourceLayoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.findByPrimaryKey(sourceLayoutPageTemplateCollectionId);
        LayoutPageTemplateCollection targetLayoutPageTemplateCollection = this.addLayoutPageTemplateCollection(null, userId, sourceLayoutPageTemplateCollection.getGroupId(), layoutParentPageTemplateCollectionId, null, this.getUniqueLayoutPageTemplateCollectionName(groupId, layoutParentPageTemplateCollectionId, sourceLayoutPageTemplateCollection.getName(), sourceLayoutPageTemplateCollection.getType()), sourceLayoutPageTemplateCollection.getDescription(), sourceLayoutPageTemplateCollection.getType(), serviceContext);
        if (copyPermissions) {
            this._resourceLocalService.deleteResource(targetLayoutPageTemplateCollection.getCompanyId(), LayoutPageTemplateCollection.class.getName(), 4, targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
            this._resourceLocalService.copyModelResources(sourceLayoutPageTemplateCollection.getCompanyId(), LayoutPageTemplateCollection.class.getName(), sourceLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        }
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(sourceLayoutPageTemplateCollection.getGroupId(), sourceLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            this._layoutPageTemplateEntryLocalService.copyLayoutPageTemplateEntry(userId, groupId, targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), copyPermissions, serviceContext);
        }
        List<LayoutPageTemplateCollection> layoutPageTemplateCollections = this.getLayoutPageTemplateCollections(sourceLayoutPageTemplateCollection.getGroupId(), sourceLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateCollection layoutPageTemplateCollection : layoutPageTemplateCollections) {
            this.copyLayoutPageTemplateCollection(userId, groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), targetLayoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), copyPermissions, serviceContext);
        }
        return targetLayoutPageTemplateCollection;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(LayoutPageTemplateCollection layoutPageTemplateCollection) throws PortalException {
        this.layoutPageTemplateCollectionPersistence.remove((BaseModel)layoutPageTemplateCollection);
        List layoutPageTemplateCollections = this.layoutPageTemplateCollectionPersistence.findByG_P(layoutPageTemplateCollection.getGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateCollection curLayoutPageTemplateCollection : layoutPageTemplateCollections) {
            this.layoutPageTemplateCollectionLocalService.deleteLayoutPageTemplateCollection(curLayoutPageTemplateCollection);
        }
        this._resourceLocalService.deleteResource(layoutPageTemplateCollection.getCompanyId(), LayoutPageTemplateCollection.class.getName(), 4, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(layoutPageTemplateCollection.getGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            this._layoutPageTemplateEntryLocalService.deleteLayoutPageTemplateEntry(layoutPageTemplateEntry);
        }
        return layoutPageTemplateCollection;
    }

    @Override
    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) throws PortalException {
        return this.layoutPageTemplateCollectionLocalService.deleteLayoutPageTemplateCollection(this.getLayoutPageTemplateCollection(layoutPageTemplateCollectionId));
    }

    public LayoutPageTemplateCollection deleteLayoutPageTemplateCollection(String externalReferenceCode, long groupId) throws PortalException {
        return this.layoutPageTemplateCollectionLocalService.deleteLayoutPageTemplateCollection(this.getLayoutPageTemplateCollectionByExternalReferenceCode(externalReferenceCode, groupId));
    }

    @Override
    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long layoutPageTemplateCollectionId) {
        return this.layoutPageTemplateCollectionPersistence.fetchByPrimaryKey(layoutPageTemplateCollectionId);
    }

    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long groupId, String layoutPageTemplateCollectionKey, int type) {
        return this.layoutPageTemplateCollectionPersistence.fetchByG_LPTCK_T(groupId, layoutPageTemplateCollectionKey, type);
    }

    public LayoutPageTemplateCollection fetchLayoutPageTemplateCollection(long groupId, String name, long parentLayoutPageTemplateCollectionId, int type) {
        return this.layoutPageTemplateCollectionPersistence.fetchByG_P_N_T(groupId, parentLayoutPageTemplateCollectionId, name, type);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId) {
        return this.layoutPageTemplateCollectionPersistence.findByGroupId(groupId);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int type, int start, int end) {
        return this.layoutPageTemplateCollectionPersistence.findByG_T(groupId, type, start, end);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, int type, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        return this.layoutPageTemplateCollectionPersistence.findByG_T(groupId, type, start, end, orderByComparator);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, long layoutPageTemplateCollectionId) {
        return this.layoutPageTemplateCollectionPersistence.findByG_P(groupId, layoutPageTemplateCollectionId);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, long layoutPageTemplateCollectionId, int type) {
        return this.layoutPageTemplateCollectionPersistence.findByG_P_T(groupId, layoutPageTemplateCollectionId, type);
    }

    public List<LayoutPageTemplateCollection> getLayoutPageTemplateCollections(long groupId, String name, int type, int start, int end, OrderByComparator<LayoutPageTemplateCollection> orderByComparator) {
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateCollectionPersistence.findByG_T(groupId, type, start, end, orderByComparator);
        }
        return this.layoutPageTemplateCollectionPersistence.findByG_LikeN_T(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], type, start, end, orderByComparator);
    }

    public int getLayoutPageTemplateCollectionsCount(long groupId, int type) {
        return this.layoutPageTemplateCollectionPersistence.countByG_T(groupId, type);
    }

    public int getLayoutPageTemplateCollectionsCount(long groupId, String name, int type) {
        if (Validator.isNull((String)name)) {
            return this.layoutPageTemplateCollectionPersistence.countByG_T(groupId, type);
        }
        return this.layoutPageTemplateCollectionPersistence.countByG_LikeN_T(groupId, this._customSQL.keywords(name, false, WildcardMode.SURROUND)[0], type);
    }

    public String getUniqueLayoutPageTemplateCollectionName(long groupId, long layoutPageTemplateCollectionId, String sourceName, int type) throws PortalException {
        return UniqueUtil.getCopyValue(copyValue -> {
            LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_P_N_T(groupId, layoutPageTemplateCollectionId, copyValue, type);
            if (layoutPageTemplateCollection == null) {
                return true;
            }
            return false;
        }, (String)sourceName);
    }

    public LayoutPageTemplateCollection moveLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, long parentLayoutPageTemplateCollectionId) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionLocalService.getLayoutPageTemplateCollection(layoutPageTemplateCollectionId);
        if (parentLayoutPageTemplateCollectionId == layoutPageTemplateCollection.getLayoutPageTemplateCollectionId() || parentLayoutPageTemplateCollectionId == layoutPageTemplateCollection.getParentLayoutPageTemplateCollectionId()) {
            return layoutPageTemplateCollection;
        }
        layoutPageTemplateCollection.setParentLayoutPageTemplateCollectionId(parentLayoutPageTemplateCollectionId);
        return this.updateLayoutPageTemplateCollection(layoutPageTemplateCollection);
    }

    @Indexable(type=IndexableType.REINDEX)
    public LayoutPageTemplateCollection updateLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, String name) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.findByPrimaryKey(layoutPageTemplateCollectionId);
        if (!Objects.equals(layoutPageTemplateCollection.getName(), name)) {
            this._validate(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getParentLayoutPageTemplateCollectionId(), layoutPageTemplateCollection.getType());
        }
        layoutPageTemplateCollection.setLayoutPageTemplateCollectionKey(this._generateLayoutPageTemplateCollectionKey(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getType()));
        layoutPageTemplateCollection.setName(name);
        return (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
    }

    @Indexable(type=IndexableType.REINDEX)
    public LayoutPageTemplateCollection updateLayoutPageTemplateCollection(long layoutPageTemplateCollectionId, String name, String description) throws PortalException {
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.findByPrimaryKey(layoutPageTemplateCollectionId);
        if (!Objects.equals(layoutPageTemplateCollection.getName(), name)) {
            this._validate(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getParentLayoutPageTemplateCollectionId(), layoutPageTemplateCollection.getType());
        }
        layoutPageTemplateCollection.setModifiedDate(new Date());
        layoutPageTemplateCollection.setLayoutPageTemplateCollectionKey(this._generateLayoutPageTemplateCollectionKey(layoutPageTemplateCollection.getGroupId(), name, layoutPageTemplateCollection.getType()));
        layoutPageTemplateCollection.setName(name);
        layoutPageTemplateCollection.setDescription(description);
        return (LayoutPageTemplateCollection)this.layoutPageTemplateCollectionPersistence.update((BaseModel)layoutPageTemplateCollection);
    }

    private String _generateLayoutPageTemplateCollectionKey(long groupId, String name, int type) {
        String layoutPageTemplateCollectionKey = StringUtil.replace((String)StringUtil.toLowerCase((String)name.trim()), (char[])new char[]{'/', ' '}, (char[])new char[]{'-', '-'});
        Object curLayoutPageTemplateCollectionKey = layoutPageTemplateCollectionKey;
        int count = 0;
        LayoutPageTemplateCollection layoutPageTemplateCollection;
        while ((layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_LPTCK_T(groupId, (String)curLayoutPageTemplateCollectionKey, type)) != null) {
            curLayoutPageTemplateCollectionKey = (String)curLayoutPageTemplateCollectionKey + "-" + count++;
        }
        return curLayoutPageTemplateCollectionKey;
    }

    private void _validate(long groupId, String name, long parentLayoutPageTemplateCollection, int type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutPageTemplateCollectionNameException("Name must not be null");
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateEntry.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new LayoutPageTemplateCollectionNameException("Maximum length of name exceeded " + nameMaxLength);
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_P_N_T(groupId, parentLayoutPageTemplateCollection, name, type);
        if (layoutPageTemplateCollection != null) {
            throw new DuplicateLayoutPageTemplateCollectionException(name);
        }
    }

    private void _validateLayoutPageTemplateCollectionKey(long groupId, String layoutPageTemplateCollectionKey, int type) throws PortalException {
        if (LayoutValidator.hasBlacklistedChar((String)layoutPageTemplateCollectionKey)) {
            throw new LayoutPageTemplateCollectionLayoutPageTemplateCollectionKeyException.MustNotContainInvalidCharacters(layoutPageTemplateCollectionKey, type);
        }
        int layoutPageTemplateCollectionKeyMaxLength = ModelHintsUtil.getMaxLength((String)LayoutPageTemplateCollection.class.getName(), (String)"layoutPageTemplateCollectionKey");
        if (layoutPageTemplateCollectionKey.length() > layoutPageTemplateCollectionKeyMaxLength) {
            throw new LayoutPageTemplateCollectionLayoutPageTemplateCollectionKeyException.MustNotExceedMaximumSize(layoutPageTemplateCollectionKey, layoutPageTemplateCollectionKeyMaxLength, type);
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this.layoutPageTemplateCollectionPersistence.fetchByG_LPTCK_T(groupId, layoutPageTemplateCollectionKey, type);
        if (layoutPageTemplateCollection != null) {
            throw new LayoutPageTemplateCollectionLayoutPageTemplateCollectionKeyException.MustNotBeDuplicate(groupId, layoutPageTemplateCollectionKey, type);
        }
    }
}

