/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v3_4_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Objects;

public class FragmentEntryLinkEditableValuesUpgradeProcess
extends UpgradeProcess {
    private static final String[] _ALIGN_KEYS = new String[]{"buttonAlign", "contentAlign", "imageAlign"};
    private static final Map<String, String> _borderRadiuses = HashMapBuilder.put((Object)"lg", (Object)"0.375rem").put((Object)"none", (Object)"").put((Object)"sm", (Object)"0.1875rem").build();
    private static final Map<String, String> _colors = HashMapBuilder.put((Object)"danger", (Object)"#DA1414").put((Object)"dark", (Object)"#272833").put((Object)"gray-dark", (Object)"#393A4A").put((Object)"info", (Object)"#2E5AAC").put((Object)"light", (Object)"#F1F2F5").put((Object)"lighter", (Object)"#F7F8F9").put((Object)"primary", (Object)"#0B5FFF").put((Object)"secondary", (Object)"#6B6C7E").put((Object)"success", (Object)"#287D3C").put((Object)"warning", (Object)"#B95000").put((Object)"white", (Object)"#FFFFFF").build();
    private static final Map<String, String> _shadows = HashMapBuilder.put((Object)"lg", (Object)"0 1rem 3rem rgba(0, 0, 0, .175)").put((Object)"sm", (Object)"0 .125rem .25rem rgba(0, 0, 0, .075)").build();

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, fragmentEntryLinkId, editableValues, rendererKey from FragmentEntryLink where rendererKey like 'BASIC_COMPONENT%'");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update FragmentEntryLink set editableValues = ? where ctCollectionId = ? and fragmentEntryLinkId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                JSONObject editablesJSONObject = JSONFactoryUtil.createJSONObject((String)resultSet.getString("editableValues"));
                JSONObject configurationJSONObject = editablesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.freemarker.FreeMarkerFragmentEntryProcessor");
                if (configurationJSONObject == null) continue;
                this._replaceAlign(configurationJSONObject);
                this._replaceBorderRadius(configurationJSONObject);
                this._replaceBottomSpacing(configurationJSONObject);
                this._replaceShadow(configurationJSONObject);
                this._replaceTextColor(configurationJSONObject);
                String rendererKey = resultSet.getString("rendererKey");
                if (Objects.equals(rendererKey, "BASIC_COMPONENT-separator") && configurationJSONObject.has("borderColor")) {
                    configurationJSONObject.put("separatorColor", configurationJSONObject.remove("borderColor"));
                }
                if (Objects.equals(rendererKey, "BASIC_COMPONENT-video")) {
                    if (configurationJSONObject.has("height")) {
                        configurationJSONObject.put("videoHeight", configurationJSONObject.remove("height"));
                    }
                    if (configurationJSONObject.has("width")) {
                        configurationJSONObject.put("videoWidth", configurationJSONObject.remove("width"));
                    }
                }
                preparedStatement2.setString(1, editablesJSONObject.toString());
                preparedStatement2.setLong(2, resultSet.getLong("ctCollectionId"));
                preparedStatement2.setLong(3, resultSet.getLong("fragmentEntryLinkId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _replaceAlign(JSONObject configurationJSONObject) {
        for (String key : _ALIGN_KEYS) {
            if (!configurationJSONObject.has(key)) continue;
            configurationJSONObject.put("textAlign", configurationJSONObject.remove(key));
            break;
        }
    }

    private void _replaceBorderRadius(JSONObject configurationJSONObject) {
        if (!configurationJSONObject.has("borderRadius")) {
            return;
        }
        configurationJSONObject.put("borderRadius", _borderRadiuses.get(configurationJSONObject.remove("borderRadius")));
    }

    private void _replaceBottomSpacing(JSONObject configurationJSONObject) {
        if (!configurationJSONObject.has("bottomSpacing")) {
            return;
        }
        configurationJSONObject.put("marginBottom", configurationJSONObject.remove("bottomSpacing"));
    }

    private void _replaceShadow(JSONObject configurationJSONObject) {
        if (!configurationJSONObject.has("boxShadow")) {
            return;
        }
        String shadowCssClass = GetterUtil.getString((Object)configurationJSONObject.remove("boxShadow"));
        if (!_shadows.containsKey(shadowCssClass)) {
            return;
        }
        configurationJSONObject.put("shadow", _shadows.get(shadowCssClass));
    }

    private void _replaceTextColor(JSONObject configurationJSONObject) {
        JSONObject textColorJSONObject = configurationJSONObject.getJSONObject("textColor");
        if (textColorJSONObject == null) {
            return;
        }
        if (Validator.isNotNull((String)textColorJSONObject.getString("cssClass"))) {
            configurationJSONObject.put("textColor", _colors.getOrDefault(textColorJSONObject.getString("cssClass"), textColorJSONObject.getString("cssClass")));
        } else if (Validator.isNotNull((String)textColorJSONObject.getString("color"))) {
            configurationJSONObject.put("textColor", _colors.getOrDefault(textColorJSONObject.getString("color"), textColorJSONObject.getString("color")));
        } else if (Validator.isNotNull((String)textColorJSONObject.getString("rgbValue"))) {
            configurationJSONObject.put("textColor", textColorJSONObject.getString("rgbValue"));
        }
    }
}

